<?PHP

#############################################################################
#                              Site@School
# Site@School is a website management system designed for schools.
#
# About Site@School:
# Comissioned by: City District 'de Baarsjes', Amsterdam, Netherlands
# Original idea, coding (version 1.0) and design : Mark de Haan (mark@starwave.nl)
# Ideas, improvements, expansions (version 1.1 - 2.3): Fred Stuurman 
# Current coder & maintainer: Fred Stuurman (fc.stuurman@hccnet.nl)
############################################################################
# index.php: last changed 01/03/2006  , version: 2.4
#            by Fred Stuurman  (fc.stuurman@hccnet.nl)
#$Id: index.php,v 1.2 2006/10/15 19:08:53 fstuurman Exp $
############################################################################
#                        LICENSE INFORMATION
# Copyright (C) 2002 - 2005 Municipality of Amsterdam, City District
#  'de Baarsjes', Amsterdam, the Netherlands.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##############################################################################

define('IN_SAS', true);
define('SAS_VERSION', '2.4.10');

$old_error_reporting = error_reporting(0); // switch off error reporting during sanity checks

function error_exit($conditioncode, $ttl = "Error")
{
	/*---------------------------------
	 * Show a 'cryptic' condition code + exit
	 */
	echo "<html>\n<head>\n<title>$ttl</title>\n</head>\n<body>\n" .
	"<h1>$ttl</h1>\n" .
	"<b>There is a problem with this site.</b>\n<p>\n" .
	"Please contact the site owner mentioning the " .
	"following condition code:\n<p>\n<b>" .
	SAS_VERSION . '/' . $conditioncode . "</b>\n<p>\n" .
	"Thank you for your cooperation!\n</body>\n</html>\n";
	exit;
} /* error_exit() */

// SANITY CHECK #1 - is there an existing installation at the location we expect?
if (!file_exists('configuration/database.inc.php'))
{
	error_exit('010');
}

// SANITY CHECK #2 - do we have a connection to a working database?
include ('configuration/database.inc.php');
if (!($db = mysql_connect($db_server, $db_username, $db_password)))
{
	error_exit('020');
}

// SANITY CHECK #3 - do we have access to our own database?
if (!mysql_select_db($db_name))
{
	error_exit('030');
}

/*
 * Still here? Must have valid database in our hands then. Carry on...
 */

require ("core/session.php"); //build a session

include ("core/common.inc.php"); //include common functions

unset ($sas_config); //clear the config array first
$query = "SELECT config_key,config_value FROM $table_configuration WHERE config_key NOT LIKE 'agenda_t%'";
//read all the configuration items except agenda options.

$result = mysql_query($query);
while ($config_list = mysql_fetch_array($result))
{
	$sas_config[$config_list[0]] = $config_list[1]; //put them in the config array
}

if ($sas_config['sessioncode'] == "")
{
	error_exit('060');
}
error_reporting($old_error_reporting); // switch on error reporting after sanity checks

if (IsSet ($_GET['option']))
{
	$option = htmlspecialchars(strip_tags($_GET['option']));
}
else
{
	unset ($option);
}

if (IsSet ($_POST['submitted']))
{
	$submitted = htmlspecialchars(strip_tags($_POST['submitted']));
}

if (IsSet ($_SESSION['userid']))
{
	$userid = $_SESSION['userid'];
}
else
{
	unset ($userid);
}

$check_sessioncode = $sas_config['sessioncode'];
$site_url = $sas_config['url'];
$userpath = $sas_config['user_path']; //get the directoryname of the cms
if (substr($userpath, 0, 1) == "/")
{
	$userpath = substr($userpath, 1); //strip first slash
}

$serverpath = $sas_config['serverpath']; //get the document root of the site
if (strrpos($serverpath, '/') != strlen($serverpath) - 1)
{
	$serverpath .= '/'; //add last slash if not present
}
$serverpath = $serverpath . $userpath;
$sitename = $sas_config['sitename'];
$cmsdir = substr(strrchr($serverpath, "/"), 1); //get the directoryname of the cms
$media = $sas_config['media_dir']; //media directory
$studentpages = $sas_config['studentpages_dir']; //pupilpages directory

$language = $sas_config['language'];
load_language('', '/'); //load language file

$date_format = $sas_config['dateformat'];
if (IsSet ($submitted))
{
	if (!verify_logon($_POST['sn_username'], $_POST['sn_password'], "admin"))
	{
		print "<script language=\"Javascript\">
							   <!--
							   alert (\"" . $sas_lang['login_error'] . "\");
							   window.location = 'index.php' ;	
							   //-->
							   </script>";
	}
	$dir = "install/";
	$error = FALSE;
	// Open a known directory, and proceed to read its contents
	if (is_dir($dir))
	{
		if ($dh = opendir($dir))
		{
			while (($file = readdir($dh)) !== false)
			{
				if (substr($file, strrpos($file, '.')) == ".php")
				{
					$error = TRUE;
				}
			}
			closedir($dh);
		}
	}
	if ($error == TRUE) //if install is not empty , give warning.
	{
		print "<script language=\"Javascript\">
							   <!--
							   alert (\"Security warning: Please delete the contents of the $cmsdir/install directory!\")
							   //-->
							   </script>";
	}
	//   include("addons/logging.php");
}

if (IsSet ($_SESSION['userid']))
{
	$query = "SELECT editor, highvisibility, access, type FROM $table_users WHERE id = '" . $_SESSION[userid] . "'"; // getting the editor for the user
	$result = mysql_query($query) or die_script($query, mysql_error());
	if (mysql_num_rows($result) == 1)
	{
		$editor = mysql_result($result, 0, 0);
		$highvisibility = mysql_result($result, 0, 1);
		$access = mysql_result($result, 0, 2);
		$usertype = mysql_result($result, 0, 3);
	}
	$_SESSION['editor'] = $editor;
	$_SESSION['highvisibility'] = $highvisibility;
	$_SESSION['access'] = $access;
	unset ($query);
	unset ($result);
}

if ((!isset ($_SESSION['sessioncode'])) AND ($_SESSION['sessioncode'] != $sas_config['sessioncode']) OR ($usertype == 1) OR ($usertype == 2))
{
	include ("interface/saslogin.inc.php");
}
else
{
	switch ($option)
	{
		default :
			include ("core/startcenter.inc.php");
			break;

		case "pagemanager" :
			include ("core/pagemanager.inc.php");
			break;

		case "modulemanager" :
			include ("core/modulemanager.inc.php");
			break;

		case "filemanager" :
			include ("core/filemanager.inc.php");
			break;

		case "configuration" :
			include ("core/configuration.inc.php");
			break;

		case "tools" : // tools
			include ("core/tools.inc.php");
			break;

		case "stats" : // statistics
			include ("core/stats.php");
			break;

		case "logout" :

			if ($_SESSION['sessioncode'] != $sas_config['sessioncode'])
			{
				print "<html>
								   			    	<head>
								   		  	    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" . $sas_lang['lang_charset'] . "\">
												      <META HTTP-EQUIV=Refresh CONTENT=\"2; URL=index.php\">
								   				     </head>" .
				$sas_lang['login_error'] . "
								   			    	</html>";
				exit;
			}
			else
			{
				$usertype = $_SESSION['usertype'];
				session_destroy();
				if ($_SESSION['user_type'] == "teacher")
				{
					header("location: ../index.php");
				}
				else
				{
					header("location: index.php");
				}
			}
			break;
	}
}
?>