<?php

#############################################################################
#                              FAgenda
# FAgenda is a website agenda designed for and integrated in Site@School.
# (http://siteatschool.sourceforge.net)
#
# About FAgenda:
# Original idea: Dirk Schouten and Fred Stuurman
# Coding: Fred Stuurman (fc.stuurman@hccnet.nl)
#############################################################################
# agenda_week.php  last changed 07/09/2006, S@S version: 2.4.10                                        
#                  by Fred Stuurman (fc.stuurman@hccnet.nl)
#$Id: agenda_week.php,v 1.2 2006/10/15 19:08:53 fstuurman Exp $
############################################################################
#                        LICENSE INFORMATION
# Copyright (C) 2004 Fred Stuurman (fc.stuurman@hccnet.nl)
#
# FAgenda is an integrated part of the Site@School Content Management System.
# FAgenda may not be modified, taken out of Site@School and/or distributed 
# without the written permission of the author.
# 
# FAgenda is free to use for Educational use and may be used free-of-charge 
# by members of educational institutions, but must be purchased by all others.
# Contact the author, F. Stuurman (fc.stuurman@hccnet.nl), for 
# non-educational use or adapting FAgenda to your requirements.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# FITNESS FOR A PARTICULAR PURPOSE.
#
#                   DO NOT REMOVE THIS COPYRIGHT NOTICE
##############################################################################
define('IN_SAS', true);

function datefromweeknr($aYear, $aWeek, $aDay)
{
	$FirstDayOfWeek = 1; //First day of week is Monday       
	$BaseDate = 4; //We calculate from 4/1 which is always in week 1 
	$CJDDelta = 2415019; //Based on start of Chronological Julian Day
	$StartDate = DelphiDate(mktime(1, 0, 0, 01, $BaseDate, $aYear)); //The date to start with
	$Offset = ($aWeek -1) * 7 - mod(floor($StartDate) + $CJDDelta +8 - $FirstDayOfWeek, 7) + $aDay -1;
	return PHPUnixTimeStamp($StartDate + $Offset);
}

#---------extra functions used----------

function DelphiDate($aPHPTime)
{
	# The Unix Timestamp holds the number of seconds after January 1 1970 01:00:00
	return div($aPHPTime, 86400) + 25569;
}

function PHPUnixTimeStamp($aDelphiDate)
{
	# Delphi's TDate holds number of days after December 30 1899
	return ($aDelphiDate -25569) * 86400 - 3600;
}

function mod($number, $div)
{
	return $number -floor($number / $div) * $div;
}

function div($number, $div)
{
	return floor($number / $div);
}

if (IsSet ($_GET[a]))
{
	$a = intval($_GET[a]);
}
if (IsSet ($_GET[week]))
{
	$week = intval($_GET[week]);
}
if (IsSet ($_GET[year]))
{
	$year = intval($_GET[year]);
}

include_once ("agenda_common.inc.php"); //execute common code

$tpl = new TemplatePower("week_view.html");
$tpl->prepare();
$query = "SELECT name FROM $table_agenda_name WHERE id ='" . $a . "'";
$result = mysql_query($query);
$agenda_name = mysql_result($result, 0);
$tpl->assign("agenda_name", $agenda_name);
$title = str_replace("%week%", $week, $sas_lang['agenda_week_title']);
$tpl->assign("w", $title);
$query_date_first = date('Y-m-d', datefromweeknr($year, $week, 1));
$day_number = substr($query_date_first, 8, 10);
$query_date_last = date('Y-m-d', datefromweeknr($year, $week +1, 1));
$week_day = date("w", mktime(12, 0, 0, $month, $day_number, $year));
//print $query_date_first." ".$query_date_last." ".$week_day;

$query = "SELECT adate, timeslot, descr, agenda FROM $table_agenda_events 
		WHERE adate >= '$query_date_first' AND adate <= '$query_date_last' AND agenda = '" . $a . "' ORDER BY adate";
$result = mysql_query($query);
//print $query;
$numRows = mysql_num_rows($result);
if ($numRows > 0)
{
	while ($time_list = mysql_fetch_array($result))
	{ //fill the description from table  
		$day_number = substr($time_list[0], 8, 10); //get the day of the date
		$week_day = date("w", mktime(12, 0, 0, $month, $day_number, $year)); //get the day n umber monday =1
		//print $time_list[0]." ".$time_list[1]."<br>$week_day" ;
		$tpl->assign("app$time_list[1]$week_day", $time_list[2]);
	}
}

fill_time_slots(); //fill the timeslots text
for ($i = 0; $i < 7; $i++)
{
	if ($i == 0)
	{
		$tpl->assign("day$i", $lang_week[$i] . "<br>" . date('d-m-Y', datefromweeknr($year, $week, 7)));
	}
	else
	{
		$tpl->assign("day$i", $lang_week[$i] . "<br>" . date('d-m-Y', datefromweeknr($year, $week, $i)));
	}
}

$tpl->printToScreen();
?>