/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class UploadThread
extends Thread {
    private File file;
    private Main main;
    private int attempts;
    private static final String lotsHyphens = "---------------------------";
    private static final String lineEnd = "\n";
    private String header;
    private String footer;
    private String request;
    private String reply;
    private String afterContent;
    private URL url;
    private String boundary;
    private Socket sock;

    public UploadThread(URL u, File f, Main m) throws IOException, UnknownHostException {
        this.url = u;
        this.file = f;
        this.main = m;
        this.attempts = 0;
        this.sock = this.getSocket();
    }

    public void run() {
        try {
            this.upload();
        }
        catch (FileNotFoundException fnfe) {
            this.main.setProgress((int)this.file.length());
        }
        catch (IOException ioe) {
            this.run();
            System.out.println("*** IOException: UploadThread ***");
        }
    }

    private void upload() throws FileNotFoundException, IOException {
        this.uploadFile();
        if (this.reply != null && this.reply.indexOf("FILEFAILED") >= 0) {
            if (this.reply.indexOf("FILETOOBIG") < 0) {
                if (this.attempts < 3) {
                    this.main.setProgress(-((int)this.file.length()));
                    ++this.attempts;
                    this.upload();
                }
            } else {
                this.attempts = 5;
            }
        }
    }

    private synchronized void uploadFile() throws FileNotFoundException, IOException {
        this.setBoundary(40);
        this.setHeaderAndFooter();
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        BufferedReader input = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
        output.writeBytes(this.request);
        output.writeBytes(this.header);
        output.flush();
        ReadLine rl = new ReadLine(input, this);
        rl.start();
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        output.writeBytes(this.afterContent);
        FileInputStream fileStream = new FileInputStream(this.file);
        boolean numBytes = false;
        if (this.file.length() > Integer.MAX_VALUE) {
            throw new IOException("*** FILE TOO BIG ***");
        }
        int maxBufferSize = 1024;
        int bytesAvailable = fileStream.available();
        int bufferSize = Math.min(bytesAvailable, maxBufferSize);
        int finalByteSize = 0;
        byte[] buffer = new byte[bufferSize];
        int bytesRead = fileStream.read(buffer, 0, bufferSize);
        while (bytesAvailable > 0) {
            output.write(buffer, 0, bufferSize);
            if (bufferSize == maxBufferSize) {
                this.main.setProgress(bufferSize);
            } else {
                finalByteSize = bufferSize;
            }
            bytesAvailable = fileStream.available();
            bufferSize = Math.min(bytesAvailable, maxBufferSize);
            bytesRead = fileStream.read(buffer, 0, bufferSize);
        }
        output.writeBytes(this.footer);
        output.writeBytes(lineEnd);
        output.flush();
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this.reply = rl.getRead();
        input.close();
        output.close();
        this.sock.close();
        this.main.setProgress(finalByteSize);
    }

    private Socket getSocket() throws IOException, UnknownHostException {
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                int port = this.url.getPort();
                if (this.url.getPort() > 0) {
                    return sc.getSocketFactory().createSocket(this.url.getHost(), this.url.getPort());
                }
                return sc.getSocketFactory().createSocket(this.url.getHost(), 443);
            }
            catch (Exception e) {}
        } else {
            Socket s;
            String proxyHost = System.getProperties().getProperty("deployment.proxy.http.host");
            String proxyPort = System.getProperties().getProperty("deployment.proxy.http.port");
            String proxyType = System.getProperties().getProperty("deployment.proxy.type");
            if (proxyHost == null || proxyType == null || proxyHost.equalsIgnoreCase("") || proxyType.equalsIgnoreCase("0") || proxyType.equalsIgnoreCase("2") || proxyType.equalsIgnoreCase("-1")) {
                s = this.url.getPort() > 0 ? new Socket(this.url.getHost(), this.url.getPort()) : new Socket(this.url.getHost(), 80);
            } else {
                System.out.println("PROXY HOST: " + proxyHost);
                System.out.println("PROXY PORT: " + proxyPort);
                System.out.println("PROXY TYPE: " + proxyType);
                try {
                    s = new Socket(proxyHost, Integer.parseInt(proxyPort));
                }
                catch (NumberFormatException badPort) {
                    s = this.url.getPort() > 0 ? new Socket(this.url.getHost(), this.url.getPort()) : new Socket(this.url.getHost(), 80);
                }
            }
            return s;
        }
        return null;
    }

    private void setBoundary(int length) {
        char[] alphabet = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        Random r = new Random();
        String boundaryString = "";
        for (int i = 0; i < length; ++i) {
            boundaryString = boundaryString + alphabet[r.nextInt(alphabet.length)];
        }
        this.boundary = boundaryString;
    }

    private void setHeaderAndFooter() {
        this.header = new String();
        this.footer = new String();
        this.request = new String();
        this.afterContent = "-----------------------------" + this.boundary + lineEnd + "Content-Disposition: form-data; name=\"userfile\"; filename=\"" + this.file.getName() + "\"" + lineEnd + "Content-Type: application/octet-stream" + lineEnd + lineEnd;
        this.footer = "\n-----------------------------" + this.boundary + "--";
        this.request = "POST " + this.url.toExternalForm() + " HTTP/1.1" + lineEnd;
        this.header = this.header + "Host: " + this.url.getHost() + lineEnd;
        this.header = this.header + "User-Agent: Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.7.10)\n";
        this.header = this.header + "Expect: 100-continue\n";
        this.header = this.header + "Accept: text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5\n";
        this.header = this.header + "Accept-Language: en-us,en;q=0.5\n";
        this.header = this.header + "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\n";
        String cookie = this.main.getCookie();
        if (cookie.length() > 0) {
            this.header = this.header + "Cookie: " + cookie + lineEnd;
        }
        this.header = this.header + "Connection: close\n";
        this.header = this.header + "Content-Type: multipart/form-data; boundary=---------------------------" + this.boundary + lineEnd;
        this.header = this.header + "Content-Length: ";
        this.header = this.header + "" + (this.file.length() + (long)this.afterContent.length() + (long)this.footer.length()) + lineEnd + lineEnd;
    }
}

