#ifndef TEXTURE_ATLAS_H
#define TEXTURE_ATLAS_H

#include <GL/glew.h>

#include "../simimg.h"
#include "../tpl/inthashtable_tpl.h"

struct bild_t;

struct texture_info_t {
	GLuint texture;
	sint16 x, y;
	sint16 w, h;
	float u1, u2;
	float v1, v2;
	float v_per_pixel;
};

class texture_atlas_t {
public:
	texture_atlas_t();
	~texture_atlas_t();

	void init();

	const texture_info_t *get_texture_info(image_id image) const {
		return &atlas.get(image);
	}

	// Should be temporary
	const GLuint *get_textures() const {
		return textures;
	}

private:
	GLsizei num_textures;
	GLuint *textures;
	inthashtable_tpl<image_id, texture_info_t> atlas;
};

extern void register_texture(const bild_t *image);

#endif // TEXTURE_ATLAS_H
