/**
 *  ServingXML
 *  
 *  Copyright (C) 2006  Daniel Parker
 *    daniel.parker@servingxml.com 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 * 
 **/

package com.servingxml.util;

import java.lang.reflect.Method;

public class Reflection {

  public static Method findMethod(Class recordClass, String methodName,
  Class<?>[] parameterTypes) {
    Method handlerMethod = null;
    Method[] methods = recordClass.getMethods();
    boolean done = false;
    for (int i = 0; !done && i < methods.length; ++i) {
      Method method = methods[i];
      if (method.getName().equals(methodName)) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (parameterTypes.length == paramTypes.length) {
          boolean match = true;
          for (int j = 0; match && j < parameterTypes.length; ++j) {
            if (parameterTypes[j] != null) {
              Class<?> parameterType = parameterTypes[j];
              Class<?> paramType = paramTypes[j];
              if (!paramType.isAssignableFrom(parameterType)) {
                match = false;
              }
            }
          }
          if (match) {
            handlerMethod = method;
            done = true;
          }
        }
      }
    }
    return handlerMethod;
  }
}
