/**
 *  ServingXML
 *  
 *  Copyright (C) 2006  Daniel Parker
 *    daniel.parker@servingxml.com 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 * 
 **/

package com.servingxml.components.recordmapping;

import com.servingxml.app.ServiceContext;
import com.servingxml.app.Flow;
import com.servingxml.util.record.Record;

/**
 * Defines an interface for a <tt>GroupRecognizer</tt>.
 * Implementations can provide an empty constructor, or a constructor
 * that takes a {@link com.servingxml.app.ServiceContext} and a parameters 
 * {@link com.servingxml.util.record.Record} as arguments.
 * 
 * @author Daniel A. Parker (daniel.parker@servingxml.com)
 */

public interface GroupRecognizer {
  boolean startRecognized(ServiceContext context, Flow flow, Record previousRecord, 
  Record currentRecord);
  boolean endRecognized(ServiceContext context, Flow flow, Record currentRecord, 
  Record nextRecord);
}

