/**
 *  ServingXML
 *  
 *  Copyright (C) 2006  Daniel Parker
 *    daniel.parker@servingxml.com 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 * 
 **/

package com.servingxml.components.inverserecordmapping;

import com.servingxml.util.Name;
import com.servingxml.util.xml.Matchable;
import com.servingxml.util.xml.MatchableImpl;
import com.servingxml.util.xml.ParameterParser;

/**
 * Defines an interface for a subtree field map.
 * 
 * 
 * @author Daniel A. Parker (daniel.parker@servingxml.com)
 */

public class SubtreeFieldMapImpl implements SubtreeFieldMap {
  private final Name fieldName;
  private final String matchExpr;
  private final String selectExpr;

  public SubtreeFieldMapImpl(Name fieldName, String matchExpr, String selectExpr) {
    this.fieldName = fieldName;
    this.matchExpr = matchExpr;
    this.selectExpr = selectExpr;
  }

  public Matchable createMatchable(String mode) {
    Matchable matchable = new MatchableImpl(mode, matchExpr, fieldName, selectExpr);
    return matchable;
  }

  public void putParameters(ParameterParser paramParser) {
    paramParser.parseParameters(selectExpr);
  }
}
