/**
 *  ServingXML
 *  
 *  Copyright (C) 2006  Daniel Parker
 *    daniel.parker@servingxml.com 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 * 
 **/

package com.servingxml.components.flatfile.recordtype;

import java.util.ArrayList;
import java.util.List;
import java.io.IOException;

import com.servingxml.app.ServiceContext;
import com.servingxml.util.Name;
import com.servingxml.util.ServingXmlException;
import com.servingxml.util.record.Record;
import com.servingxml.util.record.RecordBuilder;
import com.servingxml.util.record.RecordReceiver;
import com.servingxml.expr.substitution.IntegerSubstitutionExpr;
import com.servingxml.app.Flow;
import com.servingxml.components.flatfile.RecordInput;
import com.servingxml.components.flatfile.FlatRecordReader;
import com.servingxml.components.flatfile.options.Delimiter;

public class FixedRepeatingGroupReader implements FlatRecordFieldReader {
  private final Name fieldName;
  private final int offset;
  private final FlatRecordReader segmentReader;
  private final int startPosition;
  private final IntegerSubstitutionExpr countExpr;

  public FixedRepeatingGroupReader(Name fieldName, int offset, FlatRecordReader segmentReader, 
                                   int startPosition, IntegerSubstitutionExpr countExpr) {
    this.fieldName = fieldName;
    this.offset = offset;
    this.segmentReader = segmentReader;
    this.startPosition = startPosition;
    this.countExpr = countExpr;
  }

  public void readField(final ServiceContext context, 
                        Flow flow, 
                        final RecordInput recordInput, 
                        Delimiter[] recordDelimiters, 
                        int recordDelimiterStart, int recordDelimiterCount, 
                        RecordBuilder recordBuilder) {

    try {
      Record parameters = flow.getParameters();
      int count = countExpr.evaluateAsInt(parameters,recordBuilder);

      //System.out.println(getClass().getName()+".readField count="+count);

      final List<Record> segmentList = new ArrayList<Record>();
      RecordReceiver segmentReceiver = new RecordReceiver() {
        public void receiveRecord(Record segment) {
          //System.out.println(getClass().getName()+".readField segment received \n  " + segment.toXmlString(context));
          segmentList.add(segment);
        }
      };

      if (offset != -1) {
        recordInput.setPosition(offset);
      }

      //System.out.println(getClass().getName()+".readField count=" + count);
      for (int i = 0; !recordInput.done() && i < count; ++i) {
        segmentReader.readRecord(context, flow, recordInput, recordDelimiters, recordDelimiterStart, recordDelimiterCount, segmentReceiver);
      }
      //System.out.println(getClass().getName()+".readField done read");

      if (segmentList.size() > 0) {
        Record[] segments = new Record[segmentList.size()];
        segments = segmentList.toArray(segments);

        recordBuilder.setRecords(fieldName, segments);
      }
    } catch (ServingXmlException e) {
      throw e;
    } catch (Exception e) {
      throw new ServingXmlException(e.getMessage(), e);
    }

  }

  public int getFixedEndPosition(Record parameters, Record currentRecord, int currentPosition) {
    return -1;
  }
}
