/* Olivetti M20 skeleton driver, by incog (19/05/2009) */
 
#include "driver.h"
#include "cpu/z8000/z8000.h"
 
#define MAIN_CLOCK 4000000 /* 4 MHz */
 
 
static ADDRESS_MAP_START(m20_mem, ADDRESS_SPACE_PROGRAM, 16)
	ADDRESS_MAP_UNMAP_HIGH
	AM_RANGE( 0x0000, 0x1fff ) AM_ROM
	AM_RANGE( 0x2000, 0xffff ) AM_RAM
ADDRESS_MAP_END
 
static ADDRESS_MAP_START( m20_io , ADDRESS_SPACE_IO, 16)
	ADDRESS_MAP_UNMAP_HIGH
ADDRESS_MAP_END
 
static INPUT_PORTS_START( m20 )
INPUT_PORTS_END
 
static DRIVER_INIT( m20 )
{
}
 
static MACHINE_RESET( m20 )
{
}
 
static VIDEO_START( m20 )
{
}
 
static VIDEO_UPDATE( m20 )
{
    return 0;
}
 
static MACHINE_DRIVER_START( m20 )
    /* basic machine hardware */
    MDRV_CPU_ADD("maincpu", Z8000, MAIN_CLOCK)
    MDRV_CPU_PROGRAM_MAP(m20_mem)
    MDRV_CPU_IO_MAP(m20_io)
  	
  	MDRV_MACHINE_RESET(m20)
 
    /* video hardware */
    MDRV_SCREEN_ADD("screen", RASTER)
    MDRV_SCREEN_REFRESH_RATE(60)
    MDRV_SCREEN_VBLANK_TIME(ATTOSECONDS_IN_USEC(2500)) /* not accurate */    
    MDRV_SCREEN_FORMAT(BITMAP_FORMAT_RGB32)
    MDRV_SCREEN_SIZE(512, 256)
    MDRV_SCREEN_VISIBLE_AREA(0, 512-1, 0, 256-1)
    MDRV_PALETTE_LENGTH(2)
    MDRV_PALETTE_INIT(black_and_white)
 
    MDRV_VIDEO_START(m20)
    MDRV_VIDEO_UPDATE(m20)
MACHINE_DRIVER_END
 
static SYSTEM_CONFIG_START(m20)
SYSTEM_CONFIG_END
 
ROM_START(m20)
	ROM_REGION(0x12000,"maincpu",0)
	ROM_SYSTEM_BIOS( 0, "m20", "M20 1.0" )
	ROMX_LOAD("m20.bin", 0x10000, 0x2000, CRC(5c93d931) SHA1(d51025e087a94c55529d7ee8fd18ff4c46d93230), ROM_BIOS(1))
	ROM_SYSTEM_BIOS( 1, "m20-20d", "M20 2.0d" )
	ROMX_LOAD("m20-20d.bin", 0x10000, 0x2000, CRC(cbe265a6) SHA1(c7cb9d9900b7b5014fcf1ceb2e45a66a91c564d0), ROM_BIOS(2))
	ROM_SYSTEM_BIOS( 2, "m20-20f", "M20 2.0f" )
	ROMX_LOAD("m20-20f.bin", 0x10000, 0x2000, CRC(db7198d8) SHA1(149d8513867081d31c73c2965dabb36d5f308041), ROM_BIOS(3))
	ROM_REGION(0x4000,"apb",0) // Processor board with 8086
	ROM_LOAD( "apb-1086-2.0.bin", 0x0000, 0x4000, CRC(8c05be93) SHA1(2bb424afd874cc6562e9642780eaac2391308053))
ROM_END

ROM_START(m40)
	ROM_REGION(0x14000,"maincpu",0)
	ROM_SYSTEM_BIOS( 0, "m40-81", "M40 15.dec.81" )
	ROMX_LOAD( "m40rom-15-dec-81", 0x0000, 0x2000, CRC(e8e7df84) SHA1(e86018043bf5a23ff63434f9beef7ce2972d8153), ROM_BIOS(1))
	ROM_SYSTEM_BIOS( 1, "m40-82", "M40 17.dec.82" )
  	ROMX_LOAD( "m40rom-17-dec-82", 0x0000, 0x2000, CRC(cf55681c) SHA1(fe4ae14a6751fef5d7bde49439286f1da3689437), ROM_BIOS(2))
  	ROM_SYSTEM_BIOS( 2, "m40-41", "M40 4.1" )
  	ROMX_LOAD( "m40rom-4.1", 0x0000, 0x2000, CRC(cf55681c) SHA1(fe4ae14a6751fef5d7bde49439286f1da3689437), ROM_BIOS(3))
  	ROM_SYSTEM_BIOS( 3, "m40-60", "M40 6.0" )
  	ROMX_LOAD( "m40rom-6.0", 0x0000, 0x4000, CRC(8114ebec) SHA1(4e2c65b95718c77a87dbee0288f323bd1c8837a3), ROM_BIOS(4))
ROM_END
 
/*    YEAR  NAME   PARENT  COMPAT  MACHINE INPUT   INIT CONFIG 	COMPANY     FULLNAME        FLAGS */
COMP( 1981, m20,   0,      0,      m20,    m20,    m20, 	m20,  	"Olivetti", "Olivetti L1 M20", GAME_NOT_WORKING)
COMP( 1981, m40,   m20,    0,      m20,    m20,    m20, 	m20,  	"Olivetti", "Olivetti L1 M40", GAME_NOT_WORKING)
