/******************************************************************************
 *
 *  A list of commonly used floppy disk formats
 *  This is converted from 22disk's list of formats (ver 1.40)
 *
 ******************************************************************************/

static const dsk_fmt formats[] = {
	{
		"ATHD", "IBM AT DSHD 3.5\"",
		0,	/* unique format */
		DEN_MFM_HI, 80,2, 18, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,},
		ORD_SIDES, "CPM62K",
		{   72,  4, 15,  0, 719, 255,0xf0,0x00, 64,  1},
	},
	{
		"A1", "Generic CP/M - SSSD 8\"",
		0,	/* unique format */
		DEN_FM_HI, 77,1, 26, 128, 1,
		{  0, 1,7,13,19,25,5,11,17,23,3,9,15,21,2,8,14,20,26,6,12,18,24,4,10,16,22,},
		{  0, },
		ORD_SIDES, 0,
		{   26,  3,  7,  0, 242,  63,0xc0,0x00, 16,  2},
	},
	{
		"ABC1", "ABC-80 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 16, 256, 1,
		{  0, 1,8,15,6,13,4,11,2,9,16,7,14,5,12,3,10,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 151,  63,0xc0,0x00, 16,  2},
	},
	{
		"ABD1", "A. B. Dick Magna III - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  0, 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,},
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 255, 255,0xff,0x00, 64,  4},
	},
	{
		"ACT1", "Actrix (Access Matrix) - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  9, 512, 1,
		{  0, 1,4,7,2,5,8,3,6,9,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  3,  7,  0, 170,  63,0xc0,0x00, 16,  2},
	},
	{
		"ADL1", "Adler Textriter - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 16, 256, 1,
		{  0, 1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 159,  31,0x80,0x00,  8,  0},
	},
	{
		"ADV1", "Advanced Digital Super 6 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  4,1024, 1,
		{  0, 1,2,3,4,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  4, 15,  0,  77,  63,0x80,0x00, 16,  1},
	},
	{
		"ADV3", "Advanced Digital Super 6 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  4,1024, 2,
		{  0, 1,2,3,4,},
		{  1, 1,2,3,4,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 300, 127,0xc0,0x00, 32,  2},
	},
	{
		"ADV5", "Advanced Digital TurboDOS 312K - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  4,1024, 1,
		{  0, 1,2,3,4,},
		{  0, 1,2,3,4,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 155, 127,0xc0,0x00, 32,  2},
	},
	{
		"ALT5", "Altos Series 5 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  9, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  5, 31,  3, 176, 176,0xc0,0x00, 44,  2},
	},
	{
		"AMI1", "Amigo - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 10, 512, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  3,  7,  0, 189,  63,0xc0,0x00, 16,  2},
	},
	{
		"AMP1", "Ampro - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 10, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1,  94,  63,0x80,0x00, 16,  2},
	},
	{
		"AMP3", "Ampro - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1,  5,1024, 2,
		{  0, 1,2,3,4,5,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"AMS1", "Amstrad PCW8256 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  9, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, "AMS1",
		{   36,  4, 15,  0, 356, 255,0xf0,0x00, 64,  1},
	},
	{
		"AMSD", "Amstrad PCW 9256, 9512 Disckit - DSDD 3.5\"",
		"AMS1",	/* reused format */
	},
	{
        "APL1", "Apple ][ - SSDD 48 tpi 5.25\" (CP/M)",
        0,  /* unique format */
		DEN_MFM_LO, 35,1, 16, 256, 1,
        {  0, 0,3,6,9,12,15,2,5,8,11,14,1,4,7,10,13},
        {  0, },
        ORD_SIDES, 0,
		{	32,  3,  7,  0, 127,  47,0xc0,0x00, 12,  3},
    },
    {
		"APL2", "Apple ][ - SSDD 48 tpi 5.25\" (CP/M read as DOS 3.3 image)",
		0,	/* unique format */
		DEN_MFM_LO, 35,1, 16, 256, 1,
		{  0, 0,6,12,3,9,15,14,5,11,2,8,7,13,4,10,1},
		{  0, },
		ORD_SIDES, 0,
		{	32,  3,  7,  0, 127,  47,0xc0,0x00, 12,  3},
	},
    {
		"ARC1", "Archive I - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1,  5,1024, 1,
		{  0, 1,4,2,5,3,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"ARC2", "Archive II & III - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  5,1024, 1,
		{  0, 1,4,2,5,3,},
		{  1, 1,4,2,5,3,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 394, 319,0xf8,0x00, 80,  2},
	},
	{
		"ARI1", "Arisia - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 18, 256, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  3,  7,  0, 147, 127,0xf0,0x00, 32,  2},
	},
	{
		"ATR1", "ATR-8000 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  5,1024, 3,
		{  0, 1,2,3,4,5,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  3,  7,  0, 189,  63,0xc0,0x00, 16,  2},
	},
	{
		"AVA1", "Avatar - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 1,5,9,3,7,2,6,10,4,8,},
		{  1, 1,5,9,3,7,2,6,10,4,8,},
		ORD_CYLINDERS, 0,
		{   40,  4, 15,  1, 191, 127,0xc0,0x00, 32,  3},
	},
	{
		"BEE1", "Beehive - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  1, 1,2,3,4,5,6,7,8,9,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"BEE2", "Beehive Microbee - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 2,5,8,1,4,7,10,3,6,9,},
		{  1, 2,5,8,1,4,7,10,3,6,9,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"BIT1", "Bitelex - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 16, 256, 1,
		{  0, 1,3,5,7,9,11,13,15,2,4,6,8,10,12,14,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 131,  95,0xe0,0x00, 24,  2},
	},
	{
		"BMC1", "BMC IF800 Model 20 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 1,7,13,19,5,11,17,3,9,15,},
		{  1, 1,7,13,19,5,11,17,3,9,15,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 191, 127,0xc0,0x00, 32,  3},
	},
	{
		"BON1", "Bondwell 12 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 18, 256, 2,
		{  0, 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  4, 15,  1,  84, 127,0xc0,0x00, 32,  2},
	},
	{
		"BON2", "Bondwell 14 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 18, 256, 2,
		{  0, 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,},
		{  1, 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,},
		ORD_CYLINDERS, 0,
		{   36,  4, 15,  1, 174, 127,0xc0,0x00, 32,  2},
	},
	{
		"BUR1", "Burr-Brown - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 18, 256, 1,
		{  0, 1,10,2,11,3,12,4,13,5,14,6,15,7,16,8,17,9,18,},
		{  1, 1,10,2,11,3,12,4,13,5,14,6,15,7,16,8,17,9,18,},
		ORD_SIDES, 0,
		{   36,  4, 15,  1, 170,  63,0x80,0x00, 16,  4},
	},
	{
		"CAL1", "Cal-PC - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  1, 1,2,3,4,5,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"CAS1", "Cashcom 100 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  4,1024, 1,
		{  0, 1,2,3,4,},
		{  1, 1,2,3,4,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 303, 127,0xc0,0x00, 32,  2},
	},
	{
		"CAS2", "Casio FP-1100/FP-1020 - DSDD 48tpi 5.25\"",
		"FUJ2",	/* reused format */
	},
	{
		"CCS1", "CCS (256 bytes/sector) - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 18, 256, 1,
		{  0, 1,5,9,13,17,3,7,11,15,2,6,10,14,18,4,8,12,16,},
		{  0, 1,5,9,13,17,3,7,11,15,2,6,10,14,18,4,8,12,16,},
		ORD_SIDES, 0,
		{   36,  4, 15,  1, 165,  63,0x80,0x00, 16,  6},
	},
	{
		"CCS2", "CCS (512 bytes/sector) - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 1,4,7,10,3,6,9,2,5,8,},
		{  0, 1,4,7,10,3,6,9,2,5,8,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 184,  63,0x80,0x00, 16,  6},
	},
	{
		"CCS3", "CCS (1024 bytes/sector) - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  5,1024, 1,
		{  0, 1,3,5,2,4,},
		{  0, 1,3,5,2,4,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 184,  63,0x80,0x00, 16,  6},
	},
	{
		"CDI1", "CDI-5000 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  5,1024, 1,
		{  0, 1,4,2,5,3,},
		{  1, 1,4,2,5,3,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194,  63,0x80,0x00, 16,  2},
	},
	{
		"CMC1", "CMC Supersystem 2 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  1, 1,2,3,4,5,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 391, 127,0xc0,0x00, 32,  3},
	},
	{
		"COL1", "Coleco ADAM, 40 track - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  8, 512, 1,
		{  0, 1,6,3,8,5,2,7,4,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 146,  63,0xc0,0x00, 16,  2},
	},
	{
		"COM1", "Compis - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  8, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_CYLINDERS, 0,
		{   32,  4, 15,  0, 317, 127,0xc0,0x00, 32,  1},
	},
	{
		"COM2", "Compugraphic MCS-5 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 155,  63,0xc0,0x00, 16,  1},
	},
	{
		"COM3", "Compustar Model 30 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 35,2, 10, 512, 1,
		{  0, 1,3,5,7,9,2,4,6,8,10,},
		{  1, 1,3,5,7,9,2,4,6,8,10,},
		ORD_EAGLE, 0,
		{   40,  4, 15,  1, 169,  63,0x80,0x00, 16,  2},
	},
	{
		"COM4", "Compupro (Viasyn) (1024 bytes/sector) - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  5,1024, 1,
		{  0, 1,3,5,2,4,},
		{  1, 1,3,5,2,4,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 389, 255,0xf0,0x00, 64,  4},
	},
	{
		"CRO1", "Cromemco CDOS - SSSD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_FM_LO, 40,1, 18, 128, 1,
		{  0, 1,6,11,16,3,8,13,18,5,10,15,2,7,12,17,4,9,14,},
		{  0, },
		ORD_SIDES, 0,
		{   18,  3,  7,  0,  82,  63,0xc0,0x00, 16,  3},
	},
	{
		"CRO3", "Cromemco CDOS - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 10, 512, 1,
		{  0, 1,5,9,3,7,2,6,10,4,8,},
		{  0, },
		ORD_SIDES, "CRO3",
		{   40,  3,  7,  0, 189,  63,0xc0,0x00, 16,  2},
	},
	{
		"CRO6", "Cromemco CP/M - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 10, 512, 1,
		{  0, 1,4,7,10,3,6,9,2,5,8,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1,  94, 127,0xc0,0x00, 32,  2},
	},
	{
		"CWP1", "C/WP Cortex - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 10, 512, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  3,  7,  0, 189,  63,0xc0,0x00, 16,  2},
	},
	{
		"CYK1", "Cykey - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 1,
		{  0, 1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16,},
		{  1, 1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 153,  63,0xc0,0x00, 16,  3},
	},
	{
		"DAT1", "Datavue DV80 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 3,
		{  0, 129,130,131,132,133,134,135,136,137,138,},
		{  1, 129,130,131,132,133,134,135,136,137,138,},
		ORD_SIDES, 0,
		{   40,  5, 31,  3,  94, 127,0x80,0x00, 32,  4},
	},
	{
		"DAT2", "Datavue DV80 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 10, 512, 3,
		{  0, 193,194,195,196,197,198,199,200,201,202,},
		{  1, 193,194,195,196,197,198,199,200,201,202,},
		ORD_SIDES, 0,
		{   40,  5, 31,  3, 194, 127,0x80,0x00, 32,  4},
	},
	{
		"DEC1", "DEC DECMate II - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1, 10, 512, 1,
		{  0, 1,3,5,7,9,2,4,6,8,10,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"DEC2", "DEC Rainbow - SSDD 96 tpi 5.25\"",
		"DEC1",	/* reused format */
	},
	{
		"DEC3", "DEC VT-180 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  9, 512, 1,
		{  0, 1,3,5,7,9,2,4,6,8,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  3,  7,  0, 170,  63,0xc0,0x00, 16,  2},
	},
	{
		"DIG1", "Digilog - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 35,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  0, 1,2,3,4,5,},
		ORD_EAGLE, 0,
		{   40,  4, 15,  1, 166,  63,0x80,0x00, 16,  3},
	},
	{
		"DIG2", "Digilog 1500 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  1, 1,2,3,4,5,},
		ORD_CYLINDERS, 0,
		{   40,  4, 15,  0, 392, 127,0xc0,0x00, 32,  3},
	},
	{
		"DIR1", "Direct 1025 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 152, 127,0xc0,0x00, 32,  3},
	},
	{
		"DIS1", "Discovery - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  8, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 313, 127,0xc0,0x00, 32,  3},
	},
	{
		"EAG1", "Eagle II - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1,  5,1024, 1,
		{  0, 1,3,5,2,4,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 191,0xe0,0x00, 48,  2},
	},
	{
		"EAG2", "Eagle III - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  5,1024, 1,
		{  0, 1,3,5,2,4,},
		{  1, 1,3,5,2,4,},
		ORD_EAGLE, 0,
		{   40,  4, 15,  0, 394, 191,0xe0,0x00, 48,  2},
	},
	{
		"EPS1", "Epson QX-10 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 5,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  1, 1,2,3,4,5,6,7,8,9,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 189, 127,0xc0,0x00, 32,  4},
	},
	{
		"EPS2", "Epson QX-10 (256 bytes/sector) - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 139,  63,0x80,0x00, 16,  8},
	},
	{
		"EPS3", "Epson PX-8 - DSDD 3.5\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 139,  63,0x80,0x00, 16,  8},
	},
	{
		"ERI1", "Ericsson DTC - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  5, 31,  3,  77, 127,0x80,0x00, 32,  2},
	},
	{
		"ERI2", "Ericsson DTC2 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_CYLINDERS, 0,
		{   32,  5, 31,  3, 157, 127,0x80,0x00, 32,  2},
	},
	{
		"ERI3", "Ericsson Step One - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  9, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  5, 31,  3, 174, 127,0x80,0x00, 32,  4},
	},
	{
		"FLO1", "Florida Graphics - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 2,
		{  0, 1,3,5,7,9,11,13,15,2,4,6,8,10,12,14,16,},
		{  1, 1,3,5,7,9,11,13,15,2,4,6,8,10,12,14,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 295, 127,0xc0,0x00, 32, 12},
	},
	{
		"FOR1", "Formula 1 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 18, 256, 1,
		{  0, 1,2,5,6,9,10,13,14,17,18,3,4,7,8,11,12,15,16,},
		{  1, 1,2,5,6,9,10,13,14,17,18,3,4,7,8,11,12,15,16,},
		ORD_SIDES, 0,
		{   36,  4, 15,  1, 172, 127,0xc0,0x00, 32,  3},
	},
	{
		"FUJ1", "Fujitsu Micro 16 - DSDD 48 tpi 5.25\"",
		"IBM2",	/* reused format */
	},
	{
		"FUJ2", "Fujitsu Micro 8 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 151, 127,0xc0,0x00, 32,  4},
	},
	{
		"GNA1", "Gnat System 10 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 35,2, 10, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  1, 11,12,13,14,15,16,17,18,19,20,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 169, 127,0xc0,0x00, 32,  2},
	},
	{
		"HCL1", "HCL System 2 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  1, 1,2,3,4,5,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 389, 255,0xf0,0x00, 64,  4},
	},
	{
		"HEA1", "Heath H89, Magnolia CP/M - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  9, 512, 4,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  4, 15,  1,  82,  95,0xc0,0x00, 24,  3},
	},
	{
		"HEA3", "Heath H89, Magnolia CP/M - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  9, 512, 4,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_CYLINDERS, 0,
		{   36,  5, 31,  3, 176, 127,0x80,0x00, 32,  3},
	},
	{
		"HEU1", "Heurikon MLZ-91A - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 1,
		{  0, 1,2,5,6,9,10,13,14,3,4,7,8,11,12,15,16,},
		{  1, 1,2,5,6,9,10,13,14,3,4,7,8,11,12,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 315, 127,0xc0,0x00, 32,  2},
	},
	{
		"HP1", "Hewlett-Packard HP 86, 87, 125 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 4,
		{  0, 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,},
		{  1, 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,},
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 251, 127,0xf0,0x00, 32,  3},
	},
	{
		"IBM1", "IBM PC, CP/M-86 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  0, },
		ORD_SIDES, "IBM1",
		{   32,  3,  7,  0, 155,  63,0xc0,0x00, 16,  1},
	},
	{
		"IBM2", "IBM PC, CP/M-86 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_CYLINDERS, "IBM2",
		{   32,  4, 15,  1, 157,  63,0x80,0x00, 16,  1},
	},
	{
		"IMS1", "IMS 5000 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 16, 256, 1,
		{  0, 1,9,2,10,3,11,4,12,5,13,6,14,7,15,8,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 147,  63,0xc0,0x00, 16,  3},
	},
	{
		"IMS2", "IMS 5000 TurboDOS - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  1, 1,2,3,4,5,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 380, 127,0xc0,0x00, 32,  4},
	},
	{
		"INT1", "Intel iPDS 100 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 4,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 307, 255,0xf0,0x00, 64,  6},
	},
	{
		"INS1", "Insight Enterprises - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 155,  63,0x80,0x00, 16,  2},
	},
	{
		"ITH1", "Ithaca Intersystems - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1, 18, 256, 2,
		{  0, 1,2,5,6,9,10,13,14,17,18,3,4,7,8,11,12,15,16,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  4, 15,  1, 174, 127,0xc0,0x00, 32,  2},
	},
	{
		"JET1", "Jet-80 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  1, 1,2,3,4,5,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"KAY1", "Kaypro II/2 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 10, 512, 4,
		{  0, 0,1,2,3,4,5,6,7,8,9,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  3,  7,  0, 194,  63,0xf0,0x00, 16,  1},
	},
	{
		"KAY2", "Kaypro 2X/4/10 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 4,
		{  0, 0,1,2,3,4,5,6,7,8,9,},
		{  0, 10,11,12,13,14,15,16,17,18,19,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 196,  63,0xc0,0x00, 16,  1},
	},
	{
		"KAY3", "Kaypro, Pro-8 ROM - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 10, 512, 4,
		{  0, 0,1,2,3,4,5,6,7,8,9,},
		{  0, 20,21,22,23,24,25,26,27,28,29,},
		ORD_SIDES, 0,
		{   40,  5, 31,  3, 196,  95,0x80,0x00, 24,  2},
	},
	{
		"KON1", "Kontron - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 77,2, 16, 256, 1,
		{  0, 1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14,},
		{  1, 1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14,},
		ORD_CYLINDERS, 0,
		{   32,  4, 15,  0, 299, 255,0xf0,0x00, 64,  4},
	},
	{
		"LEX1", "Lexoriter - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 16, 256, 1,
		{  0, 1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 159,  31,0x80,0x00,  8,  0},
	},
	{
		"LOB1", "Lobo Max-80 (256 bytes/sector) - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 18, 256, 2,
		{  0, 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  3,  7,  0, 165,  63,0xc0,0x00, 16,  3},
	},
	{
		"LOB3", "Lobo Max-80 (512 bytes/sector) - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 2,
		{  0, 0,1,2,3,4,5,6,7,8,9,},
		{  1, 0,1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 191, 127,0xc0,0x00, 32,  3},
	},
	{
		"LOB4", "Lobo Max-80 (512 bytes/sector) - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 10, 512, 2,
		{  0, 0,1,2,3,4,5,6,7,8,9,},
		{  1, 0,1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 391, 255,0xf0,0x00, 64,  3},
	},
	{
		"LNW1", "LNW 2 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 18, 256, 1,
		{  0, 1,6,11,16,3,8,13,18,5,10,15,2,7,12,17,4,9,14,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  4, 15,  1,  82,  63,0x80,0x00, 16,  3},
	},
	{
		"MAC1", "Macsym 150 - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 155, 127,0xc0,0x00, 32,  2},
	},
	{
		"MAG1", "Magic - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  1, 1,2,3,4,5,6,7,8,9,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 194,  63,0x80,0x00, 16,  2},
	},
	{
		"MAI1", "MAI Basic Four - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 312, 127,0xc0,0x00, 32,  3},
	},
	{
		"MIC2", "Micromint SB180 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 2,
		{  0, 17,18,19,20,21,22,23,24,25,26,},
		{  1, 17,18,19,20,21,22,23,24,25,26,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"MIC3", "Micron Quark - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  4,1024, 1,
		{  0, 1,2,3,4,},
		{  1, 1,2,3,4,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 155, 127,0xc0,0x00, 32,  2},
	},
	{
		"MIC5", "Micro Source M6000 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 1,5,9,3,7,2,6,10,4,8,},
		{  0, 11,15,19,13,17,12,16,20,14,18,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 189, 127,0xc0,0x00, 32,  4},
	},
	{
		"MOL1", "Molecular Series 9 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  9, 512, 2,
		{  240, 1,2,3,4,5,6,7,8,9,},
		{  242, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  4, 15,  1, 179, 127,0xc0,0x00, 32,  4},
	},
	{
		"MOL2", "Molecular/Durango Poppy 54 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 10, 512, 3,
		{  0, 128,129,130,131,132,133,134,135,136,137,},
		{  1, 138,139,140,141,142,143,144,145,146,147,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 389, 127,0xc0,0x00, 32,  4},
	},
	{
		"MON1", "Monroe 8800 Series - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1, 16, 256, 1,
		{  0, 1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 153,  63,0x80,0x00, 16,  3},
	},
	{
		"MOR1", "Morrow MD2 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  5,1024, 1,
		{  0, 1,4,2,5,3,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1,  94, 127,0xc0,0x00, 32,  2},
	},
	{
		"MOR2", "Morrow MD3, 5, 11, 16, 34 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  5,1024, 1,
		{  0, 1,4,2,5,3,},
		{  1, 1,4,2,5,3,},
		ORD_SIDES, "MOR2",
		{   40,  4, 15,  1, 194, 191,0xe0,0x00, 48,  2},
	},
	{
		"MOR6", "Morrow TurboDOS - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  4,1024, 1,
		{  0, 1,2,3,4,},
		{  1, 1,2,3,4,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 155, 127,0xc0,0x00, 32,  2},
	},
	{
		"NCR1", "NCR Decision Mate V - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  8, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_EAGLE, 0,
		{   32,  4, 15,  1, 153, 127,0xc0,0x00, 32,  3},
	},
	{
		"NCR2", "NCR FirstStep - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 1,
		{  0, 1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16,},
		{  1, 1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 276, 255,0xf0,0x00, 64,  6},
	},
	{
		"NEC1", "NEC PC-8001A - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 151,  63,0xc0,0x00, 16,  2},
	},
	{
		"NEC3", "NEC PC 8801A/8831A - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  8, 512, 3,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 152, 127,0xc0,0x00, 32,  4},
	},
	{
		"NEC4", "NEC PC 8500/8431A, Starlet - DSDD 3.5\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1, 16, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 151, 127,0xc0,0x00, 32,  4},
	},
	{
		"NIA1", "Niat - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 1,
		{  0, 1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16,},
		{  1, 1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16,},
		ORD_CYLINDERS, 0,
		{   32,  5, 31,  3, 157, 127,0x80,0x00, 32,  2},
	},
	{
		"NIX1", "Nixdorf 8810/30 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 10, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  1, 1,2,3,4,5,6,7,8,9,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 384, 127,0xc0,0x00, 32,  6},
	},
	{
		"OKI1", "OKI IF800 Model 20 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 1,7,13,19,5,11,17,3,9,15,},
		{  1, 1,7,13,19,5,11,17,3,9,15,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 191, 127,0xc0,0x00, 32,  3},
	},
	{
		"OLI1", "Olivetti ETV300 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 18, 256, 1,
		{  0, 1,3,5,7,9,11,13,15,17,2,4,6,8,10,12,14,20,26,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  3,  7,  0, 170,  63,0xc0,0x00, 16,  2},
	},
	{
		"OLI2", "Olivetti M20 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 255,  63,0xc0,0x00, 16,  3},
	},
	{
		"OLI3", "Olivetti 250 -  SSDD 3.5\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1, 16, 256, 1,
		{  0, 1,3,5,7,9,11,13,15,2,4,6,8,10,12,14,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 157,  63,0x80,0x00, 16,  1},
	},
	{
		"OLY1", "Olympia EX-100 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  9, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  4, 15,  1, 174, 127,0xc0,0x00, 32,  2},
	},
	{
		"OLY2", "Olympia ETX II - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  9, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  3,  7,  0, 170, 127,0xf0,0x00, 32,  2},
	},
	{
		"OSB1", "Osborne 1 - SSSD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_FM_LO, 40,1, 10, 256, 1,
		{  0, 1,3,5,7,9,2,4,6,8,10,},
		{  0, },
		ORD_SIDES, 0,
		{   20,  4, 15,  1,  45,  63,0x80,0x00, 16,  3},
	},
	{
		"OSB2", "Osborne 1 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  3,  7,  0, 184,  63,0xc0,0x00, 16,  3},
	},
	{
		"OSB3", "Osborne Executive - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  3,  7,  0, 184,  63,0xc0,0x00, 16,  3},
	},
	{
		"OSB4", "Osborne G2 System - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  1, 6,7,8,9,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 189, 127,0xc0,0x00, 32,  4},
	},
	{
		"OSB5", "Osborne G2 System - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  1, 6,7,8,9,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 389, 255,0xf0,0x00, 64,  4},
	},
	{
		"OSB6", "Osborne 1 + Osmosis - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 1,3,5,7,9,2,4,6,8,10,},
		{  1, 1,3,5,7,9,2,4,6,8,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 384, 127,0xc0,0x00, 32,  6},
	},
	{
		"OSB7", "Osborne Nuevo - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  5,1024, 1,
		{  0, 1,3,5,2,4,},
		{  1, 6,8,10,7,9,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"OSB8", "Osborne Vixen - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  5,1024, 1,
		{  0, 1,3,5,2,4,},
		{  1, 1,3,5,2,4,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"OSB9", "Osborne Executive w/Z3 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  5,1024, 1,
		{  0, 1,3,5,2,4,},
		{  1, 1,3,5,2,4,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 395, 127,0xf8,0x00, 32,  2},
	},
	{
		"OSM1", "OSM Zeus 4 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 311, 127,0xc0,0x00, 32,  4},
	},
	{
		"OTR1", "Otrona Attache - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  1, 1,2,3,4,5,6,7,8,9,10,},
		ORD_EAGLE, 0,
		{   40,  4, 15,  1, 181, 127,0xc0,0x00, 32,  3},
	},
	{
		"OTR2", "Otrona Attache - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 10, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  1, 1,2,3,4,5,6,7,8,9,10,},
		ORD_CYLINDERS, 0,
		{   40,  4, 15,  0, 386, 127,0xc0,0x00, 32,  3},
	},
	{
		"PAN1", "Panasonic KX-E828 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 151, 127,0xc0,0x00, 32,  4},
	},
	{
		"PEG1", "Pegasus Data Logger - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  9, 512, 1,
		{  0, 1,4,7,2,5,8,3,6,9,},
		{  1, 1,4,7,2,5,8,3,6,9,},
		ORD_SIDES, 0,
		{   36,  4, 15,  0, 170,  63,0x80,0x00, 16,  6},
	},
	{
		"PHI1", "Philips PC-2010 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 16, 256, 1,
		{  0, 1,3,5,7,9,11,13,15,2,4,6,8,10,12,14,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 151,  63,0xc0,0x00, 16,  2},
	},
	{
		"PHI3", "Philips PC-3000 - 3004 - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1, 16, 256, 1,
		{  0, 1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 147,  63,0xc0,0x00, 16,  3},
	},
	{
		"PIE1", "Pied Piper - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 10, 512, 1,
		{  0, 1,3,5,7,9,2,4,6,8,10,},
		{  1, 1,3,5,7,9,2,4,6,8,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 391, 255,0xf0,0x00, 64,  3},
	},
	{
		"PMC1", "PMC Micromate - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  1, 1,2,3,4,5,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"PRO2", "Proglas 770KB - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 10, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  1, 1,2,3,4,5,6,7,8,9,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  0, 388, 255,0xf0,0x00, 64,  4},
	},
	{
		"ROY1", "Royal Alphatronic - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 151, 127,0xc0,0x00, 32,  4},
	},
	{
		"SAG1", "Sage IV - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_CYLINDERS, 0,
		{   32,  4, 15,  1, 155,  63,0x80,0x00, 16,  2},
	},
	{
		"SAG2", "Sage IV - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 315,  63,0x80,0x00, 16,  2},
	},
	{
		"SAN1", "Sanyo MBC-1000, MBC-1150 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 1,
		{  0, 1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14,},
		{  1, 1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 155,  63,0x80,0x00, 16,  2},
	},
	{
		"SAN2", "Sanyo  MBC-1250 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 1,
		{  0, 1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14,},
		{  1, 1,4,7,10,13,16,3,6,9,12,15,2,5,8,11,14,},
		ORD_SIDES, 0,
		{   32,  5, 31,  3, 155, 127,0x80,0x00, 32,  4},
	},
	{
		"SEE1", "Seequa Chameleon - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 155,  63,0xc0,0x00, 16,  1},
	},
	{
		"SEI1", "Seiko - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 315, 127,0xc0,0x00, 32,  2},
	},
	{
		"SHL1", "Shelton SIG/NET 2 - SSDD 48 tpi 5.25\"",
		"SUP2",	/* reused format */
	},
	{
		"SHA1", "Sharp MZ-80 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 2,
		{  1, 1,2,3,4,5,6,7,8,9,10,},
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 169, 127,0xc0,0x00, 32,  2},
	},
	{
		"SIE1", "Siemens  PG-685 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  9, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  4, 15,  0, 350, 255,0xf0,0x00, 64,  4},
	},
	{
		"SIE2", "Siemens PG-675 DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  9, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  4, 15,  1, 170,  63,0x80,0x00, 16,  4},
	},
	{
		"SIE3", "Siemens PG-635 DSDD 3.5\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  9, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  4, 15,  0, 350, 255,0xf0,0x00, 64,  4},
	},
	{
		"SOR1", "Sorbus TurboDOS - 5.25\" DSHD (or 8\" DSDD)",
		0,	/* unique format */
		DEN_MFM_HI, 77,2,  8,1024, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_SIDES, 0,
		{   64,  5, 31,  1, 308, 255,0xc0,0x00, 64,  0},
	},
	{
		"SPE1", "Spectravideo SV-328 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 17, 256, 2,
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,},
		ORD_CYLINDERS, 0,
		{   34,  4, 15,  1, 162,  63,0x80,0x00, 16,  3},
	},
	{
		"SPE2", "Sperry UTS 30, UTS 5000 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  9, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  4, 15,  0, 354, 383,0xfc,0x00, 96,  2},
	},
	{
		"SUP1", "Superbrain JR - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 35,1, 10, 512, 1,
		{  0, 1,3,5,7,9,2,4,6,8,10,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1,  81,  63,0x80,0x00, 16,  2},
	},
	{
		"SUP2", "Superbrain 40 track - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 10, 512, 1,
		{  0, 1,3,5,7,9,2,4,6,8,10,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1,  94,  63,0x80,0x00, 16,  2},
	},
	{
		"SUP3", "Superbrain QD - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 35,2, 10, 512, 1,
		{  0, 1,3,5,7,9,2,4,6,8,10,},
		{  1, 1,3,5,7,9,2,4,6,8,10,},
		ORD_CYLINDERS, 0,
		{   40,  4, 15,  1, 169,  63,0x80,0x00, 16,  2},
	},
	{
		"SYS2", "Systel 2 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  9, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  3,  7,  0, 170, 127,0xf0,0x00, 32,  2},
	},
	{
		"SYS3", "Systel 3 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  9, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  4, 15,  1, 174, 127,0xc0,0x00, 32,  2},
	},
	{
		"TEK1", "Tektronix 4170 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_CYLINDERS, 0,
		{   32,  4, 15,  0, 153,  63,0x80,0x00, 16,  1},
	},
	{
		"TEL2", "Teletek Systemaster - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 18, 256, 1,
		{  0, 1,7,13,2,8,14,3,9,15,4,10,16,5,11,17,6,12,18,},
		{  1, 1,7,13,2,8,14,3,9,15,4,10,16,5,11,17,6,12,18,},
		ORD_CYLINDERS, 0,
		{   36,  4, 15,  1, 172, 127,0xc0,0x00, 32,  3},
	},
	{
		"TEL3", "Televideo 801, 806 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 18, 256, 6,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,},
		ORD_SIDES, 0,
		{   36,  4, 15,  0, 170,  63,0x80,0x00, 16,  4},
	},
	{
		"TEL4", "Televideo 1603 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  9, 512, 3,
		{  0, 1,2,3,4,5,6,7,8,9,},
		{  1, 1,2,3,4,5,6,7,8,9,},
		ORD_SIDES, 0,
		{   36,  4, 15,  0, 354, 127,0xc0,0x00, 32,  2},
	},
	{
		"TI1", "TI Professional, CP/M-86 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 155,  63,0xc0,0x00, 16,  1},
	},
	{
		"TOS1", "Toshiba T100, T200 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 1,
		{  0, 1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16,},
		{  1, 1,5,9,13,2,6,10,14,3,7,11,15,4,8,12,16,},
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 255,  63,0xc0,0x00, 16,  6},
	},
	{
		"TRS1", "TRS-80 Model 1, Omikron CP/M - SSSD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_FM_LO,  0,1, 18, 128, 1,
		{  0, 1,5,9,13,17,3,7,11,15,2,6,10,14,18,4,8,12,16,},
		{  0, },
		ORD_SIDES, 0,
		{   18,  3,  7,  0,  71,  63,0xc0,0x00, 16,  3},
	},
	{
		"TRS3", "TRS-80 Model 1, Color Power II - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 18, 256, 5,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  3,  7,  0, 170,  63,0xc0,0x00, 16,  2},
	},
	{
		"TRS7", "TRS-80, Holmes CP/M - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 4,
		{  0, 0,1,2,3,4,5,6,7,8,9,},
		{  1, 10,11,12,13,14,15,16,17,18,19,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 190,  63,0xf0,0x00, 16,  2},
	},
	{
		"TRS8", "TRS-80, MM CP/M - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 10, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1,  94, 127,0xc0,0x00, 32,  2},
	},
	{
		"TRS9", "TRS-80 Model 4, MT CP/M - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 18, 256, 1,
		{  0, 1,3,5,7,9,11,13,15,17,2,4,6,8,10,12,14,16,18,},
		{  0, },
		ORD_SIDES, 0,
		{   36,  4, 15,  1,  84, 127,0xc0,0x00, 32,  2},
	},
	{
		"TRSA", "TRS-80 Model 4, MT CP/M - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 18, 256, 1,
		{  0, 1,3,5,7,9,11,13,15,17,2,4,6,8,10,12,14,16,18,},
		{  1, 1,3,5,7,9,11,13,15,17,2,4,6,8,10,12,14,16,18,},
		ORD_SIDES, 0,
		{   36,  4, 15,  1, 174, 127,0xc0,0x00, 32,  2},
	},
	{
		"TRSB", "TRS-80 Model 4 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  8, 512, 4,
		{  0, 1,2,3,4,5,6,7,8,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 155,  63,0xc0,0x00, 16,  1},
	},
	{
		"TRSC", "TRS-80 Model 3, Hurricane CP/M - SSDD 48 tpi 5.25\"",
		"MOR1",	/* reused format */
	},
	{
		"VEC1", "Vector 4 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2,  9, 512, 2,
		{  240, 1,2,3,4,5,6,7,8,9,},
		{  242, 1,2,3,4,5,6,7,8,9,},
		ORD_EAGLE, 0,
		{   36,  4, 15,  0, 356, 127,0xc0,0x00, 32,  1},
	},
	{
		"VIS1", "Visual 1050 - SSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,1, 10, 512, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  2},
	},
	{
		"WAN1", "Wangwriter - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 155, 127,0xc0,0x00, 32,  2},
	},
	{
		"WAV1", "Wave Mate Bullet - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  5,1024, 1,
		{  0, 1,2,3,4,5,},
		{  0, },
		ORD_SIDES, 0,
		{   40,  3,  7,  0, 189,  63,0xc0,0x00, 16,  2},
	},
	{
		"XER1", "Xerox (512 byte/sector) - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  1, 1,2,3,4,5,6,7,8,9,10,},
		ORD_CYLINDERS, 0,
		{   40,  4, 15,  1, 170, 127,0xc0,0x00, 32,  2},
	},
	{
		"XER2", "Xerox 820 - SSSD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_FM_LO, 40,1, 18, 128, 1,
		{  0, 1,6,11,16,3,8,13,18,5,10,15,2,7,12,17,4,9,14,},
		{  0, },
		ORD_SIDES, 0,
		{   18,  3,  7,  0,  82,  31,0x80,0x00,  8,  3},
	},
	{
		"XER3", "Xerox 820 II - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 17, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,},
		{  0, },
		ORD_SIDES, 0,
		{   34,  3,  7,  0, 156,  63,0xc0,0x00, 16,  3},
	},
	{
		"XER4", "Xerox 820-II and 16/8 (EM II) - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 17, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,},
		ORD_EAGLE, "XER4",
		{   34,  4, 15,  1, 162,  63,0xc0,0x00, 16,  3},
	},
	{
		"XER7", "XEROX 16/8, EM-II (Standalone) - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  9, 512, 2,
		{  240, 1,2,3,4,5,6,7,8,9,},
		{  242, 1,2,3,4,5,6,7,8,9,},
		ORD_CYLINDERS, 0,
		{   36,  4, 15,  1, 162,  63,0x80,0x00, 16,  2},
	},
	{
		"XOR1", "Xor 5 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 1,6,2,7,3,8,4,9,5,10,},
		{  0, 1,6,2,7,3,8,4,9,5,10,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 191, 127,0xc0,0x00, 32,  3},
	},
	{
		"XYZ1", "XYZ - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 1,
		{  0, 1,5,9,3,7,2,6,10,4,8,},
		{  1, 11,15,19,13,17,12,16,20,14,18,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194, 127,0xc0,0x00, 32,  4},
	},
	{
		"ZEN1", "Zenith Z-37 Disk - SSSD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_FM_LO, 40,1, 10, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  0, },
		ORD_SIDES, 0,
		{   20,  3,  7,  0,  91,  63,0xc0,0x00, 16,  3},
	},
	{
		"ZEN2", "Zenith Z-37 Disk - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 315, 255,0xf0,0x00, 64,  2},
	},
	{
		"ZEN3", "Zenith Z89, Heath H89 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 155, 255,0xf0,0x00, 64,  2},
	},
	{
		"ZEN4", "Zenith Z89, Heath H89 - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 16, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 315, 255,0xf0,0x00, 64,  2},
	},
	{
		"ZEN5", "Zenith Z90 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1, 16, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 151, 127,0xf0,0x00, 32,  2},
	},
	{
		"ZEN6", "Zenith Z90 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 16, 256, 3,
		{  0, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		{  1, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,},
		ORD_SIDES, 0,
		{   32,  4, 15,  0, 155, 255,0xf0,0x00, 64,  2},
	},
	{
		"ZEN7", "Zenith Z-100 - SSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,1,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  0, },
		ORD_SIDES, 0,
		{   32,  3,  7,  0, 151, 127,0xf0,0x00, 32,  2},
	},
	{
		"ZEN8", "Zenith Z-100 - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2,  8, 512, 1,
		{  0, 1,2,3,4,5,6,7,8,},
		{  1, 1,2,3,4,5,6,7,8,},
		ORD_SIDES, 0,
		{   32,  4, 15,  1, 155, 255,0xf0,0x00, 64,  2},
	},
	{
		"ZOR1", "Zorba - DSDD 48 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 40,2, 10, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  0, 11,12,13,14,15,16,17,18,19,20,},
		ORD_SIDES, 0,
		{   40,  4, 15,  1, 194,  63,0x80,0x00, 16,  2},
	},
	{
		"ZOR2", "Zorba - DSDD 96 tpi 5.25\"",
		0,	/* unique format */
		DEN_MFM_LO, 80,2, 10, 512, 2,
		{  0, 1,2,3,4,5,6,7,8,9,10,},
		{  0, 11,12,13,14,15,16,17,18,19,20,},
		ORD_SIDES, 0,
		{   40,  5, 31,  3, 194, 127,0x80,0x00, 32,  2},
	},
	{
		0,	/* end of list */
	}
};
