/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.junit.JUnit3Suite;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001y4\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\t\u0001\u0002\u0005\u0003\u001d5KH+Z:u\u0019&\u001cH/\u001a8fe*\u00111\u0001B\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u000b\u0019\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003\u001d\t1a\u001c:h'\u0011\u0001\u0011\"\u0005\r\u0011\u0005)yQ\"A\u0006\u000b\u00051i\u0011\u0001\u00027b]\u001eT\u0011AD\u0001\u0005U\u00064\u0018-\u0003\u0002\u0011\u0017\t1qJ\u00196fGR\u0004\"A\u0005\f\u000e\u0003MQ!\u0001F\u000b\u0002\u0013\u0019\u0014\u0018-\\3x_J\\'\"A\u0002\n\u0005]\u0019\"\u0001\u0004+fgRd\u0015n\u001d;f]\u0016\u0014\bCA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"aC*dC2\fwJ\u00196fGRD\u0001b\b\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0007e\u0016\u0004xN\u001d;\u0004\u0001A\u0011!eI\u0007\u0002\t%\u0011A\u0005\u0002\u0002\t%\u0016\u0004xN\u001d;fe\"Aa\u0005\u0001B\u0001B\u0003%q%A\u0004ue\u0006\u001c7.\u001a:\u0011\u0005\tB\u0013BA\u0015\u0005\u0005\u001d!&/Y2lKJDQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDcA\u00170aA\u0011a\u0006A\u0007\u0002\u0005!)qD\u000ba\u0001C!)aE\u000ba\u0001O!9!\u0007\u0001b\u0001\n\u0013\u0019\u0014A\u00044bS2,G\rV3tiN\u001cV\r^\u000b\u0002iA\u0019QG\u000f\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u000f5,H/\u00192mK*\u0011\u0011HG\u0001\u000bG>dG.Z2uS>t\u0017BA\u001e7\u0005\r\u0019V\r\u001e\t\u0003%uJ!AP\n\u0003\tQ+7\u000f\u001e\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001b\u0002\u001f\u0019\f\u0017\u000e\\3e)\u0016\u001cHo]*fi\u0002BQA\u0011\u0001\u0005\n\r\u000bqcZ3u'VLG/\u001a(b[\u00164uN\u001d+fgR\u001c\u0015m]3\u0015\u0005\u0011[\u0005CA#I\u001d\tIb)\u0003\u0002H5\u00051\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9%\u0004C\u0003M\u0003\u0002\u0007A(\u0001\u0005uKN$8)Y:f\u0011\u0015q\u0005\u0001\"\u0001P\u0003a9W\r^'fgN\fw-Z$jm\u0016tG\u000b\u001b:po\u0006\u0014G.\u001a\u000b\u0004!J\u0003\u0007C\u0001\u0006R\u0013\tI5\u0002C\u0003T\u001b\u0002\u0007A+A\u0005uQJ|w/\u00192mKB\u0011Q+\u0018\b\u0003-ns!a\u0016.\u000e\u0003aS!!\u0017\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012B\u0001/\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u0013QC'o\\<bE2,'B\u0001/\u001b\u0011\u0015\tW\n1\u0001c\u0003YI7/Q:tKJ$\u0018n\u001c8GC&dW\rZ#se>\u0014\bCA\rd\u0013\t!'DA\u0004C_>dW-\u00198\t\u000b\u0019\u0004A\u0011A4\u0002\u0013M$\u0018M\u001d;UKN$HC\u00015l!\tI\u0012.\u0003\u0002k5\t!QK\\5u\u0011\u0015aU\r1\u0001=\u0011\u0015i\u0007\u0001\"\u0001o\u0003!\tG\rZ#se>\u0014Hc\u00015pa\")A\n\u001ca\u0001y!)1\u000b\u001ca\u0001)\")!\u000f\u0001C\u0001g\u0006Q\u0011\r\u001a3GC&dWO]3\u0015\u0007!$X\u000fC\u0003Mc\u0002\u0007A\bC\u0003wc\u0002\u0007q/\u0001\u000bbgN,'\u000f^5p]\u001a\u000b\u0017\u000e\\3e\u000bJ\u0014xN\u001d\t\u0003%aL!!_\n\u0003)\u0005\u001b8/\u001a:uS>tg)Y5mK\u0012,%O]8s\u0011\u0015Y\b\u0001\"\u0001}\u0003\u001d)g\u000e\u001a+fgR$\"\u0001[?\t\u000b1S\b\u0019\u0001\u001f")
public class MyTestListener
implements TestListener,
ScalaObject {
    private final Reporter report;
    private final Tracker tracker;
    private final Set<Test> failedTestsSet;

    private Set<Test> failedTestsSet() {
        return this.failedTestsSet;
    }

    private String getSuiteNameForTestCase(Test testCase) {
        Test test = testCase;
        return test instanceof JUnit3Suite ? ((JUnit3Suite)test).suiteName() : Suite$.MODULE$.getSimpleNameOfAnObjectsClass(testCase);
    }

    public String getMessageGivenThrowable(Throwable throwable, boolean isAssertionFailedError) {
        return throwable.getMessage() == null ? new StringBuilder().append((Object)"A JUnit3Suite test failed with an ").append((Object)(isAssertionFailedError ? "AssertionFailedError" : "exception")).toString() : throwable.getMessage();
    }

    public void startTest(Test testCase) {
        if (testCase == null) {
            throw new NullPointerException("testCase was null");
        }
        this.report.apply(TestStarting$.MODULE$.apply(this.tracker.nextOrdinal(), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Formatter>)new Some((Object)MotionToSuppress$.MODULE$), (Option<Rerunner>)None$.MODULE$));
    }

    public void addError(Test testCase, Throwable throwable) {
        if (testCase == null) {
            throw new NullPointerException("testCase was null");
        }
        if (throwable == null) {
            throw new NullPointerException("throwable was null");
        }
        IndentedText formatter = Suite$.MODULE$.getIndentedText(testCase.toString(), 1, true);
        this.report.apply(TestFailed$.MODULE$.apply(this.tracker.nextOrdinal(), this.getMessageGivenThrowable(throwable, false), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Throwable>)new Some((Object)throwable), (Option<Long>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$));
        this.failedTestsSet().$plus$eq((Object)testCase);
    }

    public void addFailure(Test testCase, AssertionFailedError assertionFailedError) {
        if (testCase == null) {
            throw new NullPointerException("testCase was null");
        }
        if (assertionFailedError == null) {
            throw new NullPointerException("throwable was null");
        }
        IndentedText formatter = Suite$.MODULE$.getIndentedText(testCase.toString(), 1, true);
        this.report.apply(TestFailed$.MODULE$.apply(this.tracker.nextOrdinal(), this.getMessageGivenThrowable((Throwable)assertionFailedError, true), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Throwable>)new Some((Object)assertionFailedError), (Option<Long>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$));
        this.failedTestsSet().$plus$eq((Object)testCase);
    }

    public void endTest(Test testCase) {
        boolean testHadFailed = this.failedTestsSet().contains((Object)testCase);
        if (testHadFailed) {
            this.failedTestsSet().$minus$eq((Object)testCase);
        } else {
            if (testCase == null) {
                throw new NullPointerException("testCase was null");
            }
            IndentedText formatter = Suite$.MODULE$.getIndentedText(testCase.toString(), 1, true);
            this.report.apply(TestSucceeded$.MODULE$.apply(this.tracker.nextOrdinal(), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Long>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$));
        }
    }

    public MyTestListener(Reporter report, Tracker tracker) {
        this.report = report;
        this.tracker = tracker;
        this.failedTestsSet = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Test[0]));
    }
}

