/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.eclipse.contribution.weaving.jdt.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import scala.tools.eclipse.contribution.weaving.jdt.ScalaJDTWeavingPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProviderRegistry<T> {
    private List<T> registry = null;

    protected abstract String getExtensionPointId();

    public List<T> getProviders() {
        if (this.registry == null) {
            this.registry = this.registerProviders();
        }
        return this.registry;
    }

    public List<T> registerProviders() {
        ArrayList<Object> registry = new ArrayList<Object>();
        IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(this.getExtensionPointId());
        if (exP != null) {
            IExtension[] exs = exP.getExtensions();
            int i = 0;
            while (i < exs.length) {
                IConfigurationElement[] configs = exs[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    try {
                        IConfigurationElement config = configs[j];
                        if (config.isValid()) {
                            Object provider = config.createExecutableExtension("class");
                            registry.add(provider);
                        }
                    }
                    catch (CoreException e) {
                        ScalaJDTWeavingPlugin.logException(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return Collections.unmodifiableList(registry);
    }
}

