/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorHandler;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Sender {
    PipelineConfiguration pipe;

    public Sender(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
    }

    public void send(Source source, Receiver receiver) throws XPathException {
        this.send(source, receiver, false);
    }

    public void send(Source source, Receiver receiver, boolean bl) throws XPathException {
        Source source2;
        int n;
        Object object;
        int n2;
        Configuration configuration = this.pipe.getConfiguration();
        receiver.setPipelineConfiguration(this.pipe);
        receiver.setSystemId(source.getSystemId());
        Receiver receiver2 = receiver;
        int n3 = 13;
        boolean bl2 = configuration.isXIncludeAware();
        int n4 = configuration.getSchemaValidationMode();
        int n5 = n2 = configuration.isValidation() ? 1 : 4;
        if (bl) {
            n4 |= 0x10000;
        }
        XMLReader xMLReader = null;
        if (source instanceof AugmentedSource) {
            int n6;
            n3 = ((AugmentedSource)source).getStripSpace();
            if (n3 == 13) {
                n3 = configuration.getStripsWhiteSpace();
            }
            if (n3 == 12) {
                AllElementStripper allElementStripper = new AllElementStripper();
                allElementStripper.setStripAll();
                allElementStripper.setPipelineConfiguration(this.pipe);
                allElementStripper.setUnderlyingReceiver(receiver);
                receiver2 = allElementStripper;
            }
            bl2 = ((AugmentedSource)source).isXIncludeAwareSet() ? ((AugmentedSource)source).isXIncludeAware() : configuration.isXIncludeAware();
            int n7 = ((AugmentedSource)source).getSchemaValidation();
            if (n7 != 0) {
                n4 = n7;
            }
            if ((n6 = ((AugmentedSource)source).getDTDValidation()) != 0) {
                n2 = n6;
            }
            xMLReader = ((AugmentedSource)source).getXMLReader();
            object = ((AugmentedSource)source).getFilters();
            if (object != null) {
                for (n = object.size() - 1; n >= 0; --n) {
                    ProxyReceiver proxyReceiver = (ProxyReceiver)object.get(n);
                    proxyReceiver.setPipelineConfiguration(this.pipe);
                    proxyReceiver.setSystemId(source.getSystemId());
                    proxyReceiver.setUnderlyingReceiver(receiver2);
                    receiver2 = proxyReceiver;
                }
            }
            source = ((AugmentedSource)source).getContainedSource();
        }
        if (source instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)source;
            String string = nodeInfo.getBaseURI();
            int n8 = n4 & 0xFF;
            if (n8 != 3) {
                receiver2 = configuration.getDocumentValidator(receiver2, string, n8, n3, null);
            }
            if ((n = nodeInfo.getNodeKind()) != 9 && n != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            receiver2.setSystemId(string);
            this.sendDocumentInfo(nodeInfo, receiver2);
            return;
        }
        if (source instanceof PullSource) {
            if (bl2) {
                throw new DynamicError("XInclude processing is not supported with a pull parser");
            }
            this.sendPullSource((PullSource)source, receiver2, n4, n3);
            return;
        }
        if (source instanceof SAXSource) {
            this.sendSAXSource((SAXSource)source, receiver2, n4, n3, bl2);
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            Source source3 = Configuration.getPlatform().getParserSource(configuration, streamSource, n4, n2 == 1, n3);
            if (source3 == streamSource) {
                object = source.getSystemId();
                InputSource inputSource = new InputSource((String)object);
                inputSource.setCharacterStream(streamSource.getReader());
                inputSource.setByteStream(streamSource.getInputStream());
                boolean bl3 = false;
                if (xMLReader == null) {
                    xMLReader = configuration.getSourceParser();
                    bl3 = true;
                }
                SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
                sAXSource.setSystemId(source.getSystemId());
                this.sendSAXSource(sAXSource, receiver2, n4, n3, bl2);
                if (bl3) {
                    configuration.reuseSourceParser(xMLReader);
                }
            } else {
                this.send(source3, receiver2, bl);
            }
            return;
        }
        if ((n4 & 0xFF) != 3) {
            receiver2 = configuration.getDocumentValidator(receiver2, source.getSystemId(), n4, n3, null);
        }
        if ((source2 = configuration.getSourceResolver().resolveSource(source, configuration)) instanceof StreamSource || source2 instanceof SAXSource || source2 instanceof NodeInfo || source2 instanceof PullSource || source2 instanceof AugmentedSource) {
            this.send(source2, receiver2, bl);
        }
        List list = configuration.getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
            boolean bl4 = externalObjectModel.sendSource(source, receiver2, this.pipe);
            if (!bl4) continue;
            return;
        }
        if (source instanceof DOMSource) {
            throw new DynamicError("DOMSource cannot be processed: check that saxon8-dom.jar is on the classpath");
        }
        throw new DynamicError("A source of type " + source.getClass().getName() + " is not supported in this environment");
    }

    private void sendDocumentInfo(NodeInfo nodeInfo, Receiver object) throws XPathException {
        Object object2;
        NamePool namePool = this.pipe.getConfiguration().getNamePool();
        if (nodeInfo.getNamePool() != namePool) {
            object2 = new NamePoolConverter(nodeInfo.getNamePool(), namePool);
            ((NamePoolConverter)object2).setUnderlyingReceiver((Receiver)object);
            ((ProxyReceiver)object2).setPipelineConfiguration(object.getPipelineConfiguration());
            object = object2;
        }
        object2 = new DocumentSender(nodeInfo);
        ((DocumentSender)object2).send((Receiver)object);
    }

    private void sendSAXSource(SAXSource sAXSource, Receiver receiver, int n, int n2, boolean bl) throws XPathException {
        ContentHandler contentHandler;
        Object object;
        XMLReader xMLReader = sAXSource.getXMLReader();
        boolean bl2 = false;
        Configuration configuration = this.pipe.getConfiguration();
        if (xMLReader == null) {
            object = new SAXSource();
            ((SAXSource)object).setInputSource(sAXSource.getInputSource());
            ((SAXSource)object).setSystemId(sAXSource.getSystemId());
            xMLReader = configuration.getSourceParser();
            ((SAXSource)object).setXMLReader(xMLReader);
            sAXSource = object;
            bl2 = true;
        } else {
            Sender.configureParser(xMLReader);
        }
        if (bl) {
            boolean bl3 = false;
            try {
                xMLReader.setFeature("http://apache.org/xml/features/xinclude-aware", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                bl3 = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                bl3 = true;
            }
            if (bl3) {
                try {
                    xMLReader.setFeature("http://apache.org/xml/features/xinclude", true);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    throw new DynamicError("Selected XML parser " + xMLReader.getClass().getName() + " does not recognize request for XInclude processing");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    throw new DynamicError("Selected XML parser " + xMLReader.getClass().getName() + " does not support XInclude processing");
                }
            }
        }
        xMLReader.setErrorHandler(new StandardErrorHandler(this.pipe.getErrorListener()));
        if ((n & 0xFF) != 3) {
            receiver = configuration.getDocumentValidator(receiver, sAXSource.getSystemId(), n, n2, null);
        }
        if ((contentHandler = xMLReader.getContentHandler()) instanceof ReceivingContentHandler) {
            object = (ReceivingContentHandler)contentHandler;
            ((ReceivingContentHandler)object).reset();
        } else {
            object = new ReceivingContentHandler();
            xMLReader.setContentHandler((ContentHandler)object);
            xMLReader.setDTDHandler((DTDHandler)object);
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        ((ReceivingContentHandler)object).setReceiver(receiver);
        ((ReceivingContentHandler)object).setPipelineConfiguration(this.pipe);
        try {
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof XPathException) {
                throw (XPathException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            DynamicError dynamicError = new DynamicError(sAXException);
            dynamicError.setHasBeenReported();
            throw dynamicError;
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
        if (bl2) {
            configuration.reuseSourceParser(xMLReader);
        }
    }

    private void sendPullSource(PullSource pullSource, Receiver receiver, int n, int n2) throws XPathException {
        Object object;
        if ((n & 0xFF) != 3) {
            object = this.pipe.getConfiguration();
            receiver = ((Configuration)object).getDocumentValidator(receiver, pullSource.getSystemId(), n, n2, null);
        }
        receiver.open();
        object = pullSource.getPullProvider();
        if (object instanceof LocationProvider) {
            this.pipe.setLocationProvider((LocationProvider)object);
        }
        object.setPipelineConfiguration(this.pipe);
        receiver.setPipelineConfiguration(this.pipe);
        PullPushCopier pullPushCopier = new PullPushCopier((PullProvider)object, receiver);
        pullPushCopier.copy();
        receiver.close();
    }

    public static void configureParser(XMLReader xMLReader) throws DynamicError {
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new DynamicError("The SAX2 parser does not recognize the 'namespaces' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new DynamicError("The SAX2 parser does not support setting the 'namespaces' feature to true");
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new DynamicError("The SAX2 parser does not recognize the 'namespace-prefixes' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new DynamicError("The SAX2 parser does not support setting the 'namespace-prefixes' feature to false");
        }
    }
}

