/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ExtendedNodeInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xom.DocumentWrapper;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class NodeWrapper
implements NodeInfo,
ExtendedNodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Node node;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    protected NodeWrapper(Node node, NodeWrapper nodeWrapper, int n) {
        int n2;
        if (node instanceof Element) {
            n2 = 1;
        } else if (node instanceof Text) {
            n2 = 3;
        } else if (node instanceof Attribute) {
            n2 = 2;
        } else if (node instanceof Comment) {
            n2 = 8;
        } else if (node instanceof ProcessingInstruction) {
            n2 = 7;
        } else if (node instanceof Document) {
            n2 = 9;
        } else {
            NodeWrapper.throwIllegalNode(node);
            return;
        }
        this.nodeKind = (short)n2;
        this.node = node;
        this.parent = nodeWrapper;
        this.index = n;
    }

    protected final NodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper) {
        return this.makeWrapper(node, documentWrapper, null, -1);
    }

    protected final NodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, NodeWrapper nodeWrapper, int n) {
        if (node == documentWrapper.node) {
            return documentWrapper;
        }
        NodeWrapper nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
        nodeWrapper2.docWrapper = documentWrapper;
        return nodeWrapper2;
    }

    private static void throwIllegalNode(Node node) {
        String string = node == null ? "NULL" : node.getClass() + " instance " + node.toString();
        throw new IllegalArgumentException("Bad node type in XOM! " + string);
    }

    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((Item)((AtomicValue)this.atomize()));
    }

    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 631;
        }
        return 630;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (nodeInfo instanceof NodeWrapper) {
            return this.node == ((NodeWrapper)nodeInfo).node;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof NodeInfo) {
            return this.isSameNodeInfo((NodeInfo)object);
        }
        return false;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String string) {
        this.docWrapper.baseURI = string;
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof NodeWrapper) {
            return NodeWrapper.compareOrderFast(this.node, ((NodeWrapper)nodeInfo).node);
        }
        return -nodeInfo.compareOrder((NodeInfo)this);
    }

    private static int compareOrderFast(Node node, Node node2) {
        if (node == node2) {
            return 0;
        }
        ParentNode parentNode = node.getParent();
        ParentNode parentNode2 = node2.getParent();
        if (parentNode == null) {
            if (parentNode2 != null) {
                return -1;
            }
            return node.hashCode() - node2.hashCode();
        }
        if (parentNode2 == null) {
            return 1;
        }
        if (parentNode == parentNode2) {
            int n = parentNode.indexOf(node);
            int n2 = parentNode.indexOf(node2);
            if (n != -1) {
                return n2 != -1 ? n - n2 : 1;
            }
            if (n2 != -1) {
                return -1;
            }
            Element element = (Element)parentNode;
            int n3 = element.getAttributeCount();
            while (--n3 >= 0) {
                Attribute attribute = element.getAttribute(n3);
                if (attribute == node2) {
                    return -1;
                }
                if (attribute != node) continue;
                return 1;
            }
            throw new IllegalStateException("should be unreachable");
        }
        int n = 0;
        int n4 = 0;
        Node node3 = node;
        Node node4 = node2;
        while (node3 != null) {
            ++n;
            if ((node3 = node3.getParent()) != node2) continue;
            return 1;
        }
        while (node4 != null) {
            ++n4;
            if ((node4 = node4.getParent()) != node) continue;
            return -1;
        }
        node3 = node;
        while (n > n4) {
            node3 = node3.getParent();
            --n;
        }
        node4 = node2;
        while (n4 > n) {
            node4 = node4.getParent();
            --n4;
        }
        while (true) {
            parentNode = node3.getParent();
            parentNode2 = node4.getParent();
            if (parentNode == null || parentNode2 == null) {
                return node3.hashCode() - node4.hashCode();
            }
            if (parentNode == parentNode2) {
                return parentNode.indexOf(node3) - parentNode.indexOf(node4);
            }
            node3 = parentNode;
            node4 = parentNode2;
        }
    }

    public String getStringValue() {
        return this.node.getValue();
    }

    public CharSequence getStringValueCS() {
        return this.node.getValue();
    }

    public int getNameCode() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                return this.docWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getLocalName();
            }
            case 2: {
                return ((Attribute)this.node).getLocalName();
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
        }
        return "";
    }

    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        ParentNode parentNode;
        if (this.parent == null && (parentNode = this.node.getParent()) != null) {
            this.parent = this.makeWrapper((Node)parentNode, this.docWrapper);
        }
        return this.parent;
    }

    public int getSiblingPosition() {
        int n;
        if (this.index != -1) {
            return this.index;
        }
        switch (this.nodeKind) {
            case 2: {
                Attribute attribute = (Attribute)this.node;
                Element element = (Element)attribute.getParent();
                if (element == null) {
                    return 0;
                }
                int n2 = element.getAttributeCount();
                while (--n2 >= 0) {
                    if (element.getAttribute(n2) != attribute) continue;
                    this.index = n2;
                    return n2;
                }
                throw new IllegalStateException("XOM node not linked to parent node");
            }
        }
        ParentNode parentNode = this.node.getParent();
        int n3 = n = parentNode == null ? 0 : parentNode.indexOf(this.node);
        if (n == -1) {
            throw new IllegalStateException("XOM node not linked to parent node");
        }
        this.index = n;
        return this.index;
    }

    public AxisIterator iterateAxis(byte by) {
        return this.iterateAxis(by, (NodeTest)AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                return new AncestorAxisIterator(this, false, nodeTest);
            }
            case 1: {
                return new AncestorAxisIterator(this, true, nodeTest);
            }
            case 2: {
                if (this.nodeKind != 1 || ((Element)this.node).getAttributeCount() == 0) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeAxisIterator(this, nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new ChildAxisIterator(this, true, true, nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new DescendantAxisIterator(this, false, false, nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                if (this.hasChildNodes()) {
                    return new DescendantAxisIterator(this, true, false, nodeTest);
                }
                return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
            }
            case 6: {
                if (this.getParent() == null) {
                    return EmptyIterator.getInstance();
                }
                return new DescendantAxisIterator(this, false, true, nodeTest);
            }
            case 7: {
                if (this.nodeKind == 2 || this.getParent() == null) {
                    return EmptyIterator.getInstance();
                }
                return new ChildAxisIterator(this, false, true, nodeTest);
            }
            case 8: {
                if (this.nodeKind == 1) {
                    return NamespaceIterator.makeIterator((NodeInfo)this, (NodeTest)nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 9: {
                if (this.getParent() == null) {
                    return EmptyIterator.getInstance();
                }
                return Navigator.filteredSingleton((NodeInfo)this.getParent(), (NodeTest)nodeTest);
            }
            case 10: {
                return new PrecedingAxisIterator(this, false, nodeTest);
            }
            case 11: {
                if (this.nodeKind == 2 || this.getParent() == null) {
                    return EmptyIterator.getInstance();
                }
                return new ChildAxisIterator(this, false, false, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
            }
            case 13: {
                return new PrecedingAxisIterator(this, true, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(int n) {
        String string;
        NamePool namePool;
        String string2;
        Attribute attribute;
        if (this.nodeKind == 1 && (attribute = ((Element)this.node).getAttribute(string2 = (namePool = this.docWrapper.getNamePool()).getLocalName(n), string = namePool.getURI(n))) != null) {
            return attribute.getValue();
        }
        return null;
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        if (this.docWrapper.node instanceof Document) {
            return this.docWrapper;
        }
        return null;
    }

    public boolean hasChildNodes() {
        return this.node.getChildCount() > 0;
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        Navigator.appendSequentialKey((SiblingCountingNode)this, (FastStringBuffer)fastStringBuffer, (boolean)true);
    }

    public int getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)receiver, (NamePool)this.docWrapper.getNamePool(), (int)n, (boolean)bl, (int)n2);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        Navigator.sendNamespaceDeclarations((NodeInfo)this, (Receiver)receiver, (boolean)bl);
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        if (this.node instanceof Element) {
            Element element = (Element)this.node;
            int n = element.getNamespaceDeclarationCount();
            if (n == 0) {
                return EMPTY_NAMESPACE_LIST;
            }
            int[] nArray2 = n <= nArray.length ? nArray : new int[n];
            NamePool namePool = this.getNamePool();
            for (int i = 0; i < n; ++i) {
                String string = element.getNamespacePrefix(i);
                String string2 = element.getNamespaceURI(string);
                nArray2[i] = namePool.allocateNamespaceCode(string, string2);
            }
            if (n < nArray2.length) {
                nArray2[n] = -1;
            }
            return nArray2;
        }
        return null;
    }

    public boolean isId() {
        return this.getNodeKind() == 2 && ((Attribute)this.node).getType() == Attribute.Type.ID;
    }

    public boolean isIdref() {
        return this.getNodeKind() == 2 && (((Attribute)this.node).getType() == Attribute.Type.IDREF || ((Attribute)this.node).getType() == Attribute.Type.IDREFS);
    }

    public boolean isNilled() {
        return false;
    }

    private final class PrecedingAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private boolean includeAncestors;
        private Node currNode;
        private ParentNode nextAncestor;
        private NodeInfo current;
        private NodeTest nodeTest;
        private int position;
        private String testLocalName;
        private String testURI;

        public PrecedingAxisIterator(NodeWrapper nodeWrapper2, boolean bl, NodeTest nodeTest) {
            this.start = nodeWrapper2;
            this.includeAncestors = bl;
            this.currNode = nodeWrapper2.node;
            this.nextAncestor = bl ? null : nodeWrapper2.node.getParent();
            if (nodeTest == AnyNodeTest.getInstance()) {
                nodeTest = null;
            } else if (nodeTest instanceof NameTest) {
                NameTest nameTest = (NameTest)nodeTest;
                if (nameTest.getPrimitiveType() == 1) {
                    NamePool namePool = NodeWrapper.this.getNamePool();
                    this.testLocalName = namePool.getLocalName(nameTest.getFingerprint());
                    this.testURI = namePool.getURI(nameTest.getFingerprint());
                }
            } else if (nodeTest instanceof NodeKindTest && nodeTest.getPrimitiveType() == 1) {
                this.testLocalName = "";
                this.testURI = null;
            }
            this.nodeTest = nodeTest;
            this.position = 0;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            NodeInfo nodeInfo;
            while ((nodeInfo = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(nodeInfo)) {
            }
            if (nodeInfo != null) {
                ++this.position;
            }
            this.current = nodeInfo;
            return nodeInfo;
        }

        private NodeInfo advance() {
            int n;
            while (true) {
                ParentNode parentNode;
                if ((parentNode = this.currNode.getParent()) == null) {
                    return null;
                }
                n = this.currNode.getParent().indexOf(this.currNode) - 1;
                if (n >= 0) {
                    int n2;
                    parentNode = parentNode.getChild(n);
                    while ((n2 = parentNode.getChildCount() - 1) >= 0) {
                        parentNode = parentNode.getChild(n2);
                        n = n2;
                    }
                } else if (parentNode == this.nextAncestor) {
                    this.nextAncestor = this.nextAncestor.getParent();
                    this.currNode = parentNode;
                    continue;
                }
                this.currNode = parentNode;
                if (this.conforms(this.currNode)) break;
            }
            return NodeWrapper.this.makeWrapper(this.currNode, NodeWrapper.this.docWrapper, null, n);
        }

        private boolean conforms(Node node) {
            if (this.testLocalName != null) {
                if (!(node instanceof Element)) {
                    return false;
                }
                if (this.testURI == null) {
                    return true;
                }
                Element element = (Element)node;
                return this.testLocalName.equals(element.getLocalName()) && this.testURI.equals(element.getNamespaceURI());
            }
            return !(node instanceof DocType);
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            return this.current.iterateAxis(by, nodeTest);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        public SequenceIterator getAnother() {
            return new PrecedingAxisIterator(this.start, this.includeAncestors, this.nodeTest);
        }

        public int getProperties() {
            return 0;
        }
    }

    private final class DescendantAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private boolean includeSelf;
        private boolean following;
        private Node anchor;
        private Node currNode;
        private boolean moveToNextSibling;
        private NodeInfo current;
        private NodeTest nodeTest;
        private int position;
        private String testLocalName;
        private String testURI;

        public DescendantAxisIterator(NodeWrapper nodeWrapper2, boolean bl, boolean bl2, NodeTest nodeTest) {
            this.start = nodeWrapper2;
            this.includeSelf = bl;
            this.following = bl2;
            this.moveToNextSibling = bl2;
            if (!bl2) {
                this.anchor = nodeWrapper2.node;
            }
            if (!bl) {
                this.currNode = nodeWrapper2.node;
            }
            if (nodeTest == AnyNodeTest.getInstance()) {
                nodeTest = null;
            } else if (nodeTest instanceof NameTest) {
                NameTest nameTest = (NameTest)nodeTest;
                if (nameTest.getPrimitiveType() == 1) {
                    NamePool namePool = NodeWrapper.this.getNamePool();
                    this.testLocalName = namePool.getLocalName(nameTest.getFingerprint());
                    this.testURI = namePool.getURI(nameTest.getFingerprint());
                }
            } else if (nodeTest instanceof NodeKindTest && nodeTest.getPrimitiveType() == 1) {
                this.testLocalName = "";
                this.testURI = null;
            }
            this.nodeTest = nodeTest;
            this.position = 0;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            NodeInfo nodeInfo;
            while ((nodeInfo = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(nodeInfo)) {
            }
            if (nodeInfo != null) {
                ++this.position;
            }
            this.current = nodeInfo;
            return nodeInfo;
        }

        private NodeInfo advance() {
            int n;
            if (this.currNode == null) {
                this.currNode = this.start.node;
                return this.start;
            }
            do {
                Node node;
                block5: {
                    n = 0;
                    node = this.currNode;
                    if (node.getChildCount() == 0 || this.moveToNextSibling) {
                        this.moveToNextSibling = false;
                        do {
                            if ((node = this.currNode.getParent()) == null) {
                                return null;
                            }
                            n = this.currNode.getParent().indexOf(this.currNode) + 1;
                            if (n < node.getChildCount()) break block5;
                            this.currNode = node;
                        } while (node != this.anchor);
                        return null;
                    }
                }
                this.currNode = node.getChild(n);
            } while (!this.conforms(this.currNode));
            return NodeWrapper.this.makeWrapper(this.currNode, NodeWrapper.this.docWrapper, null, n);
        }

        private boolean conforms(Node node) {
            if (this.testLocalName != null) {
                if (!(node instanceof Element)) {
                    return false;
                }
                if (this.testURI == null) {
                    return true;
                }
                Element element = (Element)node;
                return this.testLocalName.equals(element.getLocalName()) && this.testURI.equals(element.getNamespaceURI());
            }
            return !(node instanceof DocType);
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            return this.current.iterateAxis(by, nodeTest);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        public SequenceIterator getAnother() {
            return new DescendantAxisIterator(this.start, this.includeSelf, this.following, this.nodeTest);
        }

        public int getProperties() {
            return 0;
        }
    }

    private final class ChildAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private int ix;
        private boolean downwards;
        private boolean forwards;
        private NodeInfo current;
        private ParentNode par;
        private int cursor;
        private NodeTest nodeTest;
        private int position;

        private ChildAxisIterator(NodeWrapper nodeWrapper2, boolean bl, boolean bl2, NodeTest nodeTest) {
            this.start = nodeWrapper2;
            this.downwards = bl;
            this.forwards = bl2;
            if (nodeTest == AnyNodeTest.getInstance()) {
                nodeTest = null;
            }
            this.nodeTest = nodeTest;
            this.position = 0;
            this.commonParent = bl ? nodeWrapper2 : (NodeWrapper)nodeWrapper2.getParent();
            this.par = (ParentNode)this.commonParent.node;
            if (bl) {
                this.ix = bl2 ? 0 : this.par.getChildCount();
            } else {
                this.ix = this.par.indexOf(nodeWrapper2.node);
                if (bl2) {
                    ++this.ix;
                }
            }
            this.cursor = this.ix--;
            if (bl || !bl2) {
                // empty if block
            }
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            NodeInfo nodeInfo;
            while ((nodeInfo = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(nodeInfo)) {
            }
            if (nodeInfo != null) {
                ++this.position;
            }
            this.current = nodeInfo;
            return nodeInfo;
        }

        private NodeInfo advance() {
            Node node;
            do {
                if (this.forwards) {
                    if (this.cursor == this.par.getChildCount()) {
                        return null;
                    }
                    node = this.par.getChild(this.cursor++);
                    continue;
                }
                if (this.cursor == 0) {
                    return null;
                }
                node = this.par.getChild(--this.cursor);
            } while (node instanceof DocType);
            NodeWrapper nodeWrapper = NodeWrapper.this.makeWrapper(node, NodeWrapper.this.docWrapper, this.commonParent, this.ix);
            this.ix += this.forwards ? 1 : -1;
            return nodeWrapper;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            return this.current.iterateAxis(by, nodeTest);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        public SequenceIterator getAnother() {
            return new ChildAxisIterator(this.start, this.downwards, this.forwards, this.nodeTest);
        }

        public int getProperties() {
            return 0;
        }
    }

    private final class AttributeAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private NodeInfo current;
        private int cursor;
        private NodeTest nodeTest;
        private int position;

        public AttributeAxisIterator(NodeWrapper nodeWrapper2, NodeTest nodeTest) {
            this.start = nodeWrapper2;
            if (nodeTest == AnyNodeTest.getInstance()) {
                nodeTest = null;
            }
            this.nodeTest = nodeTest;
            this.position = 0;
            this.cursor = 0;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            NodeInfo nodeInfo;
            while ((nodeInfo = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(nodeInfo)) {
            }
            if (nodeInfo != null) {
                ++this.position;
            }
            this.current = nodeInfo;
            return nodeInfo;
        }

        private NodeInfo advance() {
            Element element = (Element)this.start.node;
            if (this.cursor == element.getAttributeCount()) {
                return null;
            }
            NodeWrapper nodeWrapper = NodeWrapper.this.makeWrapper((Node)element.getAttribute(this.cursor), NodeWrapper.this.docWrapper, this.start, this.cursor);
            ++this.cursor;
            return nodeWrapper;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            return this.current.iterateAxis(by, nodeTest);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        public SequenceIterator getAnother() {
            return new AttributeAxisIterator(this.start, this.nodeTest);
        }

        public int getProperties() {
            return 0;
        }
    }

    private final class AncestorAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private boolean includeSelf;
        private NodeInfo current;
        private NodeTest nodeTest;
        private int position;

        public AncestorAxisIterator(NodeWrapper nodeWrapper2, boolean bl, NodeTest nodeTest) {
            this.start = nodeWrapper2;
            if (nodeTest == AnyNodeTest.getInstance()) {
                nodeTest = null;
            }
            this.nodeTest = nodeTest;
            if (!bl) {
                this.current = nodeWrapper2;
            }
            this.includeSelf = bl;
            this.position = 0;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            NodeInfo nodeInfo;
            while ((nodeInfo = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(nodeInfo)) {
            }
            if (nodeInfo != null) {
                ++this.position;
            }
            this.current = nodeInfo;
            return nodeInfo;
        }

        private NodeInfo advance() {
            this.current = this.current == null ? this.start : this.current.getParent();
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            return this.current.iterateAxis(by, nodeTest);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        public SequenceIterator getAnother() {
            return new AncestorAxisIterator(this.start, this.includeSelf, this.nodeTest);
        }

        public int getProperties() {
            return 0;
        }
    }
}

