/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sql.SQLColumn;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLUpdate
extends ExtensionInstruction {
    Expression connection;
    String table;
    Expression where;

    public void prepareAttributes() throws XPathException {
        String string;
        this.table = this.getAttributeList().getValue("", "table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
        this.where = (string = this.getAttributeList().getValue("", "where")) == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(string);
        String string2 = this.getAttributeList().getValue("", "connection");
        if (string2 == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(string2);
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable executable) throws XPathException {
        NodeInfo nodeInfo;
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append("UPDATE " + this.table + " SET ");
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        int n = 0;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof SQLColumn)) continue;
            if (n++ > 0) {
                stringBuffer.append(',');
            }
            String string = ((SQLColumn)nodeInfo).getColumnName();
            stringBuffer.append(string);
            stringBuffer.append("=?");
        }
        return new UpdateInstruction(this.connection, stringBuffer.toString(), this.getColumnInstructions(executable), this.where);
    }

    public List getColumnInstructions(Executable executable) throws XPathException {
        NodeInfo nodeInfo;
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof SQLColumn)) continue;
            arrayList.add(((SQLColumn)nodeInfo).compile(executable));
        }
        return arrayList;
    }

    private static class UpdateInstruction
    extends SimpleExpression {
        private static final long serialVersionUID = -4234440812734827279L;
        public static final int CONNECTION = 0;
        public static final int WHERE = 1;
        public static final int FIRST_COLUMN = 2;
        String statement;

        public UpdateInstruction(Expression expression, String string, List list, Expression expression2) {
            Expression[] expressionArray = new Expression[list.size() + 2];
            expressionArray[0] = expression;
            expressionArray[1] = expression2;
            for (int i = 0; i < list.size(); ++i) {
                expressionArray[i + 2] = (Expression)list.get(i);
            }
            this.statement = string;
            this.setArguments(expressionArray);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:update";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            Item item = this.arguments[0].evaluateItem(xPathContext);
            if (!(item instanceof ObjectValue) || !(((ObjectValue)item).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", xPathContext);
            }
            Connection connection = (Connection)((ObjectValue)item).getObject();
            PreparedStatement preparedStatement = null;
            String string = this.arguments[1].evaluateAsString(xPathContext);
            String string2 = this.statement;
            if (!string.equals("")) {
                string2 = string2 + " WHERE " + string;
            }
            try {
                preparedStatement = connection.prepareStatement(string2);
                int n = 1;
                for (int i = 2; i < this.arguments.length; ++i) {
                    AtomicValue atomicValue = (AtomicValue)((SQLColumn.ColumnInstruction)this.arguments[i]).getSelectValue(xPathContext);
                    String string3 = atomicValue.getStringValue();
                    if (string3.length() == 1) {
                        string3 = string3 + " ";
                    }
                    preparedStatement.setObject(n++, string3);
                }
                preparedStatement.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException sQLException) {
                this.dynamicError("SQL UPDATE failed: " + sQLException.getMessage(), "SXSQ0004", xPathContext);
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return null;
        }
    }
}

