<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" version="2.0">
    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> Sep 10, 2010</xd:p>
            <xd:p><xd:b>Author:</xd:b> Michael Kay, Saxonica</xd:p>
            <xd:p>Generates FeatureKeys.java from FeatureKeys.xml</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xsl:output method="text"/>
    
    <xsl:template match="features">
        <xsl:text>package net.sf.saxon.lib;&#xa;&#xa;</xsl:text>
        
        <xsl:text>// GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE&#xa;&#xa;</xsl:text>
        
        <xsl:text>
/**
  * FeatureKeys defines a set of constants, representing the names of Saxon configuration
  * options which can be supplied to the Saxon implementations of the JAXP
  * interfaces TransformerFactory, SchemaFactory, Validator, and ValidationHandler,
  * and to other interfaces such as the s9api {@link net.sf.saxon.s9api.Processor}
  *
  * @author Michael H. Kay
  */

public abstract class FeatureKeys {
        </xsl:text>
        <xsl:apply-templates/>
        <xsl:text>&#xa;}&#xa;</xsl:text>
    </xsl:template>
    
    <xsl:template match="feature">
        <xsl:text>&#xa;// AUTO-GENERATED CODE: DO NOT EDIT&#xa;</xsl:text>
        <xsl:text>&#xa;    /**&#xa;    * </xsl:text>
        <xsl:text>&#xa;    * &lt;p&gt;Type of value: </xsl:text>
        <xsl:value-of select="type"/>
        <xsl:text>&lt;/p&gt;&#xa;    * </xsl:text>
        <xsl:apply-templates select="desc/node()" mode="javacomment"/>
        <xsl:apply-templates select="configfile|commandline"/>
        <xsl:apply-templates select="editions"/>
        <xsl:apply-templates select="getter|setter"/>
        <xsl:text>&#xa;    **/&#xa;</xsl:text>
        <xsl:text>&#xa;    public final static String </xsl:text>
        <xsl:value-of select="name"/>
        <xsl:text> = &#xa;        "</xsl:text>
        <xsl:value-of select="uri"/>
        <xsl:text>";&#xa;</xsl:text>
    </xsl:template>
    
    <xsl:template match="configfile">
        <xsl:text>&#xa;    * &lt;p&gt;&lt;i&gt;Corresponding attribute in configuration file: </xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>&lt;/i&gt;&lt;/p&gt;</xsl:text>
    </xsl:template>
    
    <xsl:template match="commandline">
        <xsl:text>&#xa;    * &lt;p&gt;&lt;i&gt;Corresponding option on command line (</xsl:text>
        <xsl:variable name="f" select="@for"/>
        <xsl:value-of select="'Transform'[contains($f, 'T')], 'Query'[contains($f, 'Q')], 'Validate'[contains($f, 'V')]"
            separator=", "/>
        <xsl:text>): </xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>&lt;/i&gt;&lt;/p&gt;</xsl:text>
    </xsl:template>
    
    <xsl:template match="editions">
        <xsl:text>&#xa;    * &lt;p&gt;&lt;i&gt;Applies to Saxon editions: </xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>&lt;/i&gt;&lt;/p&gt;</xsl:text>
    </xsl:template>
    
    <xsl:template match="*" mode="javacomment">
        <xsl:value-of select="concat('&lt;', local-name(), '&gt;')"/>
        <xsl:apply-templates mode="#current"/>
        <xsl:value-of select="concat('&lt;/', local-name(), '&gt;')"/>
    </xsl:template>
    
    <xsl:template match="text()" mode="javacomment">
        <xsl:for-each select="tokenize(., '\n')">
            <xsl:if test="position() != 1">
                <xsl:text>&#xa;    * </xsl:text>
            </xsl:if>
            <xsl:value-of select="translate(normalize-space(concat('€',.,'€')), '€', '')"/>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="link" mode="javacomment">
        <xsl:text>{@link </xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>}</xsl:text>
    </xsl:template>
    
    <xsl:template match="getter | setter">
        <xsl:text>&#xa;    * @see </xsl:text>
        <xsl:value-of select="concat(@class, '#', .)"/>
    </xsl:template>
    
    
</xsl:stylesheet>
