<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" version="2.0">
    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> Sep 25, 2010</xd:p>
            <xd:p><xd:b>Author:</xd:b> Michael Kay, Saxonica</xd:p>
            <xd:p>Generates FeatureKeysDoc.xml from FeatureKeys.xml</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xsl:output method="xml"/>
    
    <xsl:template match="features">

        <xsl:comment> GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE&#xa;&#xa;</xsl:comment>
        <table>
            <tr>
                <td>Name and URI</td>
                <td>Description</td>
                <td>Command line option</td>
            </tr>
        <xsl:apply-templates/>
        </table>
    </xsl:template>
    
    <xsl:template match="feature">
        <tr>
            <td><p><xsl:value-of select="name"/></p>
                <p><xsl:value-of select="uri"/></p>
            </td>
            <td>
                <xsl:copy-of select="desc/node()"/>
            </td>
            <td>
                <p><xsl:value-of select="commandline"/></p>
            </td>
        </tr>
    </xsl:template>
    

    
    
</xsl:stylesheet>
