<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cat="http://www.saxonica.com/ns/doc/catalog">

<xsl:key name="section" match="html" use="@section"/>
<xsl:key name="page" match="page" use="h2/@id"/>
<xsl:key name="subpage" match="subpage" use="@id"/>


<xsl:variable name="docs">
  <xsl:for-each select="//cat:section/@ref">
    <xsl:copy-of select="document(concat(., '.xml'))/*"/>
  </xsl:for-each>
</xsl:variable>

<xsl:template match="/">
  <xsl:apply-templates select="$docs//xref"/>
</xsl:template> 

<xsl:template match="xref[not(@section='functions']">
  <xsl:variable name="section" select="(@section, ancestor::html/@section)[1]"/>
  <xsl:variable name="target-doc" select="key('section', $section)"/>
  <xsl:if test="not($target-doc)">
    <xsl:call-template name="bad-link"/>
  </xsl:if>
  <xsl:if test="@page or @subpage">
    <xsl:variable name="page" select="(@page, ancestor::page/h2/@id)[1]"/>
    <xsl:variable name="target-page" select="key('page', $page, $target-doc)"/>
    <xsl:if test="not($target-page)">
      <xsl:call-template name="bad-link"/>
    </xsl:if>
    <xsl:if test="@subpage">
      <xsl:variable name="target-subpage" select="key('subpage', @subpage, $target-page)"/>
      <xsl:if test="not($target-subpage)">
        <xsl:call-template name="bad-link"/>
      </xsl:if>    
    </xsl:if>
  </xsl:if>      
</xsl:template>  

<xsl:template name="bad-link" xmlns:saxon="http://saxon.sf.net/">
  <xsl:message>BAD LINK: <xsl:copy-of select="."/> at <xsl:value-of select="ancestor::html/@section,
   ' page ', ancestor::page/h2/@id, ' line ', saxon:line-number()"/></xsl:message>
</xsl:template>   


</xsl:stylesheet>