/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.ant;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.sahi.ant.CreateIssue;
import net.sf.sahi.ant.Report;
import net.sf.sahi.test.TestRunner;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RunSahiTask
extends Task {
    protected String suite;
    protected String browser;
    protected String baseURL;
    protected String sahiHost;
    protected String sahiPort;
    protected String failureProperty;
    protected String haltOnFailure;
    protected String stop;
    protected String threads = "1";
    private String browserOption;
    private String browserProcessName;
    private CreateIssue createIssue;
    private List<Report> listReport = new ArrayList<Report>();
    private String browserType;
    private String singleSession;

    public void setBrowserOption(String browserOption) {
        this.browserOption = browserOption;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public void setSuite(String suite) {
        this.suite = suite;
    }

    public void setSahiPort(String port) {
        this.sahiPort = port;
    }

    public void setSahiHost(String sahiHost) {
        this.sahiHost = sahiHost;
    }

    public void setBrowserType(String browserType) {
        this.browserType = browserType;
    }

    public String getBrowserType() {
        return this.browserType;
    }

    public void setSingleSession(String singleSession) {
        this.singleSession = singleSession;
    }

    public String getSingleSession() {
        return this.singleSession;
    }

    public void execute() throws BuildException {
        if (this.stop != null) {
            this.stopServer();
            return;
        }
        this.startServer();
    }

    private void stopServer() {
        try {
            URL url = new URL("http://" + this.sahiHost + ":" + this.sahiPort + "/_s_/dyn/stopserver");
            InputStream s = url.openStream();
            s.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void startServer() {
        String status = "FAILURE";
        try {
            TestRunner testRunner = this.browserType != null ? new TestRunner(this.suite, this.browserType, this.baseURL, this.sahiHost, this.sahiPort, this.threads, this.listReport, this.createIssue) : new TestRunner(this.suite, this.browser, this.baseURL, this.sahiHost, this.sahiPort, this.threads, this.browserOption, this.browserProcessName, this.listReport, this.createIssue);
            testRunner.setIsSingleSession("true".equals(this.singleSession));
            status = testRunner.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("STATUS:" + status);
        if (!"SUCCESS".equals(status)) {
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, "true");
            }
            if ("true".equalsIgnoreCase(this.haltOnFailure)) {
                throw new BuildException(status);
            }
        }
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void setHaltOnFailure(String haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public void setStop(String stop) {
        this.stop = stop;
    }

    public void setThreads(String threads) {
        this.threads = threads;
    }

    public void addConfiguredCreateIssue(CreateIssue createIssue) {
        System.out.println("Setting createIssue");
        if (!"jira".equalsIgnoreCase(createIssue.getTool())) {
            throw new BuildException("tool attribute is mandatory and must be 'jira'");
        }
        this.createIssue = createIssue;
    }

    public void addConfiguredReport(Report report) {
        if (!"junit".equalsIgnoreCase(report.getType()) && !"html".equalsIgnoreCase(report.getType())) {
            throw new BuildException("Valid valued for attribute 'type' of tag 'reporter' are html or junit");
        }
        this.listReport.add(report);
    }

    public void setBrowserProcessName(String browserProcessName) {
        this.browserProcessName = browserProcessName;
    }
}

