/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.sahi.util.FileIsDirectoryException;
import net.sf.sahi.util.FileNotFoundRuntimeException;
import net.sf.sahi.util.RunnableWithResult;
import net.sf.sahi.util.StreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final SimpleDateFormat COMMON_DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
    static Map<String, Object> fileCache = new HashMap<String, Object>();
    public static int BUFFER_SIZE = 8192;

    public static String escapeDoubleQuotesAndBackSlashes(String line) {
        if (line == null) {
            return null;
        }
        return line.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        return Utils.getBytes(in, -1);
    }

    public static byte[] getBytes(InputStream in, int contentLength) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in, BUFFER_SIZE);
        if (contentLength != -1) {
            int bytesRead;
            byte[] buffer = new byte[contentLength];
            for (int totalBytesRead = 0; totalBytesRead < contentLength; totalBytesRead += bytesRead) {
                bytesRead = -1;
                try {
                    bytesRead = bin.read(buffer, totalBytesRead, contentLength - totalBytesRead);
                }
                catch (EOFException e) {
                    // empty catch block
                }
                if (bytesRead == -1) break;
            }
            return buffer;
        }
        ByteArrayOutputStream byteArOut = new ByteArrayOutputStream();
        BufferedOutputStream bout = new BufferedOutputStream(byteArOut);
        try {
            int totalBytesRead = 0;
            byte[] buffer = new byte[BUFFER_SIZE];
            while (true) {
                int bytesRead = -1;
                try {
                    bytesRead = bin.read(buffer);
                }
                catch (EOFException e) {
                    // empty catch block
                }
                if (bytesRead != -1) {
                    bout.write(buffer, 0, bytesRead);
                    totalBytesRead += bytesRead;
                    continue;
                }
                break;
            }
        }
        catch (SocketTimeoutException ste) {
            ste.printStackTrace();
        }
        bout.flush();
        bout.close();
        return byteArOut.toByteArray();
    }

    public static byte[] readURL(String url) {
        return Utils.readURL(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readURLThrowException(String url) throws MalformedURLException, IOException {
        byte[] data = null;
        InputStream inputStream = null;
        try {
            inputStream = new URL(url).openStream();
            data = Utils.getBytes(inputStream, -1);
            inputStream.close();
        }
        finally {
            inputStream.close();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readURL(String url, boolean printExceptions) {
        byte[] data = null;
        InputStream inputStream = null;
        try {
            inputStream = new URL(url).openStream();
            data = Utils.getBytes(inputStream, -1);
            inputStream.close();
        }
        catch (Exception e) {
            if (printExceptions) {
                e.printStackTrace();
            }
        }
        finally {
            block13: {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    if (!printExceptions) break block13;
                    e.printStackTrace();
                }
            }
        }
        return data;
    }

    public static byte[] readCachedFile(File file) {
        return Utils.readCachedFile(file.getAbsolutePath());
    }

    public static byte[] readCachedFileIfExists(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return Utils.readCachedFile(fileName);
        }
        return new byte[0];
    }

    public static byte[] readCachedFile(String fileName) {
        if (!fileCache.containsKey(fileName)) {
            fileCache.put(fileName, Utils.readFile(fileName));
        }
        return (byte[])fileCache.get(fileName);
    }

    public static byte[] readFile(String fileName) {
        File file = new File(fileName);
        return Utils.readFile(file);
    }

    public static String getString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public static byte[] readFile(File file) {
        if (file != null && file.isDirectory()) {
            throw new FileIsDirectoryException();
        }
        byte[] data = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            data = Utils.getBytes(inputStream, -1);
        }
        catch (IOException e) {
            throw new FileNotFoundRuntimeException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public static void writeFile(String str, String filePath, boolean overWrite) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                Utils.createNewFile(file);
            }
            FileOutputStream out = new FileOutputStream(file, !overWrite);
            out.write(str.getBytes());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("File:" + filePath + " xx " + filePath.replace('\\', '/'));
            System.out.println(str);
        }
    }

    public static void createNewFile(String file) throws IOException {
        Utils.createNewFile(new File(file));
    }

    public static void createNewFile(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static String readFileAsString(File file) {
        return Utils.getString(Utils.readFile(file));
    }

    public static String readFileAsString(String fileName) {
        return Utils.getString(Utils.readFile(fileName));
    }

    public static String convertStringToASCII(String s) {
        return s.replaceAll("(\u00e8|\u00e9|\u00ea|\u00eb)", "e").replaceAll("(\u00f9|\u00fa|\u00fb|\u00fc)", "u").replaceAll("(\u00e0|\u00e1|\u00e2|\u00e3|\u00e4|\u00e5)", "a").replaceAll("\u00e6", "ae").replaceAll("(\u00ec|\u00ed|\u00ee|\u00ef)", "i").replaceAll("(\u00f2|\u00f3|\u00f4|\u00f5|\u00f6|\u00f8)", "o").replaceAll("(\u00fd|\u00ff)", "y").replaceAll("\u00f1", "n").replaceAll("\u00e7", "c").replaceAll("(\u00c0|\u00c1|\u00c2|\u00c3|\u00c4|\u00c5)", "A").replaceAll("\u00c6", "AE").replaceAll("\u00c7", "C").replaceAll("(\u00c8|\u00c9|\u00ca|\u00cb)", "E").replaceAll("(\u00cc|\u00cd|\u00ce|\u00cf)", "I").replaceAll("\u00d1", "N").replaceAll("(\u00d2|\u00d3|\u00d4|\u00d5|\u00d6|\u00d8)", "O").replaceAll("(\u00d9|\u00da|\u00db|\u00dc)", "U").replaceAll("\u00dd", "Y");
    }

    public static synchronized String createLogFileName(String scriptFileName) {
        String TMPscriptFileName = new File(scriptFileName).getName();
        String date = Utils.getFormattedDateForFile(new Date());
        return Utils.convertStringToASCII(TMPscriptFileName.replaceAll("[.].*$", "") + "__" + date);
    }

    static String getFormattedDateForFile(Date date) {
        return new SimpleDateFormat("ddMMMyyyy__HH_mm_ss").format(date);
    }

    public static Date getDateFromFileName(String fileName) {
        int start = fileName.lastIndexOf("__");
        int length = fileName.length();
        if (start != -1) {
            start = fileName.lastIndexOf("__", start - 1);
        }
        int end = fileName.lastIndexOf(".");
        int n = start = start == -1 ? 0 : start + 2;
        if (end == -1) {
            end = length;
        }
        String dateString = fileName.substring(start, end);
        try {
            return new SimpleDateFormat("ddMMMyyyy__HH_mm_ss").parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static File getRelativeFile(File parent, String s2) {
        File sf2 = new File(s2);
        if (sf2.isAbsolute()) {
            return sf2;
        }
        if (!parent.isDirectory()) {
            parent = parent.getParentFile();
        }
        File file = new File(parent, s2);
        return file;
    }

    public static String concatPaths(String s1, String s2, String s3) {
        return Utils.concatPaths(Utils.concatPaths(s1, s2), s3);
    }

    public static String concatPaths(String s1, String s2) {
        return Utils.concatPaths(s1, s2, false);
    }

    public static String concatPaths(String s1, String s2, boolean returnRelative) {
        File sf2 = new File(s2);
        if (sf2.isAbsolute()) {
            return s2;
        }
        File parent = new File(s1);
        if (!parent.isDirectory()) {
            parent = parent.getParentFile();
        }
        File file = new File(parent, s2);
        return returnRelative ? file.getPath() : Utils.getAbsolutePath(file);
    }

    public static ArrayList<String> getTokens(String s) {
        String token;
        ArrayList<String> tokens = new ArrayList<String>();
        int ix1 = 0;
        int ix2 = -1;
        int len = s.length();
        while (ix1 < len && (ix2 = s.indexOf(10, ix1)) != -1) {
            token = s.substring(ix1, ix2 + 1);
            tokens.add(token);
            ix1 = ix2 + 1;
        }
        if (ix2 == -1) {
            token = s.substring(ix1);
            tokens.add(token);
        }
        return tokens;
    }

    public static boolean isBlankOrNull(String s) {
        return s == null || "".equals(s);
    }

    public static String substitute(String content, Map substitutions) {
        StringBuffer patternBuf = new StringBuffer();
        int i = 0;
        for (String key : substitutions.keySet()) {
            patternBuf.append(i++ == 0 ? "" : "|").append("\\$").append(key);
        }
        Pattern pattern = Pattern.compile(patternBuf.toString());
        patternBuf = null;
        Matcher matcher = pattern.matcher(content);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(0).substring(1);
            String replaceStr = ((String)substitutions.get(key)).replace("\\", "\\\\").replaceAll("\\$", "SDLR");
            matcher.appendReplacement(buf, replaceStr);
        }
        matcher.appendTail(buf);
        return buf.toString().replaceAll("SDLR", "\\$");
    }

    public static String makeString(String s) {
        if (s == null) {
            return null;
        }
        return Utils.escapeDoubleQuotesAndBackSlashes(s).replaceAll("\n", "\\\\n").replaceAll("\r", "");
    }

    public static String escapeQuotesForXML(String input) {
        return input.replaceAll("\"", "&quot;");
    }

    public static String escapeQuotes(String input) {
        return input.replaceAll("\"", "\\\\\"");
    }

    public static String addChildSessionId(String sessionId) {
        return sessionId + "sahix" + Utils.getUUID() + "x";
    }

    public static String stripChildSessionId(String sessionId) {
        return sessionId.replaceFirst("sahix[^x]+x", "");
    }

    public static void deleteDir(File dir) {
        try {
            if (dir.exists()) {
                File[] files = dir.listFiles();
                int len = files.length;
                for (int i = 0; i < len; ++i) {
                    if (files[i].isDirectory()) {
                        Utils.deleteDir(files[i]);
                        continue;
                    }
                    files[i].delete();
                }
                dir.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String makePathOSIndependent(String path) {
        String separator = System.getProperty("file.separator");
        return path.replace(separator.charAt(0), '/');
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isWindowsNT() {
        return System.getProperty("os.name").equals("Windows NT");
    }

    public static boolean isWindows95() {
        return System.getProperty("os.name").equals("Windows 95");
    }

    public static String[] getCommandTokens(String commandString) {
        boolean escaped = false;
        ArrayList<String> tokens = new ArrayList<String>();
        int length = commandString.length();
        int startIx = 0;
        int endIx = length;
        int NONE = 120;
        int startChar = 120;
        for (int i = 0; i < length; ++i) {
            int c = commandString.charAt(i);
            if (c == 92) {
                boolean bl = escaped = !escaped;
            }
            if (!escaped) {
                if (c == 32 && startChar == 120) {
                    endIx = i;
                    if (startIx != endIx) {
                        tokens.add(commandString.substring(startIx, endIx + 1).trim());
                    }
                    startChar = 120;
                    startIx = i + 1;
                }
                if (c == 34 || c == 39) {
                    if (startChar == 120) {
                        startChar = c;
                        startIx = i;
                    } else if (c == startChar) {
                        endIx = i;
                        tokens.add(commandString.substring(startIx + 1, endIx).trim());
                        startChar = 120;
                        startIx = i + 1;
                    }
                }
            }
            if (c == 92) continue;
            escaped = false;
        }
        if (startIx < length) {
            tokens.add(commandString.substring(startIx, length).trim());
        }
        return tokens.toArray(new String[0]);
    }

    public static String getStackTraceString(Exception e) {
        return Utils.getStackTraceString(e, false);
    }

    public static String getStackTraceString(Exception e, boolean forHTML) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        PrintStream s = new PrintStream(b);
        e.printStackTrace(s);
        String str = b.toString();
        if (forHTML) {
            str = str.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\\r", "").replaceAll("\\\n", "<br/>");
        }
        return str;
    }

    public static String getAbsolutePath(String fileStr) {
        return Utils.getAbsolutePath(new File(fileStr));
    }

    public static String getAbsolutePath(File file) {
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace('-', '0');
    }

    public static String generateId() {
        return "sahi_" + Utils.getUUID();
    }

    public static String toJSON(String[] list) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < list.length; ++i) {
            sb.append("\"");
            sb.append(Utils.makeString(list[i]));
            sb.append("\"");
            if (i == list.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String executeCommand(String command, boolean isSync, long timeout) throws Exception {
        RunnableWithResult runnable = new RunnableWithResult(command);
        Thread thread = new Thread(runnable);
        thread.start();
        if (isSync) {
            thread.join(timeout);
        }
        return runnable.getResult();
    }

    public static String executeCommand(String[] command) throws Exception {
        StringBuffer sb = new StringBuffer();
        Process p = Runtime.getRuntime().exec(command);
        InputStream stdInput = p.getInputStream();
        InputStream stdError = p.getErrorStream();
        StringBuffer inBuffer = new StringBuffer();
        StringBuffer errBuffer = new StringBuffer();
        Thread inThread = new Thread(new StreamReader(stdInput, inBuffer));
        inThread.start();
        Thread errThread = new Thread(new StreamReader(stdError, errBuffer));
        errThread.start();
        p.waitFor();
        inThread.join();
        errThread.join();
        sb.append(inBuffer);
        sb.append(errBuffer);
        return sb.toString();
    }

    public static Process executeAndGetProcess(String[] command) throws Exception {
        Process p = Runtime.getRuntime().exec(command);
        InputStream stdInput = p.getInputStream();
        InputStream stdError = p.getErrorStream();
        StringBuffer inBuffer = new StringBuffer();
        StringBuffer errBuffer = new StringBuffer();
        Thread inThread = new Thread(new StreamReader(stdInput, inBuffer));
        inThread.start();
        Thread errThread = new Thread(new StreamReader(stdError, errBuffer));
        errThread.start();
        return p;
    }

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return s;
        }
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String escapeForXML(String message) {
        if (message == null) {
            return null;
        }
        return message.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&#039;");
    }

    public static byte[] getBytes(String dataStr) {
        try {
            return dataStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return dataStr.getBytes();
        }
    }

    public static boolean isSahiTestFile(String testName) {
        return testName.endsWith(".sah") || testName.endsWith(".sahi");
    }

    public static HashMap<String, String> parseCLInput(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].indexOf("-") != 0 || i + 1 >= args.length) continue;
            String key = args[i].substring(1);
            String value = args[i + 1];
            System.out.println(key + "=" + value);
            map.put(key, value);
            ++i;
        }
        return map;
    }

    public static String expandSystemProperties(String cmd) {
        return Utils.substitute(cmd, System.getenv());
    }

    public static String getOSFamily() {
        String osName = "" + System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return System.getenv("PROGRAMFILES(X86)") != null ? "win64" : "win32";
        }
        if (osName.contains("mac")) {
            return "mac";
        }
        return "linux";
    }

    public static String replaceLocalhostWithMachineName(String url) {
        String computername;
        try {
            computername = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return url;
        }
        return url.replace("localhost", computername);
    }
}

