/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.stream.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.sahi.stream.filter.StreamFilter;
import net.sf.sahi.util.Utils;

public class StreamFilterInputStream
extends FilterInputStream {
    private StreamFilter filter;
    private byte[] data = null;
    private int idx = 0;
    private boolean endOfStream = false;

    public StreamFilterInputStream(InputStream in, StreamFilter filter) {
        super(in);
        this.filter = filter;
    }

    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.readBlock();
        if (this.data != null) {
            int availableLength = this.data.length - this.idx;
            if (availableLength <= len) {
                System.arraycopy(this.data, this.idx, b, off, availableLength);
                this.data = null;
                return availableLength;
            }
            System.arraycopy(this.data, this.idx, b, off, len);
            this.idx += len;
            return len;
        }
        return -1;
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void readBlock() throws IOException {
        if (this.data == null && !this.endOfStream) {
            byte[] buffer = new byte[Utils.BUFFER_SIZE];
            int bytesRead = this.in.read(buffer);
            if (bytesRead > 0) {
                byte[] trimmedBuffer = new byte[bytesRead];
                System.arraycopy(buffer, 0, trimmedBuffer, 0, bytesRead);
                this.data = this.filter.modify(trimmedBuffer);
                this.idx = 0;
            } else if (bytesRead == 0) {
                this.readBlock();
            } else {
                this.data = this.filter.getRemaining();
                this.idx = 0;
                this.endOfStream = true;
            }
        }
    }
}

