/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.stream.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.sahi.util.Utils;

public class ReadWriteThread
implements Runnable {
    private InputStream in;
    private OutputStream out;
    private int contentLength;
    private boolean closeOut = false;
    private final String name;

    public ReadWriteThread(InputStream in, OutputStream out, String name) {
        this(in, out, -1, false, name);
    }

    public ReadWriteThread(InputStream in, OutputStream out, int contentLength, boolean closeOut, String name) {
        this.in = in;
        this.out = out;
        this.contentLength = contentLength;
        this.closeOut = closeOut;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int SIZE = Utils.BUFFER_SIZE;
        byte[] buffer = new byte[SIZE];
        int totalBytesRead = 0;
        int bytesRead = -1;
        try {
            if (this.contentLength == 0) {
                this.out.flush();
                if (this.closeOut) {
                    this.out.close();
                }
                return;
            }
            do {
                bytesRead = -1;
                if (this.contentLength != -1) {
                    int limit = this.contentLength - totalBytesRead;
                    if (limit > SIZE) {
                        limit = SIZE;
                    }
                    try {
                        bytesRead = this.in.read(buffer, 0, limit);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.out.close();
                        System.out.println("Closing and returning");
                        try {
                            if (this.closeOut) {
                                this.out.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        return;
                    }
                }
                try {
                    bytesRead = this.in.read(buffer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (bytesRead == -1) {
                    break;
                }
                totalBytesRead += bytesRead;
                if (bytesRead != 0) {
                    this.out.write(buffer, 0, bytesRead);
                }
                this.out.flush();
            } while (totalBytesRead != this.contentLength);
        }
        catch (IOException e) {
            try {
                this.in.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        finally {
            try {
                if (this.closeOut) {
                    this.out.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

