/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.stream.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.stream.filter.StreamFilter;

public class CharacterFilter
extends StreamFilter {
    private CharsetDecoder decoder;
    private byte[] leftOver = null;

    public CharacterFilter(String charset) {
        this.decoder = Charset.forName(charset).newDecoder();
    }

    public byte[] modify(byte[] data) throws IOException {
        byte[] fullData = this.concatArrays(this.leftOver, data);
        try {
            this.decoder.decode(ByteBuffer.wrap(fullData)).toString();
            this.leftOver = null;
            return fullData;
        }
        catch (CharacterCodingException e1) {
            this.leftOver = fullData;
            return new byte[0];
        }
    }

    public byte[] getRemaining() {
        return this.leftOver;
    }

    public void modifyHeaders(HttpResponse response) throws IOException {
    }

    private byte[] concatArrays(byte[] leftOver, byte[] data) {
        if (leftOver == null) {
            return data;
        }
        byte[] added = new byte[leftOver.length + data.length];
        System.arraycopy(leftOver, 0, added, 0, leftOver.length);
        System.arraycopy(data, 0, added, leftOver.length, data.length);
        return added;
    }
}

