/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.response;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.NoCacheFilter;
import net.sf.sahi.response.StreamingHttpResponse;
import net.sf.sahi.stream.filter.CharacterFilter;
import net.sf.sahi.stream.filter.HTMLModifierFilter;
import net.sf.sahi.stream.filter.JSModifierFilter;
import net.sf.sahi.util.Utils;

public class HttpModifiedResponse
extends StreamingHttpResponse {
    boolean isSSL = false;
    private String fileExtension;
    private String charset;
    private byte[] sampleBytes;

    public HttpModifiedResponse(StreamingHttpResponse response, boolean isSSL, String fileExtension, int responseCode) {
        this.fileExtension = fileExtension;
        this.copyFrom(response);
        this.isSSL = isSSL;
        if (responseCode < 300 || responseCode >= 400) {
            boolean html = this.isHTML();
            this.charset();
            if (html) {
                if (Configuration.addCharacterFilter()) {
                    this.addFilter(new CharacterFilter(this.charset));
                }
                if (Configuration.addJSModifierFilter()) {
                    this.addFilter(new JSModifierFilter(this.charset));
                }
                if (Configuration.addHTMLModifierFilter()) {
                    this.addFilter(new HTMLModifierFilter(this.charset, this.isXHTML(), isSSL));
                }
                this.addFilter(new NoCacheFilter());
            } else if (this.isJs()) {
                if (Configuration.addCharacterFilter()) {
                    this.addFilter(new CharacterFilter(this.charset));
                }
                if (Configuration.addJSModifierFilter()) {
                    this.addFilter(new JSModifierFilter(this.charset));
                }
            }
        }
    }

    public HttpModifiedResponse(HttpResponse response, boolean isSSL, String fileExtension, int responseCode) {
        this(new StreamingHttpResponse(response), isSSL, fileExtension, responseCode);
    }

    public HttpModifiedResponse(HttpResponse response, boolean isSSL, String fileExtension) {
        this(response, isSSL, fileExtension, 200);
    }

    private boolean isJs() {
        String contentType = this.contentTypeHeader();
        if (contentType != null && contentType.toLowerCase().indexOf("javascript") != -1) {
            return true;
        }
        return "js".equalsIgnoreCase(this.fileExtension) || "js.dsp".equalsIgnoreCase(this.fileExtension);
    }

    private boolean isXHTML() {
        String s = this.getSampleContent();
        return s.indexOf("<?xml") != -1 || s.indexOf("<!doctype") != -1;
    }

    private boolean isHTML() {
        if (this.isJs()) {
            return false;
        }
        String contentType = this.contentTypeHeader();
        if (contentType != null && contentType.toLowerCase().indexOf("text/html") != -1) {
            return true;
        }
        if (contentType == null || contentType.toLowerCase().indexOf("text/plain") != -1 || contentType.toLowerCase().indexOf("text/xml") != -1) {
            return this.hasHtmlContent();
        }
        return false;
    }

    private boolean hasHtmlContent() {
        String s = this.getSampleContent();
        return s.indexOf("<html") != -1 || s.indexOf("<body") != -1 || s.indexOf("<table") != -1 || s.indexOf("<script") != -1 || s.indexOf("<form") != -1;
    }

    public String charset() {
        if (this.charset == null) {
            String charsetEqTo;
            int ix;
            this.charset = "iso-8859-1";
            String lookIn = this.contentTypeHeader();
            if (lookIn == null) {
                lookIn = this.getSampleContent("iso-8859-1");
            }
            if ((ix = lookIn.indexOf(charsetEqTo = "charset=")) != -1) {
                int endIx = lookIn.indexOf(34, ix);
                if (endIx == -1) {
                    endIx = lookIn.length();
                }
                this.charset = lookIn.substring(ix + charsetEqTo.length(), endIx).trim();
            }
            if (this.charset.endsWith(";")) {
                this.charset = this.charset.substring(0, this.charset.length() - 1);
            }
            try {
                new String(new byte[0], this.charset);
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Defaulting to charset iso-8859-1");
                this.charset = "iso-8859-1";
            }
        }
        return this.charset;
    }

    String getSampleContent() {
        return this.getSampleContent(this.charset());
    }

    byte[] sampleBytes() {
        if (this.sampleBytes == null) {
            int length = Configuration.sampleLength();
            try {
                this.in.mark(2000);
                this.sampleBytes = Utils.getBytes(this.in, length);
                this.in.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("If you get 'java.io.IOException: Resetting to invalid mark' errors,");
                System.out.println("change response.sample_length in sahi.properties to a nearby value (450), restart Sahi and check.");
                try {
                    this.in.reset();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        if (this.sampleBytes == null) {
            this.sampleBytes = new byte[0];
        }
        return this.sampleBytes;
    }

    String getSampleContent(String charset) {
        String sampleContent = null;
        try {
            sampleContent = new String(this.sampleBytes(), charset).toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sampleContent;
    }
}

