/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.request;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import net.sf.sahi.StreamHandler;

public class MultiPartSubRequest
extends StreamHandler {
    private String name;
    private String fileName;

    public MultiPartSubRequest() {
    }

    public MultiPartSubRequest(InputStream in) throws IOException {
        this.populateHeaders(in, false);
        this.populateData(in);
        this.setNameAndFileName(this.getLastSetValueOfHeader("Content-Disposition"));
        this.removeHeader("Content-Length");
    }

    void setNameAndFileName(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, ";");
        tokenizer.nextToken();
        this.name = MultiPartSubRequest.getValue(tokenizer.nextToken());
        if (tokenizer.hasMoreTokens()) {
            this.fileName = MultiPartSubRequest.getValue(tokenizer.nextToken());
        }
    }

    static String getValue(String s) {
        return s.substring(s.indexOf("\"") + 1, s.lastIndexOf("\""));
    }

    public String name() {
        return this.name;
    }

    public String fileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.setHeader("Content-Disposition", "form-data; name=\"" + this.name + "\"; filename=\"" + this.fileName + "\"");
        this.resetRawHeaders();
    }
}

