/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.report;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.sahi.report.LastModifiedComparator;
import net.sf.sahi.util.Utils;

public class LogViewer {
    public static String getLogsList2(String logsRootDir) {
        File[] fileList = new File(logsRootDir).listFiles();
        int length = fileList.length;
        HashMap<Long, File> map = new HashMap<Long, File>(length);
        Object[] times = new Long[length];
        for (int i = 0; i < length; ++i) {
            File file = fileList[i];
            Long modifiedTime = new Long(file.lastModified());
            map.put(modifiedTime, file);
            times[i] = modifiedTime;
        }
        Arrays.sort(times);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            File file = (File)map.get(times[i]);
            String fileName = file.getName();
            if (!fileName.endsWith(".htm") && !file.isDirectory()) continue;
            sb.append("<a href='/_s_/dyn/Log_viewLogs/");
            sb.append(LogViewer.getSummaryFile(file));
            sb.append("'>");
            sb.append(fileName);
            sb.append("</a><br>");
        }
        return sb.toString();
    }

    public static String getLogsList(String logsRootDir) {
        File[] fileList = new File(logsRootDir).listFiles();
        LastModifiedComparator comparator = new LastModifiedComparator();
        Arrays.sort(fileList, comparator);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fileList.length; ++i) {
            String fileName = fileList[i].getName();
            if (!fileName.endsWith(".htm") && !fileList[i].isDirectory()) continue;
            sb.append("<a href='/_s_/dyn/Log_viewLogs/");
            sb.append(LogViewer.getSummaryFile(fileList[i]));
            sb.append("'>");
            sb.append(fileName);
            sb.append("</a><br>");
        }
        return sb.toString();
    }

    private static String getSummaryFile(File file) {
        if (file.isDirectory()) {
            return file.getName() + "/index.htm";
        }
        return file.getName();
    }

    public static String highlight(String data, int lineNumber) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\" /></head><body><style>b{background:brown;color:white;}\nspan{background:lightgrey;}</style><pre>").append(LogViewer.highlightLine(data, lineNumber)).append("</pre></body></html>");
        return sb.toString();
    }

    public static String addLineNumbers(String orig, String scriptPath) {
        if ("".equals(orig = orig.replaceAll("\\r", ""))) {
            return orig;
        }
        String[] lines = orig.split("\n");
        StringBuffer sb2 = new StringBuffer();
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            String line = lines[i];
            if ("".equals(line.trim())) continue;
            sb2.append("<a style=\"text-decoration:none;color:inherit;\" href='/_s_/dyn/Log_highlight?href=" + Utils.escapeDoubleQuotesAndBackSlashes(scriptPath) + "&n=" + (i + 1) + "#selected'>" + line + "</a>\n");
        }
        return sb2.toString();
    }

    static String highlightLine(String data, int lineNumber) {
        data = data.replaceAll("\\r", "");
        String[] lines = data.split("\n");
        StringBuffer sb = new StringBuffer();
        int len = lines.length;
        StringBuffer tmpBuf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            tmpBuf.append(lines[i]);
            if (i + 1 == lineNumber) {
                tmpBuf.insert(0, "<a name='selected'><b>").append("</b></a>");
            }
            tmpBuf.insert(0, "</span> ");
            tmpBuf.insert(0, i + 1);
            tmpBuf.insert(0, "<span>");
            tmpBuf.append("\n");
            sb.append(tmpBuf.toString());
            tmpBuf.setLength(0);
        }
        return sb.toString();
    }
}

