/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.playback;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptUtil {
    public static String getScriptsJs(String scriptName) {
        Object[] fileList = ScriptUtil.getScriptFiles();
        Arrays.sort(fileList);
        return ScriptUtil.getJs((String[])fileList, scriptName, false);
    }

    public static String getScriptRootsJs(String dir) {
        String[] fileList = Configuration.getScriptRoots();
        return ScriptUtil.getJs(fileList, Utils.escapeDoubleQuotesAndBackSlashes(dir), true);
    }

    private static String getJs(String[] list, String selected, boolean isDir) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            String absolutePath = list[i];
            sb.append("addToScript").append(isDir ? "Dir" : "").append("List").append("('");
            sb.append(Utils.escapeDoubleQuotesAndBackSlashes(absolutePath));
            sb.append("');\n");
        }
        sb.append("setSelectedScript").append(isDir ? "Dir" : "").append("('").append(selected).append("')");
        sb.append("\n\n\n");
        return sb.toString();
    }

    private static String[] getScriptFiles() {
        ArrayList<String> allFiles = new ArrayList<String>();
        Configuration.createScriptsDirIfNeeded();
        String[] scriptRoots = Configuration.getScriptRoots();
        for (int i = 0; i < scriptRoots.length; ++i) {
            String scriptRoot = scriptRoots[i];
            File file = new File(scriptRoot);
            ScriptUtil.getFilesRecursively(file, allFiles);
        }
        return allFiles.toArray(new String[0]);
    }

    public static String[] getScriptFiles(String dir) {
        ArrayList<String> allFiles = new ArrayList<String>();
        File file = new File(dir);
        ScriptUtil.getFilesRecursively(file, allFiles);
        return allFiles.toArray(new String[0]);
    }

    private static List<String> getFilesRecursively(File dir, List<String> allFiles) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                ScriptUtil.getFilesRecursively(file, allFiles);
                continue;
            }
            if (!ScriptUtil.isAddable(file)) continue;
            allFiles.add(Utils.getAbsolutePath(file));
        }
        return allFiles;
    }

    private static boolean isAddable(File file) {
        String absolutePath = Utils.getAbsolutePath(file);
        String[] extensions = Configuration.getScriptExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            if (!absolutePath.endsWith(extensions[i])) continue;
            return true;
        }
        return false;
    }
}

