/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.issue;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.issue.Issue;
import net.sf.sahi.issue.IssueCreator;
import net.sf.sahi.util.FileNotFoundRuntimeException;
import net.sf.sahi.util.Utils;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class JiraIssueCreator
implements IssueCreator {
    private static Properties properties;
    private XmlRpcClient rpcClient;
    private String loginToken;
    private Map issueParams;

    public JiraIssueCreator(String propFile) {
        this.loadPropFile(propFile);
        this.initializeXmlRpcClient(new XmlRpcClient(), new XmlRpcClientConfigImpl());
    }

    void initializeXmlRpcClient(XmlRpcClient rpcClient, XmlRpcClientConfigImpl configImpl) {
        try {
            URL jiraRpcUrl = new URL(properties.getProperty("jira.url") + properties.getProperty("jira.rpc.path"));
            configImpl.setServerURL(jiraRpcUrl);
            this.rpcClient = rpcClient;
            rpcClient.setConfig((XmlRpcClientConfig)configImpl);
        }
        catch (Exception e) {
            throw new RuntimeException("Error connecting to CreateIssue", e);
        }
    }

    JiraIssueCreator(XmlRpcClient rpcClient) {
        this.rpcClient = rpcClient;
        this.loadPropFile(null);
    }

    void setIssueParams(Map issueParams) {
        this.issueParams = issueParams;
    }

    private void loadPropFile(String propFile) {
        if (Utils.isBlankOrNull(propFile)) {
            propFile = Configuration.getJiraPropertyPath();
        }
        properties = new Properties();
        try {
            properties.load(new FileInputStream(propFile));
        }
        catch (IOException e) {
            throw new FileNotFoundRuntimeException(e);
        }
    }

    public static void main(String[] args) {
        JiraIssueCreator issueCreator = new JiraIssueCreator("");
        try {
            issueCreator.createIssue(new Issue("Sahi Test", "blah"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createIssue(Issue issue) throws Exception {
        if (this.issueParams == null) {
            this.issueParams = this.getIssueParameters();
        }
        this.issueParams.put("summary", issue.getSummary());
        this.issueParams.put("description", issue.getDescription());
        this.rpcClient.execute("jira1.createIssue", new Object[]{this.getLoginToken(), this.issueParams});
    }

    Map getIssueParameters() {
        this.issueParams = new HashMap();
        try {
            String projectKey = new JiraItem("jira1.getProjects", null, properties.getProperty("jira.project")).get("key");
            this.issueParams.put("project", projectKey);
            this.issueParams.put("type", new JiraItem("jira1.getIssueTypes", null, properties.getProperty("jira.issueType")).get("id"));
            this.issueParams.put("priority", new JiraItem("jira1.getPriorities", null, properties.getProperty("jira.priority")).get("id"));
            this.issueParams.put("assignee", properties.getProperty("jira.assignee"));
            ArrayList<String> param = new ArrayList<String>();
            param.add(projectKey);
            this.issueParams.put("components", new JiraItem("jira1.getComponents", param, properties.getProperty("jira.component")).getMapInList("id"));
            if (!Utils.isBlankOrNull(properties.getProperty("jira.affectsVersions"))) {
                this.issueParams.put("affectsVersions", new JiraItem("jira1.getVersions", param, properties.getProperty("jira.affectsVersions")).getMapInList("id"));
            }
            if (!Utils.isBlankOrNull(properties.getProperty("jira.fixVersions"))) {
                this.issueParams.put("fixVersions", new JiraItem("jira1.getVersions", param, properties.getProperty("jira.fixVersions")).getMapInList("id"));
            }
        }
        catch (XmlRpcException e) {
            throw new RuntimeException(e);
        }
        return this.issueParams;
    }

    public void logout() throws XmlRpcException {
        this.rpcClient.execute("jira1.logout", new Object[]{this.getLoginToken()});
    }

    public String getLoginToken() {
        if (this.loginToken == null) {
            this.login();
        }
        return this.loginToken;
    }

    public void login() {
        ArrayList<String> loginParams = new ArrayList<String>();
        loginParams.add(properties.getProperty("jira.username"));
        loginParams.add(properties.getProperty("jira.password"));
        try {
            this.loginToken = (String)this.rpcClient.execute("jira1.login", loginParams);
        }
        catch (Exception e) {
            throw new RuntimeException("Error logging in to Jira", e);
        }
    }

    private class JiraItem {
        private Map attributes;

        public JiraItem(String method, List params, String itemName) throws XmlRpcException {
            boolean found = false;
            ArrayList<String> toParams = new ArrayList<String>();
            toParams.add(JiraIssueCreator.this.getLoginToken());
            if (params != null) {
                toParams.addAll(params);
            }
            Object[] listResult = (Object[])JiraIssueCreator.this.rpcClient.execute(method, toParams);
            for (int i = 0; i < listResult.length; ++i) {
                Map map = (Map)listResult[i];
                if (!itemName.equals(map.get("name"))) continue;
                this.attributes = map;
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(itemName + " not found in results for method " + method);
            }
        }

        public String get(String attribute) {
            return (String)this.attributes.get(attribute);
        }

        public List getMapInList(String attribute) {
            ArrayList list = new ArrayList();
            HashMap map = new HashMap();
            map.put(attribute, this.attributes.get(attribute));
            list.add(map);
            return list;
        }
    }
}

