/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.io.IOException;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.issue.JiraIssueCreator;
import net.sf.sahi.report.HtmlReporter;
import net.sf.sahi.report.JunitReporter;
import net.sf.sahi.report.TM6Reporter;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.NoCacheHttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.session.Session;
import net.sf.sahi.session.Status;
import net.sf.sahi.test.SahiTestSuite;
import net.sf.sahi.util.BrowserType;
import net.sf.sahi.util.BrowserTypesLoader;

public class Suite {
    public void startSingleSession(HttpRequest request) throws Exception {
        SahiTestSuite suite = this.getSuite(request);
        suite.launchBrowserForSingleSession();
    }

    public SimpleHttpResponse executeTestInSingleSession(HttpRequest request) throws Exception {
        Session session = request.session();
        SahiTestSuite suite = session.getSuite();
        String initJS = request.getParameter("initJS");
        System.out.println("Setting initJS" + initJS);
        suite.setInitJS(initJS);
        Status status = suite.executeTestForSingleSession(request.getParameter("testName"), request.getParameter("startURL"));
        return new SimpleHttpResponse(status.getName());
    }

    public void stopSingleSession(HttpRequest request) {
        Session session = request.session();
        SahiTestSuite suite = session.getSuite();
        suite.killBrowserForSingleSession(true);
    }

    public void start(HttpRequest request) {
        SahiTestSuite suite = this.getSuite(request);
        suite.loadScripts();
        this.runSuite(suite);
    }

    public void startPreconfiguredBrowser(HttpRequest request) {
        SahiTestSuite suite = this.getPreconfiguredBrowserSuite(request);
        suite.loadScripts();
        this.runSuite(suite);
    }

    private SahiTestSuite getSuite(HttpRequest request) {
        if (request.getParameter("browserType") != null) {
            return this.getPreconfiguredBrowserSuite(request);
        }
        Session session = request.session();
        String suitePath = request.getParameter("suite");
        String base = request.getParameter("base");
        String browser = request.getParameter("browser");
        String browserOption = request.getParameter("browserOption");
        String browserProcessName = request.getParameter("browserProcessName");
        String threads = request.getParameter("threads");
        boolean isSingleSession = "true".equals(request.getParameter("useSingleSession"));
        boolean useSystemProxy = "true".equals(request.getParameter("useSystemProxy"));
        SahiTestSuite suite = this.prepareSuite(suitePath, base, browser, session.id(), browserOption, browserProcessName, threads, useSystemProxy, isSingleSession, request);
        return suite;
    }

    private SahiTestSuite getPreconfiguredBrowserSuite(HttpRequest request) {
        SahiTestSuite suite = null;
        BrowserTypesLoader browserLoader = new BrowserTypesLoader();
        BrowserType browserType = browserLoader.getBrowserType(request);
        Session session = request.session();
        String suitePath = request.getParameter("suite");
        String base = request.getParameter("base");
        boolean isSingleSession = "true".equals(request.getParameter("useSingleSession"));
        int threads = this.getThreads(request.getParameter("threads"), browserType.capacity());
        if (browserType != null) {
            suite = this.prepareSuite(suitePath, base, browserType.path(), session.id(), browserType.options(), browserType.processName(), "" + threads, browserType.useSystemProxy(), isSingleSession, request);
        }
        return suite;
    }

    private int getThreads(String threadsStr, int capacity) {
        int threads = 1;
        try {
            threads = Integer.parseInt(threadsStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        return threads < capacity ? threads : capacity;
    }

    private void runSuite(final SahiTestSuite suite) {
        new Thread(){

            public void run() {
                suite.run();
            }
        }.start();
    }

    private SahiTestSuite prepareSuite(String suitePath, String base, String browser, String sessionId, String browserOption, String browserProcessName, String threadCapacity, boolean useSystemProxy, boolean isSingleSession, HttpRequest request) {
        SahiTestSuite suite = new SahiTestSuite(Configuration.getAbsoluteUserPath(suitePath), base, browser, sessionId, browserOption, browserProcessName, isSingleSession);
        int threads = 1;
        try {
            threads = Integer.parseInt(threadCapacity);
        }
        catch (Exception e) {
            // empty catch block
        }
        suite.setAvailableThreads(threads);
        suite.setUseSystemProxy(useSystemProxy);
        try {
            Configuration.copyProfiles();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        suite.setExtraInfo(request.getParameter("extraInfo"));
        suite.setInitJS(request.getParameter("initJS"));
        this.setReporters(suite, request);
        this.setIssueCreators(suite, request);
        return suite;
    }

    private void setIssueCreators(SahiTestSuite suite, HttpRequest request) {
        String propFile = request.getParameter("jira");
        if (propFile != null) {
            suite.addIssueCreator(new JiraIssueCreator(propFile));
        }
    }

    public HttpResponse status(HttpRequest request) {
        Session session = request.session();
        Status status = session.getStatus();
        if (status == null) {
            status = Status.FAILURE;
        }
        return new NoCacheHttpResponse(status.getName());
    }

    private void setReporters(SahiTestSuite suite, HttpRequest request) {
        String defaultLogDir = Configuration.appendLogsRoot(suite.getLogFolderName());
        String logDir = request.getParameter("junit");
        if (logDir != null) {
            logDir = this.getLogDir(defaultLogDir, logDir);
            suite.setJunitLogDir(logDir);
            suite.addReporter(new JunitReporter(logDir));
        }
        if ((logDir = request.getParameter("html")) != null) {
            logDir = this.getLogDir(defaultLogDir, logDir);
            suite.setHtmlLogDir(logDir);
            suite.addReporter(new HtmlReporter(logDir));
        }
        if ((logDir = request.getParameter("tm6")) != null) {
            logDir = this.getLogDir(defaultLogDir, logDir);
            suite.setTM6LogDir(logDir);
            suite.addReporter(new TM6Reporter(logDir));
        }
    }

    private String getLogDir(String defaultLogDir, String logDir) {
        return logDir.equals("") ? defaultLogDir : Configuration.getAbsoluteUserPath(logDir);
    }

    public void kill(HttpRequest request) {
        Session session = request.session();
        SahiTestSuite suite = SahiTestSuite.getSuite(session.id());
        if (suite != null) {
            suite.kill();
        }
    }
}

