/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.client;

import java.util.Date;
import net.sf.sahi.client.BrowserCondition;
import net.sf.sahi.client.BrowserElements;
import net.sf.sahi.client.ElementStub;
import net.sf.sahi.client.ExecutionException;
import net.sf.sahi.client.QueryStringBuilder;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.test.ProcessHelper;
import net.sf.sahi.util.Utils;

public class Browser
extends BrowserElements {
    private String sessionId = null;
    private boolean opened = false;
    private String popupName;
    private String host = "localhost";
    private int port = 9999;
    private String domainName;
    private String browserName;
    private String browserPath;
    private String browserOption;
    private String browserProcessName;

    public Browser(String browserName) {
        this(browserName, "localhost", Configuration.getPort());
    }

    public Browser(String browserPath, String browserProcessName, String browserOption) {
        this(browserPath, browserProcessName, browserOption, "localhost", Configuration.getPort());
    }

    public Browser(String browserPath, String browserProcessName, String browserOption, String host, int port) {
        this.host = host;
        this.port = port;
        this.browserPath = browserPath;
        this.browserOption = browserOption;
        this.browserProcessName = browserProcessName;
        this.sessionId = Utils.generateId();
        this.browser = this;
    }

    public Browser(String browserName, String host, int port) {
        this.browserName = browserName;
        this.host = host;
        this.port = port;
        this.sessionId = Utils.generateId();
        this.browser = this;
    }

    public Browser() {
        this.browser = this;
    }

    private String getProxyURL(String command, QueryStringBuilder qs) {
        if (qs == null) {
            qs = new QueryStringBuilder();
        }
        qs.add("sahisid", this.sessionId);
        return "http://" + this.host + ":" + this.port + "/_s_/dyn/Driver_" + command + qs.toString();
    }

    public void restartPlayback() {
        String url = this.getProxyURL("restart", new QueryStringBuilder());
        Utils.readURL(url);
    }

    private String execCommand(String command) {
        return this.execCommand(command, null);
    }

    private String execCommand(String command, QueryStringBuilder qs) {
        return new String(Utils.readURL(this.getProxyURL(command, qs)));
    }

    public void navigateTo(String url) throws ExecutionException {
        this.navigateTo(url, false);
    }

    public void navigateTo(String url, boolean forceReload) throws ExecutionException {
        this.executeStep("_sahi._navigateTo(\"" + url + "\", " + forceReload + ")");
        this.fetch("_sahi.loaded");
    }

    public void execute(String step) throws ExecutionException {
        String prefix = "";
        if (this.isDomain()) {
            prefix = "_sahi._domain(\"" + this.domainName.replaceAll("\"", "\\\"") + "\").";
        }
        if (this.isPopup()) {
            prefix = prefix + "_sahi._popup(\"" + this.popupName.replaceAll("\"", "\\\"") + "\").";
        }
        step = prefix + step;
        this.executeStep(step);
    }

    private boolean isPopup() {
        return this.popupName != null;
    }

    private boolean isDomain() {
        return this.domainName != null;
    }

    public void executeStep(String step) throws ExecutionException {
        QueryStringBuilder qs = new QueryStringBuilder();
        qs.add("step", step);
        this.execCommand("setStep", qs);
        for (int i = 0; i < 4000; ++i) {
            try {
                Thread.sleep(Configuration.getTimeBetweenSteps());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String checkDone = this.execCommand("doneStep");
            boolean done = "true".equals(checkDone);
            boolean error = checkDone.startsWith("error:");
            if (!done) continue;
            return;
        }
    }

    public void open() {
        if (this.opened) {
            return;
        }
        this.openURL();
        int i = 0;
        while (i < 500) {
            ++i;
            String isReady = this.execCommand("isReady");
            if ("true".equals(isReady)) {
                this.opened = true;
                ProcessHelper.setProcessStarted();
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.opened = true;
    }

    private void openURL() {
        QueryStringBuilder qs = new QueryStringBuilder();
        if (this.browserName != null) {
            qs.add("browserType", this.browserName);
            qs.add("startUrl", "http://" + Configuration.getCommonDomain() + "/_s_/dyn/Driver_initialized");
            this.execCommand("launchPreconfiguredBrowser", qs);
        } else {
            qs.add("browser", this.browserPath);
            qs.add("browserOption", this.browserOption);
            qs.add("browserProcessName", this.browserProcessName);
            qs.add("startUrl", "http://" + Configuration.getCommonDomain() + "/_s_/dyn/Driver_initialized");
            this.execCommand("launchAndPlayback", qs);
        }
    }

    void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.isPopup()) {
            this.execute("_sahi._closeWindow()");
        } else {
            this.kill();
        }
    }

    public void kill() {
        this.execCommand("kill");
    }

    public void setValue(ElementStub textbox, String value) throws ExecutionException {
        this.execute("_sahi._setValue(" + textbox + ", " + this.quoted(value) + ")");
    }

    public void setFile(ElementStub textbox, String value) throws ExecutionException {
        this.execute("_sahi._setFile(" + textbox + ", " + this.quoted(value) + ")");
    }

    public void click(ElementStub element) throws ExecutionException {
        this.execute("_sahi._click(" + element + ")");
    }

    public void doubleClick(ElementStub element) throws ExecutionException {
        this.execute("_sahi._doubleClick(" + element + ")");
    }

    public void rightClick(ElementStub element) throws ExecutionException {
        this.execute("_sahi._rightClick(" + element + ")");
    }

    public void check(ElementStub element) throws ExecutionException {
        this.execute("_sahi._check(" + element + ")");
    }

    public void uncheck(ElementStub element) throws ExecutionException {
        this.execute("_sahi._uncheck(" + element + ")");
    }

    public void focus(ElementStub element) throws ExecutionException {
        this.execute("_sahi._focus(" + element + ")");
    }

    public void removeFocus(ElementStub element) throws ExecutionException {
        this.execute("_sahi._removeFocus(" + element + ")");
    }

    public void mouseOver(ElementStub element) throws ExecutionException {
        this.execute("_sahi._mouseOver(" + element + ")");
    }

    public void mouseDown(ElementStub element) throws ExecutionException {
        this.execute("_sahi._mouseDown(" + element + ")");
    }

    public void mouseUp(ElementStub element) throws ExecutionException {
        this.execute("_sahi._mouseUp(" + element + ")");
    }

    public void dragDrop(ElementStub dragElement, ElementStub dropElement) throws ExecutionException {
        this.execute("_sahi._dragDrop(" + dragElement + ", " + dropElement + ")");
    }

    public void dragDropXY(ElementStub dragElement, int x, int y) throws ExecutionException {
        this.execute("_sahi._dragDropXY(" + dragElement + ", " + x + "," + y + ")");
    }

    public String fetch(String expression) throws ExecutionException {
        Date d = new Date();
        String key = "___lastValue___" + d.toString();
        this.execute("_sahi.setServerVarPlain('" + key + "', " + expression + ")");
        return this.execCommand("getVariable", new QueryStringBuilder().add("key", key));
    }

    public String fetch(ElementStub el) throws ExecutionException {
        return this.fetch(el.toString());
    }

    public String getText(ElementStub el) throws ExecutionException {
        return this.fetch("_sahi._getText(" + el + ")");
    }

    public String getValue(ElementStub el) throws ExecutionException {
        return this.fetch(el + ".value");
    }

    public boolean exists(ElementStub el) {
        return this.exists(el, false);
    }

    public boolean exists(ElementStub el, boolean optimistic) {
        if (optimistic) {
            return this.exists1(el);
        }
        for (int i = 0; i < Configuration.getMaxReAttemptsOnError(); ++i) {
            if (!this.exists1(el)) continue;
            return true;
        }
        return false;
    }

    private boolean exists1(ElementStub el) {
        try {
            String fetched = this.fetch("_sahi._exists(" + el + ")");
            return "true".equals(fetched);
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public boolean isVisible(ElementStub el) throws ExecutionException {
        return this.isVisible(el, false);
    }

    private boolean isVisible1(ElementStub el) throws ExecutionException {
        return "true".equals(this.fetch("_sahi._isVisible(" + el + ")"));
    }

    public boolean isVisible(ElementStub el, boolean optimistic) throws ExecutionException {
        if (optimistic) {
            return this.isVisible1(el);
        }
        for (int i = 0; i < Configuration.getMaxReAttemptsOnError(); ++i) {
            if (!this.isVisible1(el)) continue;
            return true;
        }
        return false;
    }

    public String getSelectedText(ElementStub el) throws ExecutionException {
        return this.fetch("_sahi._getSelectedText(" + el + ")");
    }

    public Browser popup(String popupName) {
        return this.copy(popupName, this.domainName);
    }

    private Browser copy(String popupName, String domainName) {
        Browser newWin = new Browser();
        newWin.host = this.host;
        newWin.port = this.port;
        newWin.sessionId = this.sessionId;
        newWin.popupName = popupName;
        newWin.domainName = domainName;
        return newWin;
    }

    public Browser domain(String domainName) {
        return this.copy(this.popupName, domainName);
    }

    public void waitFor(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void waitFor(BrowserCondition condition, int timeout) {
        int interval = 500;
        for (int total = 0; total < timeout; total += interval) {
            this.waitFor(interval);
            try {
                if (!condition.test()) continue;
                return;
            }
            catch (ExecutionException e) {
                continue;
            }
        }
    }

    public void choose(ElementStub elementStub, String value, boolean append) throws ExecutionException {
        this.execute("_sahi._setSelected(" + elementStub + ", " + this.quoted(value) + ", " + append + ")");
    }

    public void choose(ElementStub elementStub, String[] values, boolean append) throws ExecutionException {
        this.execute("_sahi._setSelected(" + elementStub + ", " + Utils.toJSON(values) + ", " + append + ")");
    }

    public void startRecording() {
        this.execCommand("startRecording");
    }

    public void stopRecording() {
        this.execCommand("stopRecording");
    }

    public String[] getRecordedSteps() {
        return this.execCommand("getRecordedSteps").split("__xxSAHIDIVIDERxx__");
    }

    public String lastAlert() throws ExecutionException {
        return new ElementStub("lastAlert", this, new Object[0]).fetch();
    }

    public String lastConfirm() throws ExecutionException {
        return new ElementStub("lastConfirm", this, new Object[0]).fetch();
    }

    public void expectPrompt(String message, String input) throws ExecutionException {
        this.execute("_sahi._expectPrompt(" + this.quoted(message) + ", " + this.quoted(input) + ")");
    }

    public void expectConfirm(String message, boolean input) throws ExecutionException {
        this.execute("_sahi._expectConfirm(" + this.quoted(message) + ", " + input + ")");
    }

    public String lastPrompt() throws ExecutionException {
        return new ElementStub("lastPrompt", this, new Object[0]).fetch();
    }

    public void clearLastAlert() throws ExecutionException {
        this.execute("_sahi._clearLastAlert()");
    }

    public void clearLastPrompt() throws ExecutionException {
        this.execute("_sahi._clearLastPrompt()");
    }

    public void clearLastConfirm() throws ExecutionException {
        this.execute("_sahi._clearLastConfirm()");
    }

    public String title() throws ExecutionException {
        return this.fetch("_sahi._title()");
    }

    private String quoted(String s) {
        return "\"" + Utils.escapeDoubleQuotesAndBackSlashes(s).replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r") + "\"";
    }

    public boolean checked(ElementStub el) throws ExecutionException {
        return "true".equals(this.fetch(el + ".checked"));
    }

    public void addURLMock(String urlPattern) {
        this.execute("_sahi._addMock(" + this.quoted(urlPattern) + ")");
    }

    public void addURLMock(String urlPattern, String responseClass_method) {
        this.execute("_sahi._addMock(" + this.quoted(urlPattern) + ", " + this.quoted(responseClass_method) + ")");
    }

    public void removeURLMock(String urlPattern) {
        this.execute("_sahi._removeMock(" + this.quoted(urlPattern) + ")");
    }

    public String lastDownloadedFileName() {
        return new ElementStub("lastDownloadedFileName", this, new Object[0]).fetch();
    }

    public void clearLastDownloadedFileName() {
        this.execute("_sahi._clearLastDownloadedFileName()");
    }

    public void saveDownloadedAs(String newFilePath) {
        this.execute("_sahi._saveDownloadedAs(" + this.quoted(newFilePath) + ")");
    }

    public void setSpeed(int interval) {
        this.execCommand("setSpeed", new QueryStringBuilder().add("speed", "" + interval));
    }

    public void setStrictVisibilityCheck(boolean check) {
        this.execute("_sahi._setStrictVisibilityCheck(" + check + ")");
    }

    public boolean containsText(ElementStub el, String text) {
        return "true".equals(this.fetch("_sahi._containsText(" + el + ", " + this.quoted(text) + ")"));
    }

    public boolean containsHTML(ElementStub el, String html) {
        return "true".equals(this.fetch("_sahi._containsHTML(" + el + ", " + this.quoted(html) + ")"));
    }

    public String style(ElementStub el, String attribute) {
        return this.fetch("_sahi._style(" + el + ", " + this.quoted(attribute) + ")");
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public void rteWrite(ElementStub rte, String value) {
        this.execute("_sahi._rteWrite(" + rte + ", " + this.quoted(value) + ")");
    }

    public void setBrowserJS(String browserJS) {
        QueryStringBuilder qs = new QueryStringBuilder();
        qs.add("browserJS", browserJS);
        this.execCommand("setBrowserJS", qs);
    }

    public boolean isChrome() {
        return "true".equals(this.fetch("_sahi._isChrome()"));
    }

    public boolean isFirefox() {
        return "true".equals(this.fetch("_sahi._isFF()"));
    }

    public boolean isFF() {
        return "true".equals(this.fetch("_sahi._isFF()"));
    }

    public boolean isIE() {
        return "true".equals(this.fetch("_sahi._isIE()"));
    }

    public boolean isSafari() {
        return "true".equals(this.fetch("_sahi._isSafari()"));
    }

    public boolean isOpera() {
        return "true".equals(this.fetch("_sahi._isOpera()"));
    }

    public int count(Object ... args) {
        String countStr = new ElementStub("count", this, args).fetch();
        return Integer.parseInt(countStr);
    }

    public void keyDown(ElementStub element, int keyCode, int charCode) {
        this.execute("_sahi._keyDown(" + element + ", [" + keyCode + ", " + charCode + "])");
    }

    public void keyUp(ElementStub element, int keyCode, int charCode) {
        this.execute("_sahi._keyUp(" + element + ", [" + keyCode + ", " + charCode + "])");
    }
}

