
/*
 *	Interface for Ruby to the functions of CAST_256.CPP.
 *  Copyright (c) 1999 by Michael Neumann.
 *  for Windows (Visual C++)
 *  23.05.1999
 */


#include "cast_256.hpp"
#include "ruby.h"



struct dsubkeys
{
	subkeys a[2];

	~dsubkeys() {zero();}
	void zero()
	{
		a[0].zero();
		a[1].zero();
	}
};



extern "C" VALUE set_key(VALUE obj, VALUE key)
{
	// parameter:	key		: string[32]
	// returns:		block	: string with subkeys[2]

	bitblock_256 k,k2;
	dsubkeys sk;
	int i;
	unsigned char *p;

	Check_Type(key, T_STRING);
	if( RSTRING(key)->len != 32 )
		rb_raise(rb_eRuntimeError, "string must have length of 32");
	
	p = (unsigned char*)RSTRING(key)->ptr;

	for(i=0;i<8;i++) k.b[i] = (((((((ulong)p[(i*4)+0]) << 8) | p[(i*4)+1]) << 8) | p[(i*4)+2]) << 8) | p[(i*4)+3];
	k2 = k;

	generate_subkeys(k,  sk.a[0], ENCRYPT);
	generate_subkeys(k2, sk.a[1], DECRYPT);
	return rb_str_new((char*)&sk,sizeof(dsubkeys));
}



extern "C" VALUE crypt_block(VALUE obj, VALUE block, VALUE subkeys, VALUE mode)
{
	// parameter:
	//				block	: string[16]
	//				subkeys	: string -> created by set_key
	//				mode	: fixnum (ENCRYPT/DECRYPT)
	//				
	// returns:		block	: string[16]
	

	bitblock_128 blk;
	unsigned char *p;
	char txt[16];
	int i, md;
	dsubkeys *sk;


    Check_Type(block, T_STRING);
	if( RSTRING(block)->len != 16 )
		rb_raise(rb_eRuntimeError, "string must have length of 16");
	
	Check_Type(subkeys, T_STRING);
	if( RSTRING(subkeys)->len != sizeof(dsubkeys) )
		rb_raise(rb_eRuntimeError, "string must contain the subkey-data");
	

	// block -> in
	p = (unsigned char*)RSTRING(block)->ptr;
	for(i=0;i<4;i++) blk.b[i] = (((((((ulong)p[(i*4)+0]) << 8) | p[(i*4)+1]) << 8) | p[(i*4)+2]) << 8) | p[(i*4)+3];

	sk = (dsubkeys*) RSTRING(subkeys)->ptr;
	md = NUM2INT(mode);
	
	if(md == ENCRYPT) cast256_crypt_block(blk, sk->a[0]);
	else if(md == DECRYPT) cast256_crypt_block(blk, sk->a[1]);
	else rb_raise(rb_eRuntimeError, "mode must be either ENCRYPT or DECRYPT");

	for(i=0;i<4;i++)
	{
		txt[(i*4)+0] = (char)(blk.b[i]>>24);
		txt[(i*4)+1] = (char)((blk.b[i]>>16)&0xFF);
		txt[(i*4)+2] = (char)((blk.b[i]>>8)&0xFF);
		txt[(i*4)+3] = (char)(blk.b[i]&0xFF);
	}

	VALUE ret = rb_str_new(txt,16);
	for(i=0;i<16;i++) txt[i] = 0;
	return ret;
}



extern "C" __declspec(dllexport) void Init_rcast_256(void){
	VALUE mCAST_256 = rb_define_module("RCAST_256");
	
	rb_define_const(mCAST_256, "ENCRYPT", INT2FIX(ENCRYPT) );
	rb_define_const(mCAST_256, "DECRYPT", INT2FIX(DECRYPT) );

	rb_define_module_function(mCAST_256, "set_key",(unsigned long (__cdecl *)(void)) set_key ,1);
	rb_define_module_function(mCAST_256, "crypt_block",(unsigned long (__cdecl *)(void)) crypt_block ,3);
}
