
/*
 *  CAST-256, algorithm by Carlisle Adams (Entrust Technologies)
 *
 *  candidate for AES (Advanced Encryption Standard)
 *
 *  Implementation is Copyright (c) 1999 by Michael Neumann (neumann@s-direktnet.de)
 *  22.04.1999
 * 
 *  key-size is 256 bit
 * 
 *  version 2.0
 *
 */

#ifndef __CAST_256_HEADER__
#define __CAST_256_HEADER__


typedef unsigned long ulong;
typedef unsigned char uchar;

// structure for generated keys
struct subkeys {
	ulong km[12][4];
	ulong kr[12][4];

	~subkeys() {zero();}
	void zero()
	{
		for(int i=0;i<12;i++)
			for(int j=0;j<4;j++) km[i][j] = kr[i][j] = 0;
	}
};

// structure for 256-bit key
struct bitblock_256 {
	ulong b[8];

	~bitblock_256() {zero();}
	void zero()
	{
		for(int i=0;i<8;i++) b[i] = 0;
	}
};

// structure for 128-bit data-block
struct bitblock_128 {
	ulong b[4];

	~bitblock_128() {zero();}
	void zero()
	{
		for(int i=0;i<4;i++) b[i] = 0;
	}
};


enum CRYPT_MODE {ENCRYPT, DECRYPT};

extern void cast256_crypt_block(bitblock_128 &b, subkeys &sk);
extern void generate_subkeys(bitblock_256 &k, subkeys &sk, CRYPT_MODE m);

#endif