#
#  CAST-256, algorithm by Carlisle Adams (Entrust Technologies)
#  candidate for AES (Advanced Encryption Standard)
#
#  implementation by Michael Neumann (neumann@s-direktnet.de)
#  23.05.1999
# 
#  key-size:   256-bit
#  block-siez: 128-bit
#  language:   Ruby 1.3x (www.netlab.co.jp/ruby/) and C++
#  url:        http://www.s-direktnet.de/homepages/neumann/crypt/en/
#

require 'rcast_256'

class CAST_256

   # key must be a string of 64 hexadecimal digits
   def set_key(key)
      if key.length != 64 then
         raise "Key must be a string of 64 hexadecimal digits"
      end

      str = ""
      for i in 0..31
         a = "0x" + key[i*2].chr + key[(i*2)+1].chr
         str += Integer(a).chr
      end
      
      @subkeys = RCAST_256.set_key(str)
   end


   def encrypt_block(block)
      crypt_block(block, ENCRYPT)
   end

   def decrypt_block(block)
      crypt_block(block, DECRYPT)
   end


   # block must have length of BLOCKSIZE
   def crypt_block(block, mode)
      if !defined?(@subkeys) then
         raise "Uninitialized key! Call <set_key> before!"
      else
         if block.length != BLOCKSIZE then
            raise "Wrong blocksize! Had to be #{BLOCKSIZE} bytes!"
	 else            
            RCAST_256.crypt_block(block,@subkeys,mode)
         end
      end      
   end   

   ENCRYPT   = RCAST_256::ENCRYPT
   DECRYPT   = RCAST_256::DECRYPT
   BLOCKSIZE = 16			# do not change this

   VERSION   = 1.0
end
