#--------------------------------------------------------
# Host: localhost   Database: rth
#--------------------------------------------------------

#SET sql_mode = 'ANSI';

#
# Table structure for table 'bug'
#

CREATE TABLE `bug` (
  `BugID` int(8) unsigned NOT NULL auto_increment,
  `ProjectID` int(8) unsigned default NULL,
  `Category` int(8) unsigned default NULL,
  `Component` int(8) unsigned default NULL,
  `Priority` varchar(32) default NULL,
  `Severity` varchar(32) default NULL,
  `ClosedReasonCode` varchar(32) default NULL,
  `Status` varchar(64) default NULL,
  `Reporter` varchar(128) default NULL,
  `ReportedDate` varchar(19) default NULL,
  `AssignedTo` varchar(128) default NULL,
  `AssignedToDeveloper` varchar(128) default NULL,
  `Closed` char(1) default 'N',
  `ClosedDate` varchar(19) default NULL,
  `TestID` varchar(20) default NULL,
  `ReqID` varchar(20) default NULL,
  `FoundInRelease` varchar(32) default NULL,
  `AssignToRelease` varchar(32) default NULL,
  `ImplementedInRelease` varchar(32) default NULL,
  `DiscoveryPeriod` varchar(32) default NULL,
  `Summary` varchar(128) default NULL,
  `Description` text,
  PRIMARY KEY  (`BugID`),
  KEY `ProjectID` (`ProjectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'bug'
#
INSERT INTO bug VALUES(1,1,1,3,"High","Critical","","New","admin","2005-11-26 17:59:47","","","N","","8","","","","","Test","We have a big, big problem","I see London, I see France...\r\n\r\nThis can&#039;t be good.\r\n");
INSERT INTO bug VALUES(2,1,1,1,"High","Critical","","New","admin","2005-11-29 18:34:21","admin","","N","","16","","Release 1.0","","","Test","Found a big, big, bug","Houston, we have a problem");


#
# Table structure for table 'bugassoc'
#

CREATE TABLE `bugassoc` (
  `BugAssocID` int(8) unsigned NOT NULL auto_increment,
  `PrimaryID` int(8) unsigned default NULL,
  `SecondaryID` int(8) unsigned default NULL,
  `RelationshipType` char(1) default NULL,
  PRIMARY KEY  (`BugAssocID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'bugassoc'
#


#
# Table structure for table 'bugcategory'
#

CREATE TABLE `bugcategory` (
  `CategoryID` int(8) unsigned NOT NULL auto_increment,
  `ProjectID` int(8) unsigned default NULL,
  `CategoryName` varchar(64) default NULL,
  PRIMARY KEY  (`CategoryID`),
  UNIQUE KEY `projectid` (`CategoryName`,`ProjectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'bugcategory'
#
INSERT INTO bugcategory VALUES(1,1,"Defect");
INSERT INTO bugcategory VALUES(2,1,"Data Change");
INSERT INTO bugcategory VALUES(3,1,"Enhancement");


#
# Table structure for table 'bugcomponent'
#

CREATE TABLE `bugcomponent` (
  `ComponentID` int(8) unsigned NOT NULL auto_increment,
  `ProjectID` int(8) unsigned default NULL,
  `ComponentName` varchar(64) default NULL,
  PRIMARY KEY  (`ComponentID`),
  UNIQUE KEY `projectid` (`ComponentName`,`ProjectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'bugcomponent'
#
INSERT INTO bugcomponent VALUES(1,1,"E-mail");
INSERT INTO bugcomponent VALUES(2,1,"Requirements");
INSERT INTO bugcomponent VALUES(3,1,"Tests");
INSERT INTO bugcomponent VALUES(4,1,"Test Results");
INSERT INTO bugcomponent VALUES(5,1,"Defects");


#
# Table structure for table 'bugfile'
#

CREATE TABLE `bugfile` (
  `BugFileID` int(8) unsigned NOT NULL auto_increment,
  `BugID` int(8) unsigned default NULL,
  `UploadedDate` varchar(19) default NULL,
  `UploadedBy` varchar(30) default NULL,
  `DisplayName` varchar(255) default NULL,
  `BugFileName` varchar(255) default NULL,
  PRIMARY KEY  (`BugFileID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


#
# Table structure for table 'bugfile'
#


#
# Table structure for table 'bughistory'
#

CREATE TABLE `bughistory` (
  `BugHistoryID` int(8) unsigned NOT NULL auto_increment,
  `BugID` int(8) unsigned default NULL,
  `DateModified` varchar(19) default NULL,
  `UserName` varchar(64) default NULL,
  `Field` varchar(64) default NULL,
  `OldValue` varchar(64) default NULL,
  `NewValue` varchar(64) default NULL,
  PRIMARY KEY  (`BugHistoryID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'bughistory'
#
INSERT INTO bughistory VALUES(1,1,"2005-11-26 17:59:47","admin","New Defect","","");
INSERT INTO bughistory VALUES(2,2,"2005-11-29 18:34:21","admin","New Defect","","");


#
# Table structure for table 'bugmonitor'
#

CREATE TABLE `bugmonitor` (
  `BugMonitorID` int(11) unsigned NOT NULL auto_increment,
  `UserID` int(11) unsigned NOT NULL default '0',
  `BugID` int(11) unsigned NOT NULL default '0',
  `Monitor` char(1) NOT NULL default 'N',
  PRIMARY KEY  (`BugMonitorID`),
  UNIQUE KEY `userid_bugid` (`UserID`,`BugID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'bugmonitor'
#


#
# Table structure for table 'bugnote'
#

CREATE TABLE `bugnote` (
  `BugNoteID` int(8) unsigned NOT NULL auto_increment,
  `BugID` int(8) unsigned default NULL,
  `Author` varchar(64) default NULL,
  `DateCreated` varchar(19) default NULL,
  `BugNoteDetail` text,
  PRIMARY KEY  (`BugNoteID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'bugnote'
#


#
# Table structure for table 'build'
#

CREATE TABLE `build` (
  `ReleaseID` int(8) unsigned NOT NULL default '0',
  `BuildID` int(8) unsigned NOT NULL auto_increment,
  `BuildName` varchar(20) default NULL,
  `Description` text,
  `DateReceived` varchar(19) NOT NULL default '',
  `DateFinished` varchar(19) NOT NULL default '',
  `Archive` char(1) NOT NULL default '',
  `DateCreated` varchar(19) NOT NULL default '',
  `LogTimeStamp` varchar(19) NOT NULL default '',
  PRIMARY KEY  (`BuildID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'build'
#
INSERT INTO build VALUES(1,1,"Build 1.0","","2005-11-23 22:30:38","2002-01-01 12:00:00","N","2002-01-01 12:00:00","2005-11-23 22:30:38");


#
# Table structure for table 'discussion'
#

CREATE TABLE `discussion` (
  `DiscussionID` int(8) unsigned NOT NULL auto_increment,
  `ReqID` int(8) unsigned NOT NULL default '0',
  `Discussion` text,
  `Status` varchar(7) default NULL,
  `DiscSubject` varchar(255) default NULL,
  `Author` varchar(25) default NULL,
  `AssignTo` varchar(25) default NULL,
  `Date` varchar(19) default NULL,
  PRIMARY KEY  (`DiscussionID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'discussion'
#


#
# Table structure for table 'discussionpost'
#

CREATE TABLE `discussionpost` (
  `PostID` int(8) unsigned NOT NULL auto_increment,
  `DiscussionID` int(8) unsigned NOT NULL default '0',
  `Post` text,
  `Author` varchar(25) default NULL,
  `AssignTo` varchar(25) default NULL,
  `Date` varchar(19) default NULL,
  PRIMARY KEY  (`PostID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'discussionpost'
#


#
# Table structure for table 'feedback'
#

CREATE TABLE `feedback` (
  `FeedbackID` smallint(4) unsigned NOT NULL auto_increment,
  `Author` varchar(15) default NULL,
  `Comment` text,
  `Project` varchar(15) default NULL,
  `TimeStamp` varchar(19) default NULL,
  PRIMARY KEY  (`FeedbackID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'feedback'
#

#
# Table structure for table 'function_tbl'
#

CREATE TABLE `function_tbl` (
  `function_id` int(8) unsigned NOT NULL auto_increment,
  `date_created` varchar(19) NOT NULL default '',
  `last_updated` varchar(19) NOT NULL default '',
  `last_updated_by` varchar(30) NOT NULL default '',
  `function_name` varchar(128) NOT NULL default '',
  `description` varchar(255) default NULL,
  PRIMARY KEY  (`function_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


#
# Dumping data for table 'function_tbl'
#

#
# Table structure for table 'guichecktable'
#

CREATE TABLE `guichecktable` (
  `GuiCheckID` int(8) unsigned NOT NULL auto_increment,
  `GuiCheckNumber` int(3) unsigned default NULL,
  `IconCode` varchar(6) default NULL,
  `TS_UniqueRunID` varchar(14) default NULL,
  `ObjectName` varchar(50) default NULL,
  `ExpectedValue` varchar(50) default NULL,
  `ActualValue` varchar(50) default NULL,
  `Status` varchar(10) default NULL,
  PRIMARY KEY  (`GuiCheckID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'guichecktable'
#


#
# Table structure for table 'individualrundocs'
#

CREATE TABLE `individualrundocs` (
  `UniqueDocID` int(8) unsigned NOT NULL auto_increment,
  `TS_UniqueRunID` varchar(14) default '0',
  `TimeStamp` varchar(19) default NULL,
  `UploadedBy` varchar(50) default NULL,
  `FileName` varchar(255) default NULL,
  `DisplayName` varchar(150) default NULL,
  `Comments` varchar(255) default NULL,
  `Link` varchar(255) default NULL,
  PRIMARY KEY  (`UniqueDocID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'individualrundocs'
#


#
# Table structure for table 'issues'
#

CREATE TABLE `issues` (
  `id` int(6) unsigned NOT NULL auto_increment,
  `Name` char(150) default NULL,
  `Priority` char(50) default NULL,
  `Status` char(50) default NULL,
  `Details` char(255) default NULL,
  `Owner` char(50) default NULL,
  `Timestamp` varchar(19) default NULL,
  `Type` char(50) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'issues'
#


#
# Table structure for table 'logs'
#

CREATE TABLE `logs` (
  `LogID` int(8) unsigned NOT NULL auto_increment,
  `SessionID` int(10) unsigned default NULL,
  `Deletion` char(1) default NULL,
  `Creation` char(1) default NULL,
  `Upload` char(1) default NULL,
  `TimeStamp` varchar(19) default NULL,
  `User` varchar(30) default NULL,
  `Page` varchar(50) default NULL,
  `Action` text,
  PRIMARY KEY  (`LogID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'logs'
#
INSERT INTO logs VALUES(1,"1132802461","N","Y","N","2005-11-23 22:30:21","admin","CREATE RELEASE - DEMO","ADDED RELEASE Release 1.0");
INSERT INTO logs VALUES(2,"1132802461","N","Y","N","2005-11-23 22:30:38","admin","ADD BUILD - DEMO","ADDED BUILD Build 1.0 TO RELEASE Release 1.0");
INSERT INTO logs VALUES(3,"1132802461","N","Y","N","2005-11-23 22:37:05","admin","CREATE TEST - DEMO","ADDED TEST Demo_Test");
INSERT INTO logs VALUES(4,"1132802461","N","Y","N","2005-11-23 22:38:26","admin","test_step_add_action.php - DEMO","ADDED TEST STEP TO TEST ID 1");
INSERT INTO logs VALUES(5,"1132802461","N","Y","N","2005-11-23 22:40:23","admin","test_step_add_action.php - DEMO","ADDED TEST STEP TO TEST ID 1");
INSERT INTO logs VALUES(6,"1132802461","N","Y","N","2005-11-23 22:41:29","admin","test_step_add_action.php - DEMO","ADDED TEST STEP TO TEST ID 1");
INSERT INTO logs VALUES(7,"1132802461","N","Y","N","2005-11-23 22:44:31","admin","test_step_add_action.php - DEMO","ADDED TEST STEP TO TEST ID 1");
INSERT INTO logs VALUES(8,"1132802461","N","Y","N","2005-11-23 22:49:23","admin","CREATE TEST - DEMO","ADDED TEST Demo_Test2");
INSERT INTO logs VALUES(9,"1132802461","N","Y","N","2005-11-23 23:23:53","admin","ADD TESTSET - DEMO","ADDED TESTSET Regression to Build 1.0");
INSERT INTO logs VALUES(10,"1133304144","N","Y","N","2005-11-29 17:59:53","admin","test_step_add_action.php - DEMO","ADDED TEST STEP TO TEST ID 2");
INSERT INTO logs VALUES(11,"1133304144","N","Y","N","2005-11-29 18:00:43","admin","test_step_add_action.php - DEMO","ADDED TEST STEP TO TEST ID 2");
INSERT INTO logs VALUES(12,"1133304144","N","Y","N","2005-11-29 18:01:32","admin","test_step_add_action.php - DEMO","ADDED TEST STEP TO TEST ID 2");
INSERT INTO logs VALUES(13,"1133304144","N","Y","N","2005-11-29 18:02:09","admin","test_step_add_action.php - DEMO","ADDED TEST STEP TO TEST ID 2");


#
# Table structure for table 'manualdoctype'
#

CREATE TABLE `manualdoctype` (
  `ManualDocTypeID` smallint(4) unsigned NOT NULL auto_increment,
  `ProjectID` int(8) unsigned default NULL,
  `ManualDocTypeName` varchar(50) default '0',
  PRIMARY KEY  (`ManualDocTypeID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'manualdoctype'
#
INSERT INTO manualdoctype VALUES(1,1,"Test Case");
INSERT INTO manualdoctype VALUES(2,1,"Rules Doc");


#
# Table structure for table 'manualtestdocs'
#

CREATE TABLE `manualtestdocs` (
  `ManualTestID` int(8) unsigned NOT NULL auto_increment,
  `TestID` int(8) unsigned NOT NULL default '0',
  `DisplayName` varchar(150) default 'NULL',
  PRIMARY KEY  (`ManualTestID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'manualtestdocs'
#


#
# Table structure for table 'manualtestdocs_version'
#

CREATE TABLE `manualtestdocs_version` (
  `VersionID` int(8) unsigned NOT NULL auto_increment,
  `ManualTestID` int(8) unsigned default NULL,
  `Version` decimal(4,2) default NULL,
  `TimeStamp` varchar(19) default NULL,
  `UploadedBy` varchar(50) default NULL,
  `FileName` varchar(150) default NULL,
  `Comments` text,
  `ManualDocTypeName` varchar(50) default NULL,
  PRIMARY KEY  (`VersionID`),
  KEY `manualtestid_timestamp` (`ManualTestID`,`TimeStamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'manualtestdocs_version'
#


#
# Table structure for table 'news'
#

CREATE TABLE `news` (
  `project_id` int(6) unsigned NOT NULL default '0',
  `NewsID` int(8) unsigned NOT NULL auto_increment,
  `Subject` varchar(100) NOT NULL default '',
  `Body` text,
  `LastModified` varchar(19) NOT NULL default '',
  `Poster` varchar(20) NOT NULL default '',
  `Deleted` char(1) NOT NULL default 'N',
  PRIMARY KEY  (`NewsID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'news'
#


#
# Table structure for table 'release_tbl'
#

CREATE TABLE `release_tbl` (
  `project_id` int(8) unsigned NOT NULL default '0',
  `ReleaseID` int(8) unsigned NOT NULL auto_increment,
  `Archive` char(1) NOT NULL default 'N',
  `ReleaseName` varchar(20) NOT NULL default '',
  `Description` text,
  `DateReceived` varchar(19) NOT NULL default '',
  `DateCreated` varchar(19) NOT NULL default '',
  `LogTimeStamp` varchar(19) NOT NULL default '',
  `Platform` varchar(6) NOT NULL default '',
  `QASignoffDate` varchar(19) NOT NULL default '',
  `BASignoffDate` varchar(19) NOT NULL default '',
  `QASignoffBy` varchar(25) NOT NULL default '',
  `BASignoffBy` varchar(25) NOT NULL default '',
  `QASignoff` varchar(40) NOT NULL default '',
  `BASignoff` varchar(40) NOT NULL default '',
  `QASignoffComments` text,
  `BASignoffComments` text,
  PRIMARY KEY  (`ReleaseID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'release_tbl'
#
INSERT INTO release_tbl VALUES(1,1,"N","Release 1.0","","2005-11-23 22:30:21","2005-11-23 22:30:21","2005-11-23 22:30:21","","","","","","","","","");


#
# Table structure for table 'requirement'
#

CREATE TABLE `requirement` (
  `project_id` int(8) unsigned NOT NULL default '0',
  `ReqID` int(8) unsigned NOT NULL auto_increment,
  `ReqName` varchar(255) NOT NULL default '',
  `AreaCovered` int(11) unsigned NOT NULL default '0',
  `Type` int(8) unsigned NOT NULL default '0',
  `RecordOrFile` char(1) NOT NULL default 'R',
  `UnTestable` char(1) default 'N',
  `LockedBy` varchar(25) NOT NULL default '',
  `LockedDate` varchar(25) NOT NULL default '',
  `Priority` varchar(25) default NULL,
  `Parent` int(8) unsigned NOT NULL default '0',
  `DateCreated` varchar(19) default NULL,
  `LogTimeStamp` varchar(19) default NULL,
  `LastUpdated` varchar(19) default NULL,
  PRIMARY KEY  (`ReqID`),
  UNIQUE KEY `projectid` (`ReqName`,`project_id`),
  KEY `parent` (`Parent`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'requirement'
#
INSERT INTO requirement VALUES(1,1,"Requirement_Record1","3","3","R","Y","","","High","0","2005-11-23 23:19:33","2005-11-23 23:19:33","2005-11-23 23:19:33");
INSERT INTO requirement VALUES(1,2,"Sub-Req1","3","3","R","Y","","","Medium","1","2005-11-23 23:19:33","2005-11-23 23:19:34","2005-11-23 23:19:33");
INSERT INTO requirement VALUES(1,3,"Sub-Req2","3","3","R","Y","","","Low","1","2005-11-23 23:19:33","2005-11-23 23:19:37","2005-11-23 23:19:33");


#
# Table structure for table 'requirementareacoverage'
#

CREATE TABLE `requirementareacoverage` (
  `ReqAreaCoverageID` int(8) unsigned NOT NULL auto_increment,
  `ProjectID` int(8) unsigned default NULL,
  `AreaCoverage` varchar(50) default NULL,
  PRIMARY KEY  (`ReqAreaCoverageID`),
  UNIQUE KEY `projectid` (`ProjectID`,`AreaCoverage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'requirementareacoverage'
#
INSERT INTO requirementareacoverage VALUES(1,1,"Requirements");
INSERT INTO requirementareacoverage VALUES(2,1,"Bugs");
INSERT INTO requirementareacoverage VALUES(3,1,"Tests");
INSERT INTO requirementareacoverage VALUES(4,1,"Test Results");


#
# Table structure for table 'requirementdocumenttype'
#

CREATE TABLE `requirementdocumenttype` (
  `ReqDocTypeID` smallint(4) unsigned NOT NULL auto_increment,
  `ProjectID` int(8) unsigned NOT NULL default '0',
  `ReqDocTypeName` varchar(50) NOT NULL default '',
  `RootDocument` char(1) NOT NULL default 'N',
  PRIMARY KEY  (`ReqDocTypeID`),
  UNIQUE KEY `projectid` (`ProjectID`,`ReqDocTypeName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'requirementdocumenttype'
#
INSERT INTO requirementdocumenttype VALUES(1,1,"Use Case","N");
INSERT INTO requirementdocumenttype VALUES(2,1,"Func Spec","N");
INSERT INTO requirementdocumenttype VALUES(3,1,"Tech Spec","N");


#
# Table structure for table 'requirementfunctionality'
#

CREATE TABLE `requirementfunctionality` (
  `FunctionalityID` int(8) unsigned NOT NULL auto_increment,
  `ProjectID` int(8) unsigned NOT NULL default '0',
  `FunctionalityName` varchar(50) NOT NULL default '0',
  PRIMARY KEY  (`FunctionalityID`),
  UNIQUE KEY `projectid` (`ProjectID`,`FunctionalityName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'requirementfunctionality'
#
INSERT INTO requirementfunctionality VALUES(1,1,"User Mgmt");
INSERT INTO requirementfunctionality VALUES(7,1,"Run Level");
INSERT INTO requirementfunctionality VALUES(8,1,"Permissions");
INSERT INTO requirementfunctionality VALUES(5,1,"Cron");
INSERT INTO requirementfunctionality VALUES(6,1,"Group Mgmt");


#
# Table structure for table 'requirementfunctionality_assoc'
#

CREATE TABLE `requirementfunctionality_assoc` (
  `RequirementFunctionality_AssocID` int(6) unsigned NOT NULL auto_increment,
  `RequirementID` int(6) unsigned NOT NULL default '0',
  `RequirementFunctionalityID` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`RequirementFunctionality_AssocID`),
  UNIQUE KEY `reqid_reqfunctid` (`RequirementID`,`RequirementFunctionalityID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'requirementfunctionality_assoc'
#
INSERT INTO requirementfunctionality_assoc VALUES(1,1,8);
INSERT INTO requirementfunctionality_assoc VALUES(2,2,7);
INSERT INTO requirementfunctionality_assoc VALUES(3,3,8);


#
# Table structure for table 'requirementnotifications'
#

CREATE TABLE `requirementnotifications` (
  `ReqNotifyID` int(8) unsigned NOT NULL auto_increment,
  `ReqID` int(8) unsigned NOT NULL default '0',
  `UserID` int(8) NOT NULL default '0',
  PRIMARY KEY  (`ReqNotifyID`),
  UNIQUE KEY `userid_reqid` (`UserID`,`ReqID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'requirementnotifications'
#


#
# Table structure for table 'requirementversion'
#

CREATE TABLE `requirementversion` (
  `ReqVersionID` int(8) unsigned NOT NULL auto_increment,
  `ReqID` int(8) unsigned NOT NULL default '0',
  `defect_id` int(8) unsigned NOT NULL default '0',
  `Version` varchar(5) NOT NULL default '',
  `Latest` char(1) NOT NULL default '',
  `TimeStamp` varchar(19) default NULL,
  `Author` varchar(50) NOT NULL default '',
  `FileName` varchar(150) NOT NULL default '',
  `ReasonForChange` text,
  `Status` varchar(25) NOT NULL default '',
  `AssignedTo` varchar(255) NOT NULL default '',
  `Detail` text,
  `LastUpdated` varchar(19) default NULL,
  `LastUpdatedBy` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`ReqVersionID`),
  KEY `ReqID` (`ReqID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'requirementversion'
#
INSERT INTO requirementversion VALUES(1,1,"1.0","0","Y","2005-11-23 23:06:24","admin","","","New","","System Shall not tip over and die when logging in...","2005-11-23 23:06:24","admin");
INSERT INTO requirementversion VALUES(2,2,"1.0","0","Y","2005-11-23 23:08:35","admin","","","","","Creating a sub-requirement","2005-11-23 23:08:35","admin");
INSERT INTO requirementversion VALUES(3,3,"1.0","0","Y","2005-11-23 23:14:24","admin","","","","","A second sub-requirement","2005-11-23 23:14:24","admin");


#
# Table structure for table 'requirementversion_release_assoc'
#

CREATE TABLE `requirementversion_release_assoc` (
  `RequirementVersion_Release_AssocID` int(6) unsigned NOT NULL auto_increment,
  `RequirementVersionID` int(6) unsigned NOT NULL default '0',
  `ReleaseID` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`RequirementVersion_Release_AssocID`),
  UNIQUE KEY `reqversionid_releaseid` (`RequirementVersionID`,`ReleaseID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'requirementversion_release_assoc'
#


#
# Table structure for table 'screen'
#

CREATE TABLE `screen` (
  `screen_id` int(8) unsigned NOT NULL auto_increment,
  `project_id` int(8) unsigned NOT NULL,
  `screen_order` DECIMAL(8,1) NOT NULL,
  `screen_name` varchar(64) default NULL,
  `screen_desc` varchar(255) default NULL,
  PRIMARY KEY  (`screen_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


#
# Dumping data for table 'screen'
#


CREATE TABLE `field_tbl` (
  `field_id` int(8) unsigned NOT NULL auto_increment,
  `screen_id` int(8) unsigned NOT NULL,
  `text_only` char(1),
  `field_order` DECIMAL(8,1) NOT NULL,
  `field_name` varchar(64) default NULL,
  `field_desc` varchar(255) default NULL,
  PRIMARY KEY  (`field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


#
# Dumping data for table 'field_tbl'
#



#
# Table structure for table 'project'
#

CREATE TABLE `project` (
  `project_id` int(4) unsigned NOT NULL auto_increment,
  `use_files` char(1) NOT NULL default 'Y',
  `show_custom_1` char(1) NOT NULL default 'Y',
  `show_custom_2` char(1) NOT NULL default 'Y',
  `show_custom_3` char(1) NOT NULL default 'Y',
  `show_custom_4` char(1) NOT NULL default 'Y',
  `show_custom_5` char(1) default 'Y',
  `show_custom_6` char(1) default 'Y',
  `show_window` char(1) NOT NULL default 'Y',
  `show_object` char(1) NOT NULL default 'Y',
  `show_memory_stats` char(1) NOT NULL default 'Y',
  `show_priority` char(1) NOT NULL default 'Y',
  `show_test_input` char(1) NOT NULL default 'Y',
  `status` char(1) NOT NULL default 'Y',
  `date_created` varchar(19) default NULL,
  `project_name` varchar(50) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `req_upload_path` varchar(255) default NULL,
  `test_upload_path` varchar(255) default NULL,
  `test_run_upload_path` varchar(255) default NULL,
  `test_plan_upload_path` varchar(255) NOT NULL default '',
  `defect_upload_path` varchar(255) NOT NULL default '',
  `bug_url` varchar(255) default NULL,
  `deleted` char(1) NOT NULL default 'N',
  PRIMARY KEY  (`project_id`),
  UNIQUE KEY `project_name` (`project_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'project'
#
INSERT INTO project VALUES(1,"Y","Y","Y","Y","Y","Y","Y","Y","Y","Y","Y","Y","Y","2005-11-26 17:51:11","DEMO","The default demo project","./rth_file_upload/DEMO_req_docs/","./rth_file_upload/DEMO_test_docs/","./rth_file_upload/DEMO_test_run_docs/","./rth_file_upload/DEMO_test_plan_docs/","./rth_file_upload/DEMO_defect_docs/","","N");


#
# Table structure for table 'project_user_assoc'
#

CREATE TABLE `project_user_assoc` (
  `project_user_assoc_id` int(4) unsigned NOT NULL auto_increment,
  `project_id` int(4) unsigned NOT NULL default '0',
  `user_id` int(4) unsigned NOT NULL default '0',
  `delete_rights` char(1) default NULL,
  `email_testset` char(1) default NULL,
  `email_discussion` char(1) default NULL,
  `email_new_bug` char(1) NOT NULL default 'N',
  `email_update_bug` char(1) NOT NULL default 'N',
  `email_assigned_bug` char(1) NOT NULL default 'N',
  `email_bugnote_bug` char(1) NOT NULL default 'N',
  `email_status_bug` char(1) NOT NULL default 'N',
  `qa_tester` char(1) default NULL,
  `ba_owner` char(1) default NULL,
  `user_rights` varchar(25) default NULL,
  PRIMARY KEY  (`project_user_assoc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'project_user_assoc'
#
INSERT INTO project_user_assoc VALUES(1,1,1,"Y","Y","Y","Y","Y","Y","Y","Y","Y","Y","10");
INSERT INTO project_user_assoc VALUES(2,1,2,"N","N","N","N","N","N","Y","Y","Y","Y","10");
INSERT INTO project_user_assoc VALUES(3,1,3,"N","N","N","N","N","Y","N","Y","Y","Y","10");


#
# Table structure for table 'reset_password'
#

CREATE TABLE `reset_password` (
  `reset_id` int(11) NOT NULL auto_increment,
  `user` varchar(50) NOT NULL default '0',
  `reset_link` varchar(25) NOT NULL default '',
  `reset_used` char(1) NOT NULL default '',
  `expires` varchar(19) default NULL,
  PRIMARY KEY  (`reset_id`),
  UNIQUE KEY `reset_link` (`reset_link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'reset_password'
#

#
# Table structure for table 'step_tbl'
#

CREATE TABLE `step_tbl` (
  `step_id` int(8) unsigned NOT NULL auto_increment,
  `function_id` int(8) unsigned default NULL,
  `step_number` decimal(8,1) default NULL,
  `action` text,
  `inputs` text,
  `expected_result` text,
  `step_type` varchar(11) NOT NULL default '',
  PRIMARY KEY  (`step_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# Dumping data for table 'step_tbl'
#



#
# Table structure for table 'testarea'
#

CREATE TABLE `testarea` (
  `AreaTestedID` smallint(4) unsigned NOT NULL auto_increment,
  `project_id` int(8) unsigned NOT NULL default '0',
  `AreaTestedName` varchar(50) default '0',
  PRIMARY KEY  (`AreaTestedID`),
  UNIQUE KEY `projectid` (`AreaTestedName`,`project_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testarea'
#
INSERT INTO testarea VALUES(1,1,"Requirements");
INSERT INTO testarea VALUES(2,1,"Tests");
INSERT INTO testarea VALUES(3,1,"Test Results");
INSERT INTO testarea VALUES(4,1,"Bugs");


#
# Table structure for table 'testenvironment'
#

CREATE TABLE `testenvironment` (
  `EnvironmentID` int(6) unsigned NOT NULL auto_increment,
  `ProjectID` int(8) unsigned default NULL,
  `EnvironmentName` char(50) default NULL,
  PRIMARY KEY  (`EnvironmentID`),
  UNIQUE KEY `projectid` (`EnvironmentName`,`ProjectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testenvironment'
#
INSERT INTO testenvironment VALUES(1,1,"Dev");
INSERT INTO testenvironment VALUES(2,1,"Prod");
INSERT INTO testenvironment VALUES(3,1,"QA");

#
# Table structure for table 'test_function_assoc'
#

CREATE TABLE `test_function_assoc` (
  `test_func_assoc_id` int(8) unsigned NOT NULL auto_increment,
  `test_id` int(8) unsigned NOT NULL default '0',
  `function_id` int(8) unsigned NOT NULL default '0',
  `on_error` varchar(128) default NULL,
  PRIMARY KEY  (`test_func_assoc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# Dumping data for table 'test_function_assoc'
#

#
# Table structure for table 'testmachine'
#

CREATE TABLE `testmachine` (
  `MachineID` smallint(4) unsigned NOT NULL auto_increment,
  `ProjectID` int(8) unsigned default NULL,
  `MachineName` char(20) default NULL,
  `MachineLocation` char(25) default NULL,
  `MachineIPAddress` char(15) default NULL,
  PRIMARY KEY  (`MachineID`),
  KEY `projectid` (`ProjectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testmachine'
#


#
# Table structure for table 'testplan'
#

CREATE TABLE `testplan` (
  `TestPlanID` int(8) unsigned NOT NULL auto_increment,
  `BuildID` int(8) unsigned default NULL,
  `TestPlanName` varchar(255) default NULL,
  PRIMARY KEY  (`TestPlanID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testplan'
#


#
# Table structure for table 'testplanversion'
#

CREATE TABLE `testplanversion` (
  `TestPlanVersionID` int(8) unsigned NOT NULL auto_increment,
  `TestPlanID` int(8) unsigned default NULL,
  `Latest` char(1) default 'Y',
  `Version` char(3) default NULL,
  `UploadedDate` varchar(19) default NULL,
  `UploadedBy` varchar(30) default NULL,
  `FileName` varchar(255) default NULL,
  `Comments` varchar(255) default NULL,
  PRIMARY KEY  (`TestPlanVersionID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testplanversion'
#


#
# Table structure for table 'testset'
#

CREATE TABLE `testset` (
  `TestSetID` int(8) unsigned NOT NULL auto_increment,
  `BuildID` int(8) unsigned NOT NULL default '0',
  `TestSetOrderBy` int(19) NOT NULL default '0',
  `Archive` char(3) NOT NULL default '',
  `DateCreated` varchar(19) NOT NULL default '2002-01-01 12:00:00',
  `SignOffDate` varchar(19) NOT NULL default '',
  `TestSetName` varchar(30) NOT NULL default '0',
  `SignOffBy` varchar(19) NOT NULL default '',
  `TestSetStatus` varchar(40) NOT NULL default '',
  `SignOffComments` varchar(255) NOT NULL default '',
  `Description` text,
  `UniqueID` varchar(15) NOT NULL default '',
  `TestSetType` varchar(30) default NULL,
  `LockChangeDate` varchar(19) default '',
  `Locked` varchar(1) NOT NULL default 'N',
  `LockBy` varchar(25) default '',
  `LockComment` varchar(300) default '',
  PRIMARY KEY  (`TestSetID`),
  KEY `buildid` (`BuildID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testset'
#
INSERT INTO testset VALUES(1,1,1,"N","2005-11-23 23:23:53","","Regression","","","","Our first ever test set","","","","N","","");


#
# Table structure for table 'testset_testsuite_assoc'
#

CREATE TABLE `testset_testsuite_assoc` (
  `TestSet_TestSuite_AssocID` int(8) unsigned NOT NULL auto_increment,
  `TestSetID` int(8) unsigned NOT NULL default '0',
  `TestID` int(8) unsigned NOT NULL default '0',
  `Finished` smallint(1) unsigned default '0',
  `LogTimeStamp` varchar(19) default NULL,
  `root_cause` varchar(30) default NULL,
  `TestStatus` varchar(30) NOT NULL default 'Not Started',
  `AssignedTo` varchar(25) NOT NULL default '',
  `Comments` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`TestSet_TestSuite_AssocID`,`TestSetID`),
  KEY `testid_idx` (`TestID`),
  KEY `testsetid` (`TestSetID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testset_testsuite_assoc'
#
INSERT INTO testset_testsuite_assoc VALUES(1,1,1,0,"2005-11-29 15:11:43","","Not Started","","");
INSERT INTO testset_testsuite_assoc VALUES(2,1,2,0,"2005-11-29 18:26:33","Application Defect","Failed","admin","Failed on the final step");


#
# Table structure for table 'teststatus'
#

CREATE TABLE `teststatus` (
  `TestStatusID` int(8) unsigned NOT NULL auto_increment,
  `project_id` int(8) unsigned NOT NULL default '0',
  `TestStatus` varchar(20) default NULL,
  PRIMARY KEY  (`TestStatusID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'teststatus'
#


#
# Table structure for table 'teststep'
#

CREATE TABLE `teststep` (
  `TestStepID` int(8) unsigned NOT NULL auto_increment,
  `TestID` int(8) unsigned default NULL,
  `TestVersionID` int(8) unsigned default NULL,
  `TestStep_Number` decimal(8,1) default NULL,
  `Action` text,
  `Inputs` text,
  `Expected_Result` text,
  `StepType` varchar(11) NOT NULL default '',
  PRIMARY KEY  (`TestStepID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'teststep'
#
INSERT INTO teststep VALUES(1,1,0,"2.0","Verify val_1 = 1","Person = my","val_1 = 1","N");
INSERT INTO teststep VALUES(8,2,0,"4.0","Click on the TestRunID link ","Link= Mxxxxxx","Verification page should appear.","N");
INSERT INTO teststep VALUES(2,1,0,"3.0","Verify val_2 = 1","Direction = left","val_2 = 1","N");
INSERT INTO teststep VALUES(7,2,0,"3.0","Click on the Results link for Demo_Test2","","Test Run page should appear.","N");
INSERT INTO teststep VALUES(3,1,0,"4.0","Verify val_3 = 1","Place = foot","val_3 = 1","N");
INSERT INTO teststep VALUES(6,2,0,"2.0","Click the Latest Test Set hyperlink","id = 00001","Results page appears","N");
INSERT INTO teststep VALUES(4,1,0,"1.0","This is my action. I am running","By checking info step, this step appears in Red and is not a step with an\r\n expected Pass/Fail status.  It is merely informational","Expected: I will not fall on my face","N");
INSERT INTO teststep VALUES(5,2,0,"1.0","Enter login information and click Submit button","url = http://localhost/rth/login.php\r\nuser = admin\r\npword = password","Home page appears.","N");


#
# Table structure for table 'testsuite'
#

CREATE TABLE `testsuite` (
  `TestID` int(8) unsigned NOT NULL auto_increment,
  `project_id` int(8) unsigned NOT NULL default '0',
  `Deleted` char(3) NOT NULL default '',
  `Archive` char(3) NOT NULL default '',
  `CodeReview` char(3) NOT NULL default '',
  `BA_Approval` char(3) NOT NULL default '',
  `Steps` char(3) NOT NULL default '',
  `Script` char(3) NOT NULL default '',
  `LoadRunner` char(3) NOT NULL default '',
  `AutoPass` char(1) NOT NULL default '',
  `email_ba_owner` CHAR(1) NOT NULL default 'N',
  `email_qa_owner` CHAR(1) NOT NULL default 'N',
  `Duration` varchar(5) NOT NULL default '',
  `Purpose` text,
  `TestSuiteName` varchar(150) NOT NULL default '',
  `TestType` varchar(50) NOT NULL default '',
  `AreaTested` varchar(50) NOT NULL default '',
  `BAOwner` varchar(25) NOT NULL default '',
  `Scripter` varchar(25) NOT NULL default '',
  `Tester` varchar(25) default NULL,
  `ApprovedForAuto` varchar(20) NOT NULL default '',
  `Priority` varchar(11) NOT NULL default '',
  `Status` varchar(30) NOT NULL default '',
  `DateCreated` varchar(19) default NULL,
  `Comments` varchar(255) NOT NULL default '',
  `AssignedTo` varchar(15) NOT NULL default '',
  `AssignedBy` varchar(15) NOT NULL default '',
  `DateAssigned` varchar(10) NOT NULL default '',
  `ExpDateComplete` varchar(10) NOT NULL default '',
  `ActDateComplete` varchar(10) NOT NULL default '',
  `BASignOff` varchar(10) NOT NULL default '',
  `SignOffBy` varchar(30) default NULL,
  `SignOffDate` varchar(10) default NULL,
  `LastUpdated` varchar(19) default NULL,
  `LastUpdatedBy` varchar(30) NOT NULL default '',
  `UniqueID` varchar(15) NOT NULL default '',
  `TestStepLinkID` int(8) default NULL,
  `State` char(3) default NULL,
  PRIMARY KEY  (`TestID`),
  KEY `areatested` (`AreaTested`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testsuite'
#
INSERT INTO testsuite VALUES(1,1,"N","N","","","YES","","","","","N","N","This test is intended to help new users to understand the system","Demo_Test","Regression","Bugs","","admin","qa_user","","High","New","","","","","","","","","","","2005-11-23 22:37:05","admin","",0,"");
INSERT INTO testsuite VALUES(2,1,"N","N","","","YES","","","","","","N","N","Demo_Test2","Regression","Bugs","ba_user","","qa_user","","Medium","New","","","","","","","","","","","2005-11-23 22:53:50","admin","",0,"");


#
# Table structure for table 'testsuite_requirement_assoc'
#

CREATE TABLE `testsuite_requirement_assoc` (
  `TestSuite_Requirement_AssocID` int(8) unsigned NOT NULL auto_increment,
  `TestID` int(8) unsigned NOT NULL default '0',
  `ReqID` int(8) unsigned NOT NULL default '0',
  `PercentCovered` int(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`TestSuite_Requirement_AssocID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testsuite_requirement_assoc'
#
INSERT INTO testsuite_requirement_assoc VALUES(1,1,1,50);
INSERT INTO testsuite_requirement_assoc VALUES(2,1,2,50);


#
# Table structure for table 'testsuiteresults'
#

CREATE TABLE `testsuiteresults` (
  `TestSuiteResultsID` int(8) unsigned NOT NULL auto_increment,
  `TestSetID` int(8) unsigned NOT NULL default '0',
  `project_id` int(8) unsigned NOT NULL default '0',
  `TestID` int(8) unsigned NOT NULL default '0',
  `LogTimeStamp` varchar(19) default NULL,
  `TestStatus` varchar(30) NOT NULL default 'Not Started',
  `assigned_to` varchar(25) NOT NULL default '',
  `root_cause` varchar(25) NOT NULL default '',
  `test_run_comment` varchar(255) NOT NULL default '',
  `Started` smallint(1) unsigned NOT NULL default '0',
  `Finished` smallint(1) unsigned NOT NULL default '0',
  `CVSVersion` decimal(4,2) NOT NULL default '0.00',
  `CheckedForAutoPass` char(1) NOT NULL default '',
  `OS` varchar(20) NOT NULL default '',
  `SP` varchar(15) NOT NULL default '',
  `nNumberID` varchar(8) NOT NULL default '',
  `UserID` varchar(10) NOT NULL default '',
  `MachineName` varchar(50) NOT NULL default '',
  `TestSuite` varchar(150) NOT NULL default '',
  `TestPath` varchar(255) NOT NULL default '',
  `Environment` varchar(20) NOT NULL default '',
  `RunID` varchar(25) NOT NULL default '',
  `TS_UniqueRunID` varchar(14) NOT NULL default '0',
  `TimeStarted` varchar(19) NOT NULL default '',
  `TimeFinished` varchar(19) NOT NULL default '',
  PRIMARY KEY  (`TestSuiteResultsID`),
  KEY `TS_UniqueRunID` (`TS_UniqueRunID`),
  KEY `testid` (`TestID`),
  KEY `testset_id` (`TestSetID`,`TS_UniqueRunID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testsuiteresults'
#
INSERT INTO testsuiteresults VALUES(11,1,0,2,"2005-11-29 18:03:17","Failed","admin","Application Defect","Test failed on final step","1","1","0.00","","Win2000","","","","","Demo_Test2","","QA","","M1133305397","2005-11-29 18:01:17","2005-11-29 18:03:17");
INSERT INTO testsuiteresults VALUES(12,1,0,2,"2005-11-29 18:10:33","Failed","admin","Application Defect","Failed on the final step","1","1","0.00","","Win95","","","","","Demo_Test2","","QA","","M1133305833","2005-11-29 18:08:33","2005-11-29 18:10:33");
INSERT INTO testsuiteresults VALUES(13,1,0,2,"2005-11-29 18:26:33","Failed","admin","Application Defect","Failed on the final step","1","1","0.00","","Win95","","","","","Demo_Test2","","QA","","M1133305986","2005-11-29 18:24:33","2005-11-29 18:26:33");


#
# Table structure for table 'testtype'
#

CREATE TABLE `testtype` (
  `TestTypeID` int(6) unsigned NOT NULL auto_increment,
  `project_id` int(8) unsigned default NULL,
  `TestType` varchar(50) default NULL,
  PRIMARY KEY  (`TestTypeID`),
  UNIQUE KEY `projectid` (`TestType`,`project_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testtype'
#
INSERT INTO testtype VALUES(1,1,"Smoke");
INSERT INTO testtype VALUES(2,1,"Regression");
INSERT INTO testtype VALUES(3,1,"Performance");
INSERT INTO testtype VALUES(4,1,"Functional");


#
# Table structure for table 'testversion'
#

CREATE TABLE `testversion` (
  `TestVersionID` int(8) unsigned NOT NULL auto_increment,
  `TestID` int(8) unsigned default NULL,
  `Version` decimal(4,2) default NULL,
  `Latest` char(1) default NULL,
  `ActiveVersion` char(1) default NULL,
  `Comments` varchar(255) default NULL,
  `Status` varchar(25) NOT NULL default '',
  `AssignedTo` varchar(30) NOT NULL default '',
  `BASignOff` varchar(10) NOT NULL default '',
  `SignOffBy` varchar(30) NOT NULL default '',
  `Creator` varchar(30) NOT NULL default '',
  `DateCreated` varchar(19) NOT NULL default '',
  PRIMARY KEY  (`TestVersionID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testversion'
#
INSERT INTO testversion VALUES(1,1,"1.00","Y","Y","","New","","","","admin","2005-11-23 22:37:05");
INSERT INTO testversion VALUES(2,2,"1.00","Y","Y","","New","","","","admin","2005-11-23 22:49:23");


#
# Table structure for table 'testworkflow'
#

CREATE TABLE `testworkflow` (
  `UniqueTestID` int(8) unsigned NOT NULL auto_increment,
  `Complete` char(1) NOT NULL default 'N',
  `TestName` varchar(150) default NULL,
  `BAToCreateTC` varchar(30) default NULL,
  `BACreateDateComp` varchar(10) default NULL,
  `QAToReviewTC` varchar(30) default NULL,
  `QAReviewDateComp` varchar(10) default NULL,
  `QAAutomated` varchar(30) default NULL,
  `QAAutoDateStart` varchar(10) default NULL,
  `QAAutoDateExp` varchar(10) default NULL,
  `QAAutoDateComp` varchar(10) default NULL,
  `BAToApprove` varchar(30) default NULL,
  `BAApprovalDate` varchar(10) default NULL,
  `Comments` varchar(255) default NULL,
  PRIMARY KEY  (`UniqueTestID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'testworkflow'
#

#
# Table structure for table 'user'
#

CREATE TABLE `user` (
  `user_id` int(4) unsigned NOT NULL auto_increment,
  `password` varchar(32) NOT NULL default '',
  `username` varchar(20) default NULL,
  `first_name` varchar(20) NOT NULL default '',
  `last_name` varchar(20) NOT NULL default '',
  `phone` varchar(25) NOT NULL default '',
  `menu_prefs` varchar(39) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `user_admin` varchar(25) NOT NULL default '',
  `default_project` int(6) unsigned NOT NULL default '0',
  `deleted` char(1) NOT NULL default 'N',
  `email_on_new` char(1) NOT NULL default '',
  `email_on_assigned_to` char(1) NOT NULL default '',
  `email_on_feedback` char(1) NOT NULL default '',
  `email_on_resolved` char(1) NOT NULL default '',
  `email_on_closed` char(1) NOT NULL default '',
  `email_on_reopened` char(1) NOT NULL default '',
  `email_on_bugnote` char(1) NOT NULL default '',
  `email_on_status` char(1) NOT NULL default '',
  `email_on_priority` char(1) NOT NULL default '',
  PRIMARY KEY  (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'user'
#
INSERT INTO user VALUES(1,"5f4dcc3b5aa765d61d8327deb882cf99","admin","Big","Shot","","","gth2@users.sourceforge.net","Y","1","N","","","","","","","","","");
INSERT INTO user VALUES(2,"b66c63a46b5a43eb5066cf6ac0b9f7ea","ba_owner","BA","Owner","","","user@domain.com","N","1","N","","","","","","","","","");
INSERT INTO user VALUES(3,"cc0e9a92816eeed502687b0db4d546c9","qa_user","QA","User","","","user2@domain.com","N","1","N","","","","","","","","","");



#
# Table structure for table 'verifyresults'
#

CREATE TABLE `verifyresults` (
  `VerifyResultsID` int(11) unsigned NOT NULL auto_increment,
  `LogTimeStamp` varchar(19) default NULL,
  `TestStatus` varchar(6) NOT NULL default '',
  `LineNumber` int(5) unsigned NOT NULL default '0',
  `defect_id` int(8) unsigned NOT NULL default '0',
  `TotalPhyMem` int(11) unsigned NOT NULL default '0',
  `FreePhyMem` int(11) unsigned NOT NULL default '0',
  `TotalVirMem` int(11) unsigned NOT NULL default '0',
  `FreeVirMem` int(11) unsigned NOT NULL default '0',
  `CurMemUtil` int(11) unsigned NOT NULL default '0',
  `TotalPageFile` int(11) unsigned NOT NULL default '0',
  `FreePageFile` int(11) unsigned NOT NULL default '0',
  `Custom_5` char(2) default NULL,
  `Custom_3` varchar(8) NOT NULL default '',
  `Custom_1` varchar(13) NOT NULL default '',
  `Custom_2` varchar(20) NOT NULL default '',
  `Custom_6` varchar(20) NOT NULL default '',
  `Custom_4` varchar(20) NOT NULL default '',
  `ActualResult` text NOT NULL default '',
  `Comment` varchar(255) NOT NULL default '',
  `Action` text default NULL,
  `ExpectedResult` text default NULL,
  `Window` varchar(100) NOT NULL default '',
  `Object` varchar(100) NOT NULL default '',
  `ObjType` varchar(25) default NULL,
  `StepNumber` varchar(25) default NULL,
  `TS_UniqueRunID` varchar(14) NOT NULL default '0',
  `TimeStamp` varchar(19) default NULL,
  PRIMARY KEY  (`VerifyResultsID`),
  KEY `teststatus` (`TestStatus`),
  KEY `ts_uniquerunid` (`TS_UniqueRunID`,`TestStatus`),
  KEY `defect` (`defect_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



#
# Dumping data for table 'verifyresults'
#
INSERT INTO verifyresults VALUES(13,"2005-11-29 18:26:33","Pass","0","0","0","0","0","0","0","0","0","","","","","","","Looks Good","","Enter login information and click Submit button","Home page appears.","","","","1.0","M1133305986","2005-11-29 18:13:06");
INSERT INTO verifyresults VALUES(14,"2005-11-29 18:26:33","Pass","0","0","0","0","0","0","0","0","0","","","","","","","A-okay","","Click the Latest Test Set hyperlink","Results page appears","","","","2.0","M1133305986","2005-11-29 18:13:06");
INSERT INTO verifyresults VALUES(15,"2005-11-29 18:26:33","Pass","0","0","0","0","0","0","0","0","0","","","","","","","Getting close","","Click on the Results link for Demo_Test2","Test Run page should appear.","","","","3.0","M1133305986","2005-11-29 18:13:06");
INSERT INTO verifyresults VALUES(16,"2005-11-29 18:26:33","Fail","0","2","0","0","0","0","0","0","0","","","","","","","Bomb! Again","This is a big problem with no workaround.  Adding a bug.","Click on the TestRunID link","Verification page should appear.","","","","4.0","M1133305986","2005-11-29 18:13:06");