/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.xquery.saxon;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.XmlTokenSource;
import org.apache.xmlbeans.impl.store.SaxonXBeansDelegate;
import org.w3c.dom.Node;

public class XBeansXQuery
implements SaxonXBeansDelegate.QueryInterface {
    private XQueryExpression _xquery;
    private String _query;
    private String _contextVar;
    private StaticQueryContext _stcContext;
    private Configuration config = new Configuration();
    private int boundary;

    public XBeansXQuery(String queryExpr, String contextVar, Integer boundary) {
        this._stcContext = new StaticQueryContext(this.config);
        this._query = queryExpr;
        this._contextVar = contextVar;
        this.boundary = boundary;
        String queryExp = this.boundary == 0 ? "declare variable $" + this._contextVar + " external;" + this._query : this._query.substring(0, this.boundary) + "declare variable $" + this._contextVar + " external;" + this._query.substring(this.boundary);
        try {
            this._xquery = this._stcContext.compileQuery(queryExp);
        }
        catch (TransformerException e) {
            throw new XmlRuntimeException((Throwable)e);
        }
    }

    public List execQuery(Object node, Map variableBindings) {
        try {
            Node context_node = (Node)node;
            DynamicQueryContext dynamicContext = new DynamicQueryContext(this.config);
            dynamicContext.setContextNode((NodeInfo)this._stcContext.buildDocument((Source)new DOMSource(context_node)));
            dynamicContext.setParameter(this._contextVar, (Object)dynamicContext.getContextNode());
            if (variableBindings != null) {
                Iterator it = variableBindings.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (entry.getValue() instanceof XmlTokenSource) {
                        DOMSource domSource = new DOMSource(((XmlTokenSource)entry.getValue()).getDomNode());
                        dynamicContext.setParameter((String)entry.getKey(), (Object)domSource);
                        continue;
                    }
                    if (!(entry.getValue() instanceof String)) continue;
                    dynamicContext.setParameter((String)entry.getKey(), entry.getValue());
                }
            }
            return this._xquery.evaluate(dynamicContext);
        }
        catch (TransformerException e) {
            throw new RuntimeException(" Error binding " + this._contextVar, e);
        }
    }
}

