#!/bin/sh

QUANTIS_ROOT_DIR="`pwd`/../../../.."
DRV_DIR="${QUANTIS_ROOT_DIR}/Drivers/Unix/QuantisPci"

PKG_NAME="IDQpcidrv-2.1-sol10-sparc"

CheckResult()
{
  RESULT=$1
  if [ "${RESULT}" != "0" ]; then
    echo "ERROR $1"
    exit
  else
    echo "OK"
  fi
}

HERE=`pwd`

# Compile driver
cd "${DRV_DIR}"
make clean all
CheckResult $?

cd ${HERE}
mkdir -p opt/IDQQuantis/IDQpcidrv/sparc
CheckResult $?

mkdir -p opt/IDQQuantis/IDQpcidrv/sparcv9
CheckResult $?

cp "${DRV_DIR}/solaris/sparc/quantis" "opt/IDQQuantis/IDQpcidrv/sparc/"
cp "${DRV_DIR}/solaris/sparcv9/quantis" "opt/IDQQuantis/IDQpcidrv/sparcv9/"

# Creates proto
echo "Creating prototype..."
echo "i pkginfo=./pkginfo" > prototype
echo "i postinstall=./postinstall" >> prototype
echo "i preremove=./preremove" >> prototype
find opt/ | pkgproto >> prototype
CheckResult $?

echo "f none /kernel/drv/quantis=opt/IDQQuantis/IDQpcidrv/sparc/quantis 0755 root root" >> prototype
echo "f none /kernel/drv/sparcv9/quantis=opt/IDQQuantis/IDQpcidrv/sparcv9/quantis 0644 root root" >> prototype


# Creates package
echo "Creating package..."
pkgmk -o -r .
CheckResult $?

PKG_PATH="`pwd`/../${PKG_NAME}"
echo ${PKG_PATH}
pkgtrans -s /var/spool/pkg "${PKG_PATH}"
CheckResult $?

echo "Package saved to ${PKG_PATH}"

