#!/usr/bin/env python

# -*- coding: utf8 -*- 

#***********************************************************************
# pysycache : a tool for learn to use the mouse
# Copyright (C) 2005-2006 Vincent DEROO (vincent.pysycache@free.fr)
#
# This tool is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#***********************************************************************



import pygame
from pygame.locals import *
import datas
import os
import const



#*******************************************************************************
#                                                                              #
#                                                                              #
#                                   Classes                                    #
#                                                                              #
#                                                                              #
#*******************************************************************************

class BtnMenu(pygame.sprite.Sprite):
	"""This class is for the menus buttons"""
	def __init__(self, left, top, filename, id, btnlarg, btnhaut):
		pygame.sprite.Sprite.__init__(self) 				#call Sprite intializer
		self.image, self.rect = datas.load_png('images', filename)
		(shortname, extension) = os.path.splitext(filename) 
		self.imagename = shortname
		self.rect.left = left
		self.rect.top = top 
		self.id = id
		self.largeur = btnlarg
		self.hauteur = btnhaut

	def showhelp(self, imgdest):
		myfont = os.path.join(const.GRepPysycache, 'fonts', 'FreeSansBold.ttf' )
		font = pygame.font.Font(myfont, 20)
		textcolor = 46, 113, 169
		screen = pygame.display.get_surface()

		myrep = os.path.join(const.GRepPysycache, 'help', const.GMyLocale )

		#joue le fichier d'aide
		if const.GWithSound == 1:
			if const.GWithHelp == 1 :
				dirname = os.path.join('help', const.GMyLocale)
				filename = str(self.id) + '.ogg'
				datas.load_sound(dirname, filename)
		
		#affiche l'aide
		if os.path.isdir(myrep):
			filename = os.path.join(const.GRepPysycache, 'help', const.GMyLocale , str(self.id) + '.txt')
		else :
			filename = os.path.join(const.GRepPysycache, 'help', 'en_EN' , str(self.id) + '.txt')
			
		filename = os.path.join(const.GRepPysycache, 'help', const.GMyLocale , str(self.id) + '.txt')
		if os.path.isfile(filename):
			f = open(filename, 'r')
			lignes  = f.readlines()
			cptligne = 0;
			for j in lignes:
				j = j.strip()
				text = font.render(unicode(j, "utf-8"), 1, textcolor)
				imgdest.blit(text, (304, 354 + 25 * cptligne))
				cptligne = cptligne + 1
			f.close()

			pygame.display.flip()
