/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.profile;

import tim.prune.data.Track;

public abstract class ProfileData {
    protected final Track _track;
    protected boolean _hasData = false;
    protected boolean[] _pointHasData = null;
    protected double[] _pointValues = null;
    protected double _minValue = 0.0;
    protected double _maxValue = 0.0;

    public ProfileData(Track track) {
        this._track = track;
    }

    public boolean hasData() {
        return this._hasData;
    }

    public boolean hasData(int n) {
        return this._hasData && this._pointHasData != null && n >= 0 && n < this._pointHasData.length && this._pointHasData[n];
    }

    public double getData(int n) {
        if (!this.hasData(n)) {
            return 0.0;
        }
        return this._pointValues[n];
    }

    public double getMinValue() {
        return this._minValue;
    }

    public double getMaxValue() {
        return this._maxValue;
    }

    public abstract void init();

    public abstract String getLabel();

    public abstract String getNoDataKey();

    protected void initArrays() {
        int n = this._track.getNumPoints();
        if (this._pointHasData == null || this._pointHasData.length != n) {
            this._pointHasData = new boolean[n];
            this._pointValues = new double[n];
        }
    }
}

