/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.profile;

import tim.prune.I18nManager;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.gui.profile.ProfileData;

public class AltitudeData
extends ProfileData {
    private Altitude.Format _altitudeFormat = Altitude.Format.NO_FORMAT;

    public AltitudeData(Track track) {
        super(track);
    }

    public void init() {
        this.initArrays();
        this._hasData = false;
        this._altitudeFormat = Altitude.Format.NO_FORMAT;
        if (this._track != null) {
            int n = 0;
            while (n < this._track.getNumPoints()) {
                DataPoint dataPoint = this._track.getPoint(n);
                if (dataPoint != null && dataPoint.hasAltitude()) {
                    double d;
                    if (this._altitudeFormat == Altitude.Format.NO_FORMAT) {
                        this._altitudeFormat = dataPoint.getAltitude().getFormat();
                        this._minValue = this._maxValue = (double)dataPoint.getAltitude().getValue();
                    }
                    this._pointValues[n] = d = (double)dataPoint.getAltitude().getValue(this._altitudeFormat);
                    if (d < this._minValue) {
                        this._minValue = d;
                    }
                    if (d > this._maxValue) {
                        this._maxValue = d;
                    }
                    this._hasData = true;
                    this._pointHasData[n] = true;
                } else {
                    this._pointHasData[n] = false;
                }
                ++n;
            }
        }
    }

    public String getLabel() {
        return String.valueOf(I18nManager.getText("fieldname.altitude")) + " (" + I18nManager.getText(this._altitudeFormat == Altitude.Format.FEET ? "units.feet.short" : "units.metres.short") + ")";
    }

    public String getNoDataKey() {
        return "display.noaltitudes";
    }
}

