/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.function.AddMapSourceDialog;
import tim.prune.function.MapSourceListModel;
import tim.prune.gui.map.MapSourceLibrary;

public class SetMapBgFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JList _list = null;
    private MapSourceListModel _listModel = null;
    private String _initialSource = null;
    private JButton _okButton = null;
    private JButton _deleteButton = null;
    private AddMapSourceDialog _addDialog = null;

    public SetMapBgFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.setmapbg";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.initValues();
        this.enableButtons();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(8, 8));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.setmapbg.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 4, 1, 4));
        jPanel.add((Component)jLabel, "North");
        this._listModel = new MapSourceListModel();
        this._list = new JList(this._listModel);
        this._list.setSelectionMode(0);
        jPanel.add((Component)new JScrollPane(this._list), "Center");
        this._list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SetMapBgFunction.this.enableButtons();
            }
        });
        this._list.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                if (keyEvent.getKeyCode() == 27) {
                    SetMapBgFunction.this._dialog.dispose();
                }
            }
        });
        this._list.setPreferredSize(new Dimension(200, 200));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JButton jButton = new JButton(I18nManager.getText("button.addnew"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this.addNewSource();
            }
        });
        jPanel2.add(jButton);
        this._deleteButton = new JButton(I18nManager.getText("button.delete"));
        this._deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this.deleteMapSource(SetMapBgFunction.this._list.getSelectedIndex());
            }
        });
        jPanel2.add(this._deleteButton);
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        jPanel3.add(this._okButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void initValues() {
        this.updateList();
        int n = Config.getConfigInt("prune.mapsource");
        if (n < 0 || n >= this._listModel.getSize()) {
            n = 0;
        }
        this._initialSource = this._listModel.getSource(n).getSiteStrings();
        this._list.setSelectedIndex(n);
    }

    private int getSelectedServer() {
        return this._list.getSelectedIndex();
    }

    private void enableButtons() {
        int n = this.getSelectedServer();
        this._okButton.setEnabled(n >= 0 && n < this._listModel.getSize() && !this._listModel.getSource(n).getSiteStrings().equals(this._initialSource));
        this._deleteButton.setEnabled(n >= MapSourceLibrary.getNumFixedSources() && n < this._listModel.getSize());
    }

    private void addNewSource() {
        if (this._addDialog == null) {
            this._addDialog = new AddMapSourceDialog(this._dialog, this);
        }
        this._addDialog.showDialog();
    }

    private void deleteMapSource(int n) {
        MapSourceLibrary.deleteSource(n);
        this.updateList();
        this.enableButtons();
    }

    public void updateList() {
        this._listModel.fireChanged();
        Config.setConfigString("prune.mapsourcelist", MapSourceLibrary.getConfigString());
    }

    private void finish() {
        int n = this.getSelectedServer();
        if (n < 0) {
            n = 0;
        }
        Config.setConfigInt("prune.mapsource", n);
        UpdateMessageBroker.informSubscribers((byte)64);
        this._dialog.dispose();
    }
}

