/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;

public class DiskCacheConfig
extends GenericFunction {
    private JDialog _dialog = null;
    private JCheckBox _cacheCheckbox = null;
    private JTextField _cacheDirBox = null;
    private JButton _browseButton = null;
    private JButton _okButton = null;
    private boolean _initialCheckState = false;
    private String _initialCacheDir = null;

    public DiskCacheConfig(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.diskcache";
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        this._cacheCheckbox = new JCheckBox(I18nManager.getText("dialog.diskcache.save"));
        this._cacheCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskCacheConfig.this.enableOk();
            }
        });
        jPanel2.add(this._cacheCheckbox);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel(I18nManager.getText("dialog.diskcache.dir")), "West");
        this._cacheDirBox = new JTextField(24);
        this._cacheDirBox.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                DiskCacheConfig.this.enableOk();
            }
        });
        jPanel3.add((Component)this._cacheDirBox, "Center");
        this._browseButton = new JButton(I18nManager.getText("button.browse"));
        this._browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskCacheConfig.this.chooseDir();
            }
        });
        jPanel3.add((Component)this._browseButton, "East");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskCacheConfig.this.finish();
            }
        });
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskCacheConfig.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void enableOk() {
        String string;
        boolean bl = this._cacheCheckbox.isSelected();
        this._cacheDirBox.setEditable(bl);
        this._browseButton.setEnabled(bl);
        boolean bl2 = false;
        bl2 = !this._initialCheckState && !bl ? false : (!bl ? true : !(string = this._cacheDirBox.getText()).equals("") && (this._initialCacheDir == null || !string.equals(this._initialCacheDir)));
        this._okButton.setEnabled(bl2);
    }

    public void begin() {
        String string;
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, I18nManager.getText(this.getNameKey()));
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
        }
        this._cacheCheckbox.setSelected((string = Config.getConfigString("prune.diskcache")) != null);
        this._cacheDirBox.setText(string == null ? "" : string);
        this.enableOk();
        this._initialCheckState = this._cacheCheckbox.isSelected();
        this._dialog.setVisible(true);
    }

    private void chooseDir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        String string = this._cacheDirBox.getText();
        if (string.length() > 1) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        if (jFileChooser.showOpenDialog(this._parentFrame) == 0) {
            this._cacheDirBox.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        this.enableOk();
    }

    private void finish() {
        File file;
        String string;
        String string2 = string = this._cacheCheckbox.isSelected() ? this._cacheDirBox.getText() : null;
        if (!(string == null || (file = new File(string)).exists() && file.isDirectory() || JOptionPane.showConfirmDialog(this._dialog, String.valueOf(I18nManager.getText("dialog.diskcache.createdir")) + ": " + file.getAbsolutePath() + " ?", I18nManager.getText(this.getNameKey()), 2) != 2 && file.mkdir())) {
            JOptionPane.showMessageDialog(this._dialog, I18nManager.getText("dialog.diskcache.nocreate"), I18nManager.getText(this.getNameKey()), 2);
            return;
        }
        Config.setConfigString("prune.diskcache", string);
        UpdateMessageBroker.informSubscribers((byte)64);
        this._dialog.dispose();
    }
}

