/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoLoadPhotos
implements UndoOperation {
    private int _numPhotos = -1;
    private int _numPoints = -1;

    public UndoLoadPhotos(int n, int n2) {
        this._numPhotos = n;
        this._numPoints = n2;
    }

    public String getDescription() {
        String string = I18nManager.getText("undo.loadphotos");
        if (this._numPhotos > 0) {
            string = String.valueOf(string) + " (" + this._numPhotos + ")";
        }
        return string;
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        int n;
        if (this._numPoints > 0) {
            n = trackInfo.getTrack().getNumPoints() - this._numPoints;
            trackInfo.getTrack().cropTo(n);
        }
        n = trackInfo.getPhotoList().getNumPhotos() - this._numPhotos;
        trackInfo.getPhotoList().cropTo(n);
        trackInfo.getSelection().clearAll();
    }
}

