/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tim.prune.App;
import tim.prune.Config;
import tim.prune.ExternalTools;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.save.GpxExporter;

public class GpsSaver
extends GenericFunction
implements Runnable {
    private boolean _gpsBabelChecked = false;
    private JDialog _dialog = null;
    private JTextField _deviceField = null;
    private JTextField _formatField = null;
    private JTextField _trackNameField = null;
    private JCheckBox _waypointCheckbox = null;
    private JCheckBox _trackCheckbox = null;
    private JButton _okButton = null;
    private JProgressBar _progressBar = null;
    private boolean _cancelled = false;

    public GpsSaver(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.sendtogps";
    }

    public void begin() {
        if (this._gpsBabelChecked || ExternalTools.isGpsbabelInstalled() || JOptionPane.showConfirmDialog(this._dialog, I18nManager.getText("dialog.gpsload.nogpsbabel"), I18nManager.getText(this.getNameKey()), 0, 2) == 0) {
            this._gpsBabelChecked = true;
            if (this._dialog == null) {
                this._dialog = new JDialog(this._parentFrame, I18nManager.getText("function.sendtogps"), true);
                this._dialog.setLocationRelativeTo(this._parentFrame);
                this._dialog.setDefaultCloseOperation(2);
                this._dialog.getContentPane().add(this.makeDialogComponents());
                this._dialog.pack();
            }
            this.enableOkButton();
            this.setupProgressBar(true);
            this._dialog.setVisible(true);
        }
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 10, 3));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.gpsload.device"));
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this._deviceField = new JTextField(Config.getGpsDevice(), 12);
        jPanel3.add(this._deviceField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.gpsload.format"));
        jLabel2.setHorizontalAlignment(4);
        jPanel3.add(jLabel2);
        this._formatField = new JTextField(Config.getGpsFormat(), 12);
        jPanel3.add(this._formatField);
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.gpssend.trackname"));
        jLabel3.setHorizontalAlignment(4);
        jPanel3.add(jLabel3);
        this._trackNameField = new JTextField("", 12);
        jPanel3.add(this._trackNameField);
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        jPanel2.add(jPanel3);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GpsSaver.this.enableOkButton();
            }
        };
        this._waypointCheckbox = new JCheckBox(I18nManager.getText("dialog.gpssend.sendwaypoints"), true);
        this._waypointCheckbox.addChangeListener(changeListener);
        this._waypointCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._waypointCheckbox);
        this._trackCheckbox = new JCheckBox(I18nManager.getText("dialog.gpssend.sendtracks"), true);
        this._trackCheckbox.addChangeListener(changeListener);
        this._trackCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._trackCheckbox);
        this._progressBar = new JProgressBar(0, 10);
        jPanel2.add(this._progressBar);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpsSaver.this._cancelled = false;
                new Thread(GpsSaver.this).start();
            }
        });
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpsSaver.this._cancelled = true;
                GpsSaver.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void setupProgressBar(boolean bl) {
        this._progressBar.setVisible(!bl);
        this._progressBar.setIndeterminate(false);
        this._progressBar.setValue(0);
    }

    private void enableOkButton() {
        this._okButton.setEnabled(this._waypointCheckbox.isSelected() || this._trackCheckbox.isSelected());
    }

    public void run() {
        this._okButton.setEnabled(false);
        this.setupProgressBar(false);
        this._progressBar.setIndeterminate(true);
        try {
            this.callGpsBabel();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this._dialog, exception.getMessage(), I18nManager.getText("function.sendtogps"), 0);
            this._cancelled = true;
        }
        this.setupProgressBar(true);
        this.enableOkButton();
        if (!this._cancelled) {
            this._dialog.dispose();
        }
    }

    private void callGpsBabel() throws Exception {
        String[] stringArray = null;
        if (this._waypointCheckbox.isSelected() && this._trackCheckbox.isSelected()) {
            stringArray = new String[]{"gpsbabel", "-w", "-t", "-i", "gpx", "-f", "-", "-o", this._formatField.getText(), "-F", this._deviceField.getText()};
        } else {
            stringArray = new String[]{"gpsbabel", "-w", "-i", "gpx", "-f", "-", "-o", this._formatField.getText(), "-F", this._deviceField.getText()};
            if (this._trackCheckbox.isSelected()) {
                stringArray[1] = "-t";
            }
        }
        String string = "";
        Process process = Runtime.getRuntime().exec(stringArray);
        String string2 = this._trackNameField.getText();
        if (string2 == null || string2.equals("")) {
            string2 = "prune";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(process.getOutputStream());
        GpxExporter.exportData(outputStreamWriter, this._app.getTrackInfo().getTrack(), string2, null, true);
        outputStreamWriter.close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String string3 = null;
        String string4 = "";
        while ((string3 = bufferedReader.readLine()) != null) {
            string4 = String.valueOf(string4) + string3 + "\n";
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {}
        if (string4.length() > 0) {
            string = string4;
        }
        if (string.length() > 0) {
            throw new Exception(string);
        }
    }
}

