/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.data.Altitude;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.XmlHandler;

public class ZipFileLoader {
    private App _app = null;
    XmlFileLoader _xmlLoader = null;

    public ZipFileLoader(App app, XmlFileLoader xmlFileLoader) {
        this._app = app;
        this._xmlLoader = xmlFileLoader;
    }

    public void openFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            boolean bl = false;
            while (enumeration.hasMoreElements() && !bl) {
                String string;
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.toString();
                if (string2 == null || string2.length() <= 4 || !(string = string2.substring(string2.length() - 4).toLowerCase()).equals(".kml") && !string.equals(".gpx") && !string.equals(".xml")) continue;
                this._xmlLoader.reset();
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse(zipFile.getInputStream(zipEntry), (DefaultHandler)this._xmlLoader);
                XmlHandler xmlHandler = this._xmlLoader.getHandler();
                if (xmlHandler == null) {
                    this._app.showErrorMessage("error.load.dialogtitle", "error.load.othererror");
                    continue;
                }
                this._app.informDataLoaded(xmlHandler.getFieldArray(), xmlHandler.getDataArray(), Altitude.Format.METRES, file.getName());
                bl = true;
            }
            zipFile.close();
            if (!bl) {
                this._app.showErrorMessage("error.load.dialogtitle", "error.load.noxmlinzip");
            }
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
    }
}

