/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.Altitude;
import tim.prune.load.xml.GpxHandler;
import tim.prune.load.xml.KmlHandler;
import tim.prune.load.xml.XmlHandler;

public class XmlFileLoader
extends DefaultHandler
implements Runnable {
    private File _file = null;
    private App _app = null;
    private XmlHandler _handler = null;
    private String _unknownType = null;

    public XmlFileLoader(App app) {
        this._app = app;
    }

    public void reset() {
        this._handler = null;
        this._unknownType = null;
    }

    public void openFile(File file) {
        this._file = file;
        this.reset();
        new Thread(this).start();
    }

    public void run() {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(this._file, (DefaultHandler)this);
            if (this._handler == null) {
                this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(I18nManager.getText("error.load.unknownxml")) + " " + this._unknownType);
            } else {
                this._app.informDataLoaded(this._handler.getFieldArray(), this._handler.getDataArray(), Altitude.Format.METRES, this._file.getName());
            }
        }
        catch (Exception exception) {
            this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(I18nManager.getText("error.load.othererror")) + " " + exception.getMessage());
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this._handler == null) {
            if (string3.equals("kml")) {
                this._handler = new KmlHandler();
            } else if (string3.equals("gpx")) {
                this._handler = new GpxHandler();
            } else if (this._unknownType == null && !string3.equals("")) {
                this._unknownType = string3;
            }
        } else {
            this._handler.startElement(string, string2, string3, attributes);
        }
        super.startElement(string, string2, string3, attributes);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._handler != null) {
            this._handler.characters(cArray, n, n2);
        }
        super.characters(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._handler != null) {
            this._handler.endElement(string, string2, string3);
        }
        super.endElement(string, string2, string3);
    }

    public XmlHandler getHandler() {
        return this._handler;
    }
}

