/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import tim.prune.App;
import tim.prune.Config;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.TextFileLoader;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.ZipFileLoader;

public class FileLoader {
    private App _app;
    private JFileChooser _fileChooser = null;
    private JFrame _parentFrame;
    private TextFileLoader _textFileLoader = null;
    private XmlFileLoader _xmlFileLoader = null;
    private ZipFileLoader _zipFileLoader = null;

    public FileLoader(App app, JFrame jFrame) {
        this._app = app;
        this._parentFrame = jFrame;
        this._textFileLoader = new TextFileLoader(app, jFrame);
        this._xmlFileLoader = new XmlFileLoader(app);
        this._zipFileLoader = new ZipFileLoader(app, this._xmlFileLoader);
    }

    public void openFile() {
        File file;
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.txt", new String[]{"txt", "text"}));
            this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.gpx", new String[]{"gpx"}));
            this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.kml", new String[]{"kml"}));
            this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.kmz", new String[]{"kmz"}));
            this._fileChooser.setAcceptAllFileFilterUsed(true);
            file = Config.getWorkingDirectory();
            if (file != null) {
                this._fileChooser.setCurrentDirectory(file);
            }
        }
        if (this._fileChooser.showOpenDialog(this._parentFrame) == 0) {
            file = this._fileChooser.getSelectedFile();
            if (file != null && file.exists() && file.canRead()) {
                Config.setWorkingDirectory(file.getParentFile());
                String string = file.getName().toLowerCase();
                if (string.length() > 4) {
                    string = string.substring(string.length() - 4);
                }
                if (string.equals(".kml") || string.equals(".gpx") || string.equals(".xml")) {
                    this._xmlFileLoader.openFile(file);
                } else if (string.equals(".kmz") || string.equals(".zip")) {
                    this._zipFileLoader.openFile(file);
                } else {
                    this._textFileLoader.openFile(file);
                }
            } else {
                this._app.showErrorMessage("error.load.dialogtitle", "error.load.noread");
            }
        }
    }

    public char getLastUsedDelimiter() {
        return this._textFileLoader.getLastUsedDelimiter();
    }
}

