/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends JTextField {
    public WholeNumberField(int n) {
        super("0");
        this.setDocument(new WholeNumberDocument(n));
    }

    public int getValue() {
        return WholeNumberField.parseValue(this.getText());
    }

    private static int parseValue(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    protected static class WholeNumberDocument
    extends PlainDocument {
        private int _maxDigits = 0;

        public WholeNumberDocument(int n) {
            this._maxDigits = n;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() >= this._maxDigits) {
                return;
            }
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray2.length && n2 < this._maxDigits) {
                if (Character.isDigit(cArray[n3])) {
                    cArray2[n2++] = cArray[n3];
                }
                ++n3;
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

