/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import tim.prune.I18nManager;
import tim.prune.data.Altitude;
import tim.prune.data.AltitudeRange;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.gui.GenericChart;

public class ProfileChart
extends GenericChart {
    private double _xScaleFactor = 0.0;
    private static final int[] ALTITUDE_SCALES = new int[]{10000, 5000, 2000, 1000, 500, 200, 100, 50};
    private static final Color COLOR_LINES = Color.GRAY;
    private static final Color COLOR_ALT_BARS = Color.BLUE;
    private static final Color COLOR_SELECTED = Color.RED;
    private static final Color COLOR_SELECTED_BG = Color.ORANGE;
    private static final Color COLOR_ALT_SCALE = Color.RED;

    public ProfileChart(TrackInfo trackInfo) {
        super(trackInfo);
        this.MINIMUM_SIZE = new Dimension(200, 100);
        this.addMouseListener(this);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._track != null && this._track.getNumPoints() > 0) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            AltitudeRange altitudeRange = this._track.getAltitudeRange();
            int n3 = altitudeRange.getMinimum();
            int n4 = altitudeRange.getMaximum();
            if (n3 < 0 || n4 < 0 || n3 == n4) {
                graphics.setColor(COLOR_LINES);
                graphics.drawString(I18nManager.getText("display.noaltitudes"), 50, n2 / 2);
                return;
            }
            int n5 = this._track.getNumPoints();
            this._xScaleFactor = 1.0 * (double)(n - 16) / (double)n5;
            double d = 1.0 * (double)(n2 - 16) / (double)(altitudeRange.getMaximum() - n3);
            int n6 = (int)(this._xScaleFactor + 1.0);
            int n7 = this._trackInfo.getSelection().getCurrentPointIndex();
            int n8 = this.getLineScale(n3, n4);
            int n9 = 0;
            int n10 = 0;
            if (n8 > 1) {
                graphics.setColor(COLOR_LINES);
                while (n9 < n4) {
                    if (n9 > n3) {
                        n10 = n2 - 8 - (int)(d * (double)(n9 - n3));
                        graphics.drawLine(9, n10, n - 8 - 1, n10);
                    }
                    n9 += n8;
                }
            }
            try {
                Altitude.Format format = altitudeRange.getFormat();
                int n11 = 0;
                while (n11 < n5) {
                    int n12 = (int)(this._xScaleFactor * (double)n11);
                    if (n11 == n7) {
                        graphics.setColor(COLOR_SELECTED_BG);
                        graphics.fillRect(8 + n12, 9, n6, n2 - 16 - 2);
                        graphics.setColor(COLOR_SELECTED);
                    } else {
                        graphics.setColor(COLOR_ALT_BARS);
                    }
                    if (this._track.getPoint(n11).getAltitude().isValid()) {
                        n9 = this._track.getPoint(n11).getAltitude().getValue(format);
                        n10 = (int)(d * (double)(n9 - n3));
                        graphics.fillRect(8 + n12, n2 - 8 - n10, n6, n10);
                    }
                    ++n11;
                }
            }
            catch (NullPointerException nullPointerException) {}
            if (n8 > 1) {
                int n13 = graphics.getFontMetrics().getHeight();
                n9 = 0;
                n10 = 0;
                graphics.setColor(COLOR_ALT_SCALE);
                while (n9 < n4) {
                    if (n9 > n3) {
                        n10 = n2 - 8 - (int)(d * (double)(n9 - n3));
                        if (n10 < 8 + n13) {
                            n10 = 8 + n13;
                        }
                        graphics.drawString("" + n9, 13, n10);
                    }
                    n9 += n8;
                }
            }
        }
    }

    private int getLineScale(int n, int n2) {
        if (n2 - n < 50 || n2 < 0) {
            return -1;
        }
        int n3 = ALTITUDE_SCALES.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            n4 = ALTITUDE_SCALES[n7];
            if (n4 < n2) {
                n5 = 0;
                n6 = 0;
                while (n6 < n2) {
                    if ((n6 += n4) <= n) continue;
                    ++n5;
                }
                if (n5 > 2) {
                    return n4;
                }
            }
            ++n7;
        }
        return ALTITUDE_SCALES[n3 - 1];
    }

    public void dataUpdated(Track track) {
        this._track = track;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._track != null && !mouseEvent.isMetaDown()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n > 8 && n2 > 8 && n < this.getWidth() - 8 && n2 < this.getHeight() - 8) {
                int n3 = (int)((double)(mouseEvent.getX() - 8) / this._xScaleFactor);
                this._trackInfo.getSelection().selectPoint(n3);
            }
        }
    }
}

