/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.data.Photo;
import tim.prune.gui.ImageUtils;

public class PhotoThumbnail
extends JPanel
implements Runnable {
    private Photo _photo = null;
    private BufferedImage _thumbnail = null;
    private int _lastWidth = -1;
    private int _lastHeight = -1;
    private boolean _loadingImage = false;
    private static final String _loadingString = String.valueOf(I18nManager.getText("details.photo.loading")) + " ...";

    public PhotoThumbnail() {
        this.setOpaque(true);
    }

    public void setPhoto(Photo photo) {
        if (this._photo == photo) {
            return;
        }
        this._photo = photo;
        this._thumbnail = null;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._photo != null) {
            if (!(this._thumbnail != null && this.getWidth() == this._lastWidth && this.getHeight() == this._lastHeight || this._loadingImage)) {
                this._loadingImage = true;
                new Thread(this).start();
            }
            this._lastWidth = this.getWidth();
            this._lastHeight = this.getHeight();
            if (this._loadingImage) {
                graphics.setColor(Color.BLACK);
                graphics.drawString(_loadingString, 10, 30);
            } else {
                graphics.drawImage(this._thumbnail, 0, 0, this._thumbnail.getWidth(), this._thumbnail.getHeight(), null);
            }
        }
    }

    public void run() {
        if (this._photo.getExifThumbnail() != null) {
            Image image = new ImageIcon(this._photo.getExifThumbnail()).getImage();
            this._thumbnail = ImageUtils.createScaledImage(image, image.getWidth(null), image.getHeight(null));
            image = null;
        } else {
            int n = this._photo.getWidth();
            int n2 = this._photo.getHeight();
            if (n > -1 && n2 > -1) {
                boolean bl;
                int n3 = Math.min(this.getWidth(), this.getParent().getWidth());
                int n4 = Math.min(this.getHeight(), this.getParent().getHeight());
                Dimension dimension = ImageUtils.getThumbnailSize(n, n2, n3, n4);
                boolean bl2 = bl = this._thumbnail == null || this._thumbnail.getWidth() != dimension.width || this._thumbnail.getHeight() != dimension.height;
                if (dimension.width > 0 && dimension.height > 0 && bl) {
                    Image image = new ImageIcon(this._photo.getFile().getAbsolutePath()).getImage();
                    this._thumbnail = ImageUtils.createScaledImage(image, dimension.width, dimension.height);
                    image = null;
                }
            }
        }
        this._loadingImage = false;
        this.repaint();
    }
}

