/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.Config;
import tim.prune.I18nManager;
import tim.prune.data.Altitude;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.IntegerRange;
import tim.prune.data.Photo;
import tim.prune.data.Selection;
import tim.prune.data.TrackInfo;
import tim.prune.gui.GenericDisplay;
import tim.prune.gui.PhotoThumbnail;

public class DetailsDisplay
extends GenericDisplay {
    private JLabel _indexLabel = null;
    private JLabel _latLabel = null;
    private JLabel _longLabel = null;
    private JLabel _altLabel = null;
    private JLabel _nameLabel = null;
    private JLabel _timeLabel = null;
    private JLabel _speedLabel = null;
    private JLabel _rangeLabel = null;
    private JLabel _distanceLabel = null;
    private JLabel _movingDistanceLabel = null;
    private JLabel _durationLabel = null;
    private JLabel _altRangeLabel = null;
    private JLabel _updownLabel = null;
    private JLabel _aveSpeedLabel = null;
    private JLabel _aveMovingSpeedLabel = null;
    private JLabel _photoLabel = null;
    private PhotoThumbnail _photoThumbnail = null;
    private JLabel _photoTimestampLabel = null;
    private JLabel _photoConnectedLabel = null;
    private JComboBox _coordFormatDropdown = null;
    private JComboBox _distUnitsDropdown = null;
    private NumberFormat _distanceFormatter = NumberFormat.getInstance();
    private static final String LABEL_POINT_SELECTED = String.valueOf(I18nManager.getText("details.index.selected")) + ": ";
    private static final String LABEL_POINT_LATITUDE = String.valueOf(I18nManager.getText("fieldname.latitude")) + ": ";
    private static final String LABEL_POINT_LONGITUDE = String.valueOf(I18nManager.getText("fieldname.longitude")) + ": ";
    private static final String LABEL_POINT_ALTITUDE = String.valueOf(I18nManager.getText("fieldname.altitude")) + ": ";
    private static final String LABEL_POINT_TIMESTAMP = String.valueOf(I18nManager.getText("fieldname.timestamp")) + ": ";
    private static final String LABEL_POINT_WAYPOINTNAME = String.valueOf(I18nManager.getText("fieldname.waypointname")) + ": ";
    private static final String LABEL_RANGE_SELECTED = String.valueOf(I18nManager.getText("details.range.selected")) + ": ";
    private static final String LABEL_RANGE_DURATION = String.valueOf(I18nManager.getText("fieldname.duration")) + ": ";
    private static final String LABEL_RANGE_DISTANCE = String.valueOf(I18nManager.getText("fieldname.distance")) + ": ";
    private static final String LABEL_RANGE_MOVINGDISTANCE = String.valueOf(I18nManager.getText("fieldname.movingdistance")) + ": ";
    private static final String LABEL_RANGE_ALTITUDE = String.valueOf(I18nManager.getText("fieldname.altitude")) + ": ";
    private static final String LABEL_RANGE_CLIMB = String.valueOf(I18nManager.getText("details.range.climb")) + ": ";
    private static final String LABEL_RANGE_DESCENT = ", " + I18nManager.getText("details.range.descent") + ": ";
    private static String LABEL_POINT_ALTITUDE_UNITS = null;
    private static Altitude.Format LABEL_POINT_ALTITUDE_FORMAT = Altitude.Format.NO_FORMAT;

    public DetailsDisplay(TrackInfo trackInfo) {
        super(trackInfo);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        JLabel jLabel = new JLabel(I18nManager.getText("details.pointdetails"));
        Font font = jLabel.getFont();
        font = font.deriveFont(1, font.getSize2D() + 2.0f);
        jLabel.setFont(font);
        jPanel2.add(jLabel);
        this._indexLabel = new JLabel(I18nManager.getText("details.nopointselection"));
        jPanel2.add(this._indexLabel);
        this._latLabel = new JLabel("");
        jPanel2.add(this._latLabel);
        this._longLabel = new JLabel("");
        jPanel2.add(this._longLabel);
        this._altLabel = new JLabel("");
        jPanel2.add(this._altLabel);
        this._timeLabel = new JLabel("");
        jPanel2.add(this._timeLabel);
        this._speedLabel = new JLabel("");
        jPanel2.add(this._speedLabel);
        this._nameLabel = new JLabel("");
        jPanel2.add(this._nameLabel);
        jPanel2.setAlignmentX(0.0f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        JLabel jLabel2 = new JLabel(I18nManager.getText("details.rangedetails"));
        jLabel2.setFont(font);
        jPanel3.add(jLabel2);
        this._rangeLabel = new JLabel(I18nManager.getText("details.norangeselection"));
        jPanel3.add(this._rangeLabel);
        this._distanceLabel = new JLabel("");
        jPanel3.add(this._distanceLabel);
        this._movingDistanceLabel = new JLabel("");
        jPanel3.add(this._movingDistanceLabel);
        this._durationLabel = new JLabel("");
        jPanel3.add(this._durationLabel);
        this._aveSpeedLabel = new JLabel("");
        jPanel3.add(this._aveSpeedLabel);
        this._aveMovingSpeedLabel = new JLabel("");
        jPanel3.add(this._aveMovingSpeedLabel);
        this._altRangeLabel = new JLabel("");
        jPanel3.add(this._altRangeLabel);
        this._updownLabel = new JLabel("");
        jPanel3.add(this._updownLabel);
        jPanel3.setAlignmentX(0.0f);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        JLabel jLabel3 = new JLabel(I18nManager.getText("details.photodetails"));
        jLabel3.setFont(font);
        jPanel4.add(jLabel3);
        this._photoLabel = new JLabel(I18nManager.getText("details.nophoto"));
        jPanel4.add(this._photoLabel);
        this._photoTimestampLabel = new JLabel("");
        jPanel4.add(this._photoTimestampLabel);
        this._photoConnectedLabel = new JLabel("");
        jPanel4.add(this._photoConnectedLabel);
        this._photoThumbnail = new PhotoThumbnail();
        this._photoThumbnail.setVisible(false);
        this._photoThumbnail.setPreferredSize(new Dimension(100, 100));
        jPanel4.add(this._photoThumbnail);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jPanel4);
        jPanel.add(Box.createVerticalStrut(5));
        this.add((Component)jPanel, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        JLabel jLabel4 = new JLabel(String.valueOf(I18nManager.getText("details.coordformat")) + ": ");
        jLabel4.setAlignmentX(0.0f);
        jPanel5.add(jLabel4);
        String[] stringArray = new String[]{I18nManager.getText("units.original"), I18nManager.getText("units.degminsec"), I18nManager.getText("units.degmin"), I18nManager.getText("units.deg")};
        this._coordFormatDropdown = new JComboBox<String>(stringArray);
        this._coordFormatDropdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailsDisplay.this.dataUpdated((byte)32);
            }
        });
        jPanel5.add(this._coordFormatDropdown);
        this._coordFormatDropdown.setAlignmentX(0.0f);
        JLabel jLabel5 = new JLabel(String.valueOf(I18nManager.getText("details.distanceunits")) + ": ");
        jLabel5.setAlignmentX(0.0f);
        jPanel5.add(jLabel5);
        String[] stringArray2 = new String[]{I18nManager.getText("units.kilometres"), I18nManager.getText("units.miles")};
        this._distUnitsDropdown = new JComboBox<String>(stringArray2);
        if (!Config.getUseMetricUnits()) {
            this._distUnitsDropdown.setSelectedIndex(1);
        }
        this._distUnitsDropdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailsDisplay.this.dataUpdated((byte)32);
                Config.setUseMetricUnits(DetailsDisplay.this._distUnitsDropdown.getSelectedIndex() == 0);
            }
        });
        jPanel5.add(this._distUnitsDropdown);
        this._distUnitsDropdown.setAlignmentX(0.0f);
        this.add((Component)jPanel5, "South");
    }

    public void dataUpdated(byte by) {
        Object object;
        Object object2;
        DataPoint dataPoint = this._trackInfo.getCurrentPoint();
        Selection selection = this._trackInfo.getSelection();
        int n = selection.getCurrentPointIndex();
        this._speedLabel.setText("");
        Distance.Units units = this._distUnitsDropdown.getSelectedIndex() == 0 ? Distance.Units.KILOMETRES : Distance.Units.MILES;
        String string = I18nManager.getText(this._distUnitsDropdown.getSelectedIndex() == 0 ? "units.kilometres.short" : "units.miles.short");
        String string2 = I18nManager.getText(this._distUnitsDropdown.getSelectedIndex() == 0 ? "units.kmh" : "units.mph");
        if (this._track == null || dataPoint == null) {
            this._indexLabel.setText(I18nManager.getText("details.nopointselection"));
            this._latLabel.setText("");
            this._longLabel.setText("");
            this._altLabel.setText("");
            this._timeLabel.setText("");
            this._nameLabel.setText("");
        } else {
            this._indexLabel.setText(String.valueOf(LABEL_POINT_SELECTED) + (n + 1) + " " + I18nManager.getText("details.index.of") + " " + this._track.getNumPoints());
            this._latLabel.setText(DetailsDisplay.makeCoordinateLabel(LABEL_POINT_LATITUDE, dataPoint.getLatitude(), this._coordFormatDropdown.getSelectedIndex()));
            this._longLabel.setText(DetailsDisplay.makeCoordinateLabel(LABEL_POINT_LONGITUDE, dataPoint.getLongitude(), this._coordFormatDropdown.getSelectedIndex()));
            this._altLabel.setText(dataPoint.hasAltitude() ? String.valueOf(LABEL_POINT_ALTITUDE) + dataPoint.getAltitude().getValue() + DetailsDisplay.getAltitudeUnitsLabel(dataPoint.getAltitude().getFormat()) : "");
            if (dataPoint.getTimestamp().isValid()) {
                if (n > 0 && n < this._trackInfo.getTrack().getNumPoints() - 1) {
                    long l;
                    object2 = this._trackInfo.getTrack().getPoint(n - 1);
                    object = this._trackInfo.getTrack().getPoint(n + 1);
                    if (((DataPoint)object2).getTimestamp().isValid() && ((DataPoint)object).getTimestamp().isValid() && (l = ((DataPoint)object).getTimestamp().getSecondsSince(((DataPoint)object2).getTimestamp())) < 1000L && l > 0L) {
                        double d = DataPoint.calculateRadiansBetween((DataPoint)object2, dataPoint) + DataPoint.calculateRadiansBetween(dataPoint, (DataPoint)object);
                        double d2 = Distance.convertRadiansToDistance(d, units);
                        String string3 = String.valueOf(this.roundedNumber(3600.0 * d2 / (double)l)) + " " + string2;
                        this._speedLabel.setText(String.valueOf(I18nManager.getText("fieldname.speed")) + ": " + string3);
                    }
                }
                this._timeLabel.setText(String.valueOf(LABEL_POINT_TIMESTAMP) + dataPoint.getTimestamp().getText());
            } else {
                this._timeLabel.setText("");
            }
            object2 = dataPoint.getWaypointName();
            if (object2 != null && !((String)object2).equals("")) {
                this._nameLabel.setText(String.valueOf(LABEL_POINT_WAYPOINTNAME) + (String)object2);
            } else {
                this._nameLabel.setText("");
            }
        }
        if (this._track == null || !selection.hasRangeSelected()) {
            this._rangeLabel.setText(I18nManager.getText("details.norangeselection"));
            this._distanceLabel.setText("");
            this._movingDistanceLabel.setText("");
            this._durationLabel.setText("");
            this._altRangeLabel.setText("");
            this._updownLabel.setText("");
            this._aveSpeedLabel.setText("");
            this._aveMovingSpeedLabel.setText("");
        } else {
            this._rangeLabel.setText(String.valueOf(LABEL_RANGE_SELECTED) + (selection.getStart() + 1) + " " + I18nManager.getText("details.range.to") + " " + (selection.getEnd() + 1));
            this._distanceLabel.setText(String.valueOf(LABEL_RANGE_DISTANCE) + this.roundedNumber(selection.getDistance(units)) + " " + string);
            this._movingDistanceLabel.setText(String.valueOf(LABEL_RANGE_MOVINGDISTANCE) + this.roundedNumber(selection.getMovingDistance(units)) + " " + string);
            if (selection.getNumSeconds() > 0L) {
                this._durationLabel.setText(String.valueOf(LABEL_RANGE_DURATION) + DetailsDisplay.buildDurationString(selection.getNumSeconds()));
                this._aveSpeedLabel.setText(String.valueOf(I18nManager.getText("details.range.avespeed")) + ": " + this.roundedNumber(selection.getDistance(units) / (double)selection.getNumSeconds() * 3600.0) + " " + string2);
                this._aveMovingSpeedLabel.setText(String.valueOf(I18nManager.getText("details.range.avemovingspeed")) + ": " + this.roundedNumber(selection.getMovingDistance(units) / (double)selection.getMovingSeconds() * 3600.0) + " " + string2);
            } else {
                this._durationLabel.setText("");
                this._aveSpeedLabel.setText("");
                this._aveMovingSpeedLabel.setText("");
            }
            object2 = DetailsDisplay.getAltitudeUnitsLabel(selection.getAltitudeFormat());
            object = selection.getAltitudeRange();
            if (((IntegerRange)object).getMinimum() >= 0 && ((IntegerRange)object).getMaximum() >= 0) {
                this._altRangeLabel.setText(String.valueOf(LABEL_RANGE_ALTITUDE) + ((IntegerRange)object).getMinimum() + (String)object2 + " " + I18nManager.getText("details.altitude.to") + " " + ((IntegerRange)object).getMaximum() + (String)object2);
                this._updownLabel.setText(String.valueOf(LABEL_RANGE_CLIMB) + selection.getClimb() + (String)object2 + LABEL_RANGE_DESCENT + selection.getDescent() + (String)object2);
            } else {
                this._altRangeLabel.setText("");
                this._updownLabel.setText("");
            }
        }
        object2 = this._trackInfo.getPhotoList().getPhoto(this._trackInfo.getSelection().getCurrentPhotoIndex());
        if (this._track == null || (dataPoint == null || dataPoint.getPhoto() == null) && object2 == null) {
            this._photoLabel.setText(I18nManager.getText("details.nophoto"));
            this._photoTimestampLabel.setText("");
            this._photoConnectedLabel.setText("");
            this._photoThumbnail.setVisible(false);
        } else {
            if (object2 == null) {
                object2 = dataPoint.getPhoto();
            }
            this._photoLabel.setText(String.valueOf(I18nManager.getText("details.photofile")) + ": " + ((Photo)object2).getFile().getName());
            this._photoLabel.setText(String.valueOf(LABEL_POINT_TIMESTAMP) + ((Photo)object2).getTimestamp().getText());
            this._photoConnectedLabel.setText(String.valueOf(I18nManager.getText("details.photo.connected")) + ": " + (((Photo)object2).getCurrentStatus() == Photo.Status.NOT_CONNECTED ? I18nManager.getText("dialog.about.no") : I18nManager.getText("dialog.about.yes")));
            this._photoThumbnail.setVisible(true);
            this._photoThumbnail.setPhoto((Photo)object2);
        }
        this._photoThumbnail.repaint();
    }

    private static String getAltitudeUnitsLabel(Altitude.Format format) {
        if (format == LABEL_POINT_ALTITUDE_FORMAT && LABEL_POINT_ALTITUDE_UNITS != null) {
            return LABEL_POINT_ALTITUDE_UNITS;
        }
        LABEL_POINT_ALTITUDE_FORMAT = format;
        if (format == Altitude.Format.METRES) {
            return " " + I18nManager.getText("units.metres.short");
        }
        return " " + I18nManager.getText("units.feet.short");
    }

    private static String makeCoordinateLabel(String string, Coordinate coordinate, int n) {
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = coordinate.output(10);
                break;
            }
            case 2: {
                string2 = coordinate.output(11);
                break;
            }
            case 3: {
                string2 = coordinate.output(12);
                break;
            }
            default: {
                string2 = coordinate.output(19);
            }
        }
        return String.valueOf(string) + string2;
    }

    private static String buildDurationString(long l) {
        if (l <= 0L) {
            return "";
        }
        if (l < 60L) {
            return l + I18nManager.getText("display.range.time.secs");
        }
        if (l < 3600L) {
            return l / 60L + I18nManager.getText("display.range.time.mins") + " " + l % 60L + I18nManager.getText("display.range.time.secs");
        }
        if (l < 86400L) {
            return l / 60L / 60L + I18nManager.getText("display.range.time.hours") + " " + l / 60L % 60L + I18nManager.getText("display.range.time.mins");
        }
        if (l < 432000L) {
            return l / 86400L + I18nManager.getText("display.range.time.days") + " " + l / 60L / 60L + I18nManager.getText("display.range.time.hours");
        }
        if (l < 8640000L) {
            return l / 86400L + I18nManager.getText("display.range.time.days");
        }
        return "big";
    }

    private String roundedNumber(double d) {
        int n = 0;
        if (d < 1.0) {
            n = 3;
        } else if (d < 10.0) {
            n = 2;
        } else if (d < 100.0) {
            n = 1;
        }
        this._distanceFormatter.setMaximumFractionDigits(n);
        this._distanceFormatter.setMinimumFractionDigits(n);
        return this._distanceFormatter.format(d);
    }
}

